package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Teammembership;
import microsoft.dynamics.crm.entity.request.TeammembershipRequest;

public class TeammembershipCollectionRequest extends CollectionPageEntityRequest<Teammembership, TeammembershipRequest>{

    protected ContextPath contextPath;

    public TeammembershipCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Teammembership.class, cp -> new TeammembershipRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

}
