package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Syncerror;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class SyncerrorCollectionRequest extends CollectionPageEntityRequest<Syncerror, SyncerrorRequest>{

    protected ContextPath contextPath;

    public SyncerrorCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Syncerror.class, cp -> new SyncerrorRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest syncError_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SyncError_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest syncError_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("SyncError_SyncErrors"), Optional.empty());
    }

}
