package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Socialactivity;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class SocialactivityCollectionRequest extends CollectionPageEntityRequest<Socialactivity, SocialactivityRequest>{

    protected ContextPath contextPath;

    public SocialactivityCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Socialactivity.class, cp -> new SocialactivityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ConnectionRequest socialactivity_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("socialactivity_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest socialactivity_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("socialactivity_connections2"), Optional.empty());
    }

    public ProcesssessionRequest socialActivity_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("SocialActivity_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest socialActivity_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("SocialActivity_ProcessSessions"), Optional.empty());
    }

    public AsyncoperationRequest socialActivity_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SocialActivity_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest socialActivity_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("SocialActivity_AsyncOperations"), Optional.empty());
    }

    public ActivitypartyRequest socialactivity_activity_parties(UUID activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("socialactivity_activity_parties").addKeys(new NameValue(activitypartyid, UUID.class)), Optional.empty());
    }

    public ActivitypartyCollectionRequest socialactivity_activity_parties() {
        return new ActivitypartyCollectionRequest(contextPath.addSegment("socialactivity_activity_parties"), Optional.empty());
    }

    public SyncerrorRequest socialActivity_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SocialActivity_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest socialActivity_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("SocialActivity_SyncErrors"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_socialactivity(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_socialactivity").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_socialactivity() {
        return new SlakpiinstanceCollectionRequest(contextPath.addSegment("slakpiinstance_socialactivity"), Optional.empty());
    }

    public BulkdeletefailureRequest socialActivity_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("SocialActivity_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest socialActivity_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("SocialActivity_BulkDeleteFailures"), Optional.empty());
    }

    public ConnectionRequest socialactivity_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("socialactivity_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest socialactivity_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("socialactivity_connections1"), Optional.empty());
    }

    public AnnotationRequest socialActivity_Annotation(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("SocialActivity_Annotation").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest socialActivity_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("SocialActivity_Annotation"), Optional.empty());
    }

    public DuplicaterecordRequest socialActivity_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SocialActivity_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest socialActivity_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("SocialActivity_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest socialActivity_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SocialActivity_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest socialActivity_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("SocialActivity_DuplicateMatchingRecord"), Optional.empty());
    }

    public QueueitemRequest socialActivity_QueueItem(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("SocialActivity_QueueItem").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest socialActivity_QueueItem() {
        return new QueueitemCollectionRequest(contextPath.addSegment("SocialActivity_QueueItem"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest socialactivity_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("socialactivity_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest socialactivity_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("socialactivity_principalobjectattributeaccess"), Optional.empty());
    }

}
