package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_knowledgearticletemplate;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_knowledgearticletemplateCollectionRequest extends CollectionPageEntityRequest<Msdyn_knowledgearticletemplate, Msdyn_knowledgearticletemplateRequest>{

    protected ContextPath contextPath;

    public Msdyn_knowledgearticletemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_knowledgearticletemplate.class, cp -> new Msdyn_knowledgearticletemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest msdyn_knowledgearticletemplate_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_knowledgearticletemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_knowledgearticletemplate_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_knowledgearticletemplate_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_knowledgearticletemplate_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_knowledgearticletemplate_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_DuplicateBaseRecord"), Optional.empty());
    }

    public SharepointdocumentlocationRequest msdyn_knowledgearticletemplate_SharePointDocumentLocations(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_SharePointDocumentLocations").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest msdyn_knowledgearticletemplate_SharePointDocumentLocations() {
        return new SharepointdocumentlocationCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_SharePointDocumentLocations"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_knowledgearticletemplate_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_knowledgearticletemplate_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_knowledgearticletemplate_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_knowledgearticletemplate_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_knowledgearticletemplate_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_knowledgearticletemplate_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_knowledgearticletemplate_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_knowledgearticletemplate_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public QueueitemRequest msdyn_knowledgearticletemplate_QueueItems(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_QueueItems").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest msdyn_knowledgearticletemplate_QueueItems() {
        return new QueueitemCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_QueueItems"), Optional.empty());
    }

}
