package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_analysiscomponent;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysiscomponentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_analysiscomponentCollectionRequest extends CollectionPageEntityRequest<Msdyn_analysiscomponent, Msdyn_analysiscomponentRequest>{

    protected ContextPath contextPath;

    public Msdyn_analysiscomponentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_analysiscomponent.class, cp -> new Msdyn_analysiscomponentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest msdyn_analysiscomponent_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_analysiscomponent_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_analysiscomponent_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_analysiscomponent_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_analysiscomponent_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_analysiscomponent_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_analysiscomponent_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_analysiscomponent_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_analysiscomponent_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_analysiscomponent_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_analysiscomponent_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_analysiscomponent_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_analysiscomponent_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_analysiscomponent_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_analysiscomponent_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_analysiscomponent_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_analysiscomponent_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_analysiscomponent_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_analysiscomponent_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_analysiscomponent_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_analysiscomponent_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_analysiscomponent_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_analysiscomponent_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_analysiscomponent_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_analysiscomponent_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_analysiscomponent_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_analysiscomponent_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_analysiscomponent_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_analysiscomponent_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_analysiscomponent_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_analysiscomponent_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_analysiscomponent_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public Msdyn_analysisresultRequest msdyn_analysiscomponent_msdyn_analysisresult(UUID msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("msdyn_analysiscomponent_msdyn_analysisresult").addKeys(new NameValue(msdyn_analysisresultid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultCollectionRequest msdyn_analysiscomponent_msdyn_analysisresult() {
        return new Msdyn_analysisresultCollectionRequest(contextPath.addSegment("msdyn_analysiscomponent_msdyn_analysisresult"), Optional.empty());
    }

}
