package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Columnmapping;
import microsoft.dynamics.crm.entity.request.ColumnmappingRequest;
import microsoft.dynamics.crm.entity.request.LookupmappingRequest;
import microsoft.dynamics.crm.entity.request.PicklistmappingRequest;

public class ColumnmappingCollectionRequest extends CollectionPageEntityRequest<Columnmapping, ColumnmappingRequest>{

    protected ContextPath contextPath;

    public ColumnmappingCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Columnmapping.class, cp -> new ColumnmappingRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PicklistmappingRequest pickListMapping_ColumnMapping(UUID picklistmappingid) {
        return new PicklistmappingRequest(contextPath.addSegment("PickListMapping_ColumnMapping").addKeys(new NameValue(picklistmappingid, UUID.class)), Optional.empty());
    }

    public PicklistmappingCollectionRequest pickListMapping_ColumnMapping() {
        return new PicklistmappingCollectionRequest(contextPath.addSegment("PickListMapping_ColumnMapping"), Optional.empty());
    }

    public LookupmappingRequest lookUpMapping_ColumnMapping(UUID lookupmappingid) {
        return new LookupmappingRequest(contextPath.addSegment("LookUpMapping_ColumnMapping").addKeys(new NameValue(lookupmappingid, UUID.class)), Optional.empty());
    }

    public LookupmappingCollectionRequest lookUpMapping_ColumnMapping() {
        return new LookupmappingCollectionRequest(contextPath.addSegment("LookUpMapping_ColumnMapping"), Optional.empty());
    }

}
