package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Bulkdeleteoperation;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.BulkdeleteoperationRequest;

public class BulkdeleteoperationCollectionRequest extends CollectionPageEntityRequest<Bulkdeleteoperation, BulkdeleteoperationRequest>{

    protected ContextPath contextPath;

    public BulkdeleteoperationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Bulkdeleteoperation.class, cp -> new BulkdeleteoperationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public BulkdeletefailureRequest bulkDeleteOperation_BulkDeleteFailure(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("BulkDeleteOperation_BulkDeleteFailure").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest bulkDeleteOperation_BulkDeleteFailure() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("BulkDeleteOperation_BulkDeleteFailure"), Optional.empty());
    }

}
