package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.FlowsessionRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedby_value", 
    "data", 
    "metadata", 
    "overriddencreatedon", 
    "createdon", 
    "_owningbusinessunit_value", 
    "_createdonbehalfby_value", 
    "_modifiedonbehalfby_value", 
    "statuscode", 
    "statecode", 
    "timezoneruleversionnumber", 
    "utcconversiontimezonecode", 
    "_process_value", 
    "importsequencenumber", 
    "type", 
    "mimetype", 
    "_owninguser_value", 
    "_createdby_value", 
    "_owningteam_value", 
    "modifiedon", 
    "_ownerid_value", 
    "_flowsessionid_value", 
    "workflowbinaryid", 
    "referencename", 
    "name", 
    "versionnumber", 
    "data_name"})
@JsonInclude(Include.NON_NULL)
public class Workflowbinary extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.workflowbinary";
    }

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("data")
    protected byte[] data;

    @JsonProperty("metadata")
    protected String metadata;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_process_value")
    protected UUID _process_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("mimetype")
    protected String mimetype;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("_flowsessionid_value")
    protected UUID _flowsessionid_value;

    @JsonProperty("workflowbinaryid")
    protected UUID workflowbinaryid;

    @JsonProperty("referencename")
    protected String referencename;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("data_name")
    protected String data_name;

    protected Workflowbinary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkflowbinary() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _modifiedby_value;
        private byte[] data;
        private String metadata;
        private OffsetDateTime overriddencreatedon;
        private OffsetDateTime createdon;
        private UUID _owningbusinessunit_value;
        private UUID _createdonbehalfby_value;
        private UUID _modifiedonbehalfby_value;
        private Integer statuscode;
        private Integer statecode;
        private Integer timezoneruleversionnumber;
        private Integer utcconversiontimezonecode;
        private UUID _process_value;
        private Integer importsequencenumber;
        private String type;
        private String mimetype;
        private UUID _owninguser_value;
        private UUID _createdby_value;
        private UUID _owningteam_value;
        private OffsetDateTime modifiedon;
        private UUID _ownerid_value;
        private UUID _flowsessionid_value;
        private UUID workflowbinaryid;
        private String referencename;
        private String name;
        private Long versionnumber;
        private String data_name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            this.changedFields = changedFields.add("data");
            return this;
        }

        public Builder metadata(String metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _process_value(UUID _process_value) {
            this._process_value = _process_value;
            this.changedFields = changedFields.add("_process_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder mimetype(String mimetype) {
            this.mimetype = mimetype;
            this.changedFields = changedFields.add("mimetype");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _flowsessionid_value(UUID _flowsessionid_value) {
            this._flowsessionid_value = _flowsessionid_value;
            this.changedFields = changedFields.add("_flowsessionid_value");
            return this;
        }

        public Builder workflowbinaryid(UUID workflowbinaryid) {
            this.workflowbinaryid = workflowbinaryid;
            this.changedFields = changedFields.add("workflowbinaryid");
            return this;
        }

        public Builder referencename(String referencename) {
            this.referencename = referencename;
            this.changedFields = changedFields.add("referencename");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder data_name(String data_name) {
            this.data_name = data_name;
            this.changedFields = changedFields.add("data_name");
            return this;
        }

        public Workflowbinary build() {
            Workflowbinary _x = new Workflowbinary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.workflowbinary";
            _x._modifiedby_value = _modifiedby_value;
            _x.data = data;
            _x.metadata = metadata;
            _x.overriddencreatedon = overriddencreatedon;
            _x.createdon = createdon;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.statuscode = statuscode;
            _x.statecode = statecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._process_value = _process_value;
            _x.importsequencenumber = importsequencenumber;
            _x.type = type;
            _x.mimetype = mimetype;
            _x._owninguser_value = _owninguser_value;
            _x._createdby_value = _createdby_value;
            _x._owningteam_value = _owningteam_value;
            _x.modifiedon = modifiedon;
            _x._ownerid_value = _ownerid_value;
            _x._flowsessionid_value = _flowsessionid_value;
            _x.workflowbinaryid = workflowbinaryid;
            _x.referencename = referencename;
            _x.name = name;
            _x.versionnumber = versionnumber;
            _x.data_name = data_name;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && workflowbinaryid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(workflowbinaryid, UUID.class));
        }
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Workflowbinary with_modifiedby_value(UUID _modifiedby_value) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="data")
    @JsonIgnore
    public Optional<byte[]> getData() {
        return Optional.ofNullable(data);
    }

    public Workflowbinary withData(byte[] data) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("data");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.data = data;
        return _x;
    }

    @Property(name="metadata")
    @JsonIgnore
    public Optional<String> getMetadata() {
        return Optional.ofNullable(metadata);
    }

    public Workflowbinary withMetadata(String metadata) {
        Checks.checkIsAscii(metadata);
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("metadata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.metadata = metadata;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Workflowbinary withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Workflowbinary withCreatedon(OffsetDateTime createdon) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Workflowbinary with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Workflowbinary with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Workflowbinary with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Workflowbinary withStatuscode(Integer statuscode) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Workflowbinary withStatecode(Integer statecode) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Workflowbinary withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Workflowbinary withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_process_value")
    @JsonIgnore
    public Optional<UUID> get_process_value() {
        return Optional.ofNullable(_process_value);
    }

    public Workflowbinary with_process_value(UUID _process_value) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("_process_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x._process_value = _process_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Workflowbinary withImportsequencenumber(Integer importsequencenumber) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public Workflowbinary withType(String type) {
        Checks.checkIsAscii(type);
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.type = type;
        return _x;
    }

    @Property(name="mimetype")
    @JsonIgnore
    public Optional<String> getMimetype() {
        return Optional.ofNullable(mimetype);
    }

    public Workflowbinary withMimetype(String mimetype) {
        Checks.checkIsAscii(mimetype);
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("mimetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.mimetype = mimetype;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Workflowbinary with_owninguser_value(UUID _owninguser_value) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Workflowbinary with_createdby_value(UUID _createdby_value) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Workflowbinary with_owningteam_value(UUID _owningteam_value) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Workflowbinary withModifiedon(OffsetDateTime modifiedon) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Workflowbinary with_ownerid_value(UUID _ownerid_value) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_flowsessionid_value")
    @JsonIgnore
    public Optional<UUID> get_flowsessionid_value() {
        return Optional.ofNullable(_flowsessionid_value);
    }

    public Workflowbinary with_flowsessionid_value(UUID _flowsessionid_value) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("_flowsessionid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x._flowsessionid_value = _flowsessionid_value;
        return _x;
    }

    @Property(name="workflowbinaryid")
    @JsonIgnore
    public Optional<UUID> getWorkflowbinaryid() {
        return Optional.ofNullable(workflowbinaryid);
    }

    public Workflowbinary withWorkflowbinaryid(UUID workflowbinaryid) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("workflowbinaryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.workflowbinaryid = workflowbinaryid;
        return _x;
    }

    @Property(name="referencename")
    @JsonIgnore
    public Optional<String> getReferencename() {
        return Optional.ofNullable(referencename);
    }

    public Workflowbinary withReferencename(String referencename) {
        Checks.checkIsAscii(referencename);
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("referencename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.referencename = referencename;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Workflowbinary withName(String name) {
        Checks.checkIsAscii(name);
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.name = name;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Workflowbinary withVersionnumber(Long versionnumber) {
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="data_name")
    @JsonIgnore
    public Optional<String> getData_name() {
        return Optional.ofNullable(data_name);
    }

    public Workflowbinary withData_name(String data_name) {
        Checks.checkIsAscii(data_name);
        Workflowbinary _x = _copy();
        _x.changedFields = changedFields.add("data_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowbinary");
        _x.data_name = data_name;
        return _x;
    }

    public Workflowbinary withUnmappedField(String name, String value) {
        Workflowbinary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="workflowbinary_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getWorkflowbinary_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("workflowbinary_SyncErrors"), RequestHelper.getValue(unmappedFields, "workflowbinary_SyncErrors"));
    }

    @NavigationProperty(name="workflowbinary_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getWorkflowbinary_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("workflowbinary_AsyncOperations"), RequestHelper.getValue(unmappedFields, "workflowbinary_AsyncOperations"));
    }

    @NavigationProperty(name="workflowbinary_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getWorkflowbinary_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("workflowbinary_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "workflowbinary_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="workflowbinary_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getWorkflowbinary_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("workflowbinary_ProcessSession"), RequestHelper.getValue(unmappedFields, "workflowbinary_ProcessSession"));
    }

    @NavigationProperty(name="workflowbinary_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getWorkflowbinary_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("workflowbinary_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "workflowbinary_BulkDeleteFailures"));
    }

    @NavigationProperty(name="workflowbinary_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getWorkflowbinary_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("workflowbinary_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "workflowbinary_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="workflowbinary_FileAttachments")
    @JsonIgnore
    public FileattachmentCollectionRequest getWorkflowbinary_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("workflowbinary_FileAttachments"), RequestHelper.getValue(unmappedFields, "workflowbinary_FileAttachments"));
    }

    @NavigationProperty(name="FlowSessionId")
    @JsonIgnore
    public FlowsessionRequest getFlowSessionId() {
        return new FlowsessionRequest(contextPath.addSegment("FlowSessionId"), RequestHelper.getValue(unmappedFields, "FlowSessionId"));
    }

    @NavigationProperty(name="Process")
    @JsonIgnore
    public WorkflowRequest getProcess() {
        return new WorkflowRequest(contextPath.addSegment("Process"), RequestHelper.getValue(unmappedFields, "Process"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Workflowbinary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Workflowbinary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Workflowbinary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Workflowbinary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Workflowbinary _copy() {
        Workflowbinary _x = new Workflowbinary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedby_value = _modifiedby_value;
        _x.data = data;
        _x.metadata = metadata;
        _x.overriddencreatedon = overriddencreatedon;
        _x.createdon = createdon;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.statuscode = statuscode;
        _x.statecode = statecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._process_value = _process_value;
        _x.importsequencenumber = importsequencenumber;
        _x.type = type;
        _x.mimetype = mimetype;
        _x._owninguser_value = _owninguser_value;
        _x._createdby_value = _createdby_value;
        _x._owningteam_value = _owningteam_value;
        _x.modifiedon = modifiedon;
        _x._ownerid_value = _ownerid_value;
        _x._flowsessionid_value = _flowsessionid_value;
        _x.workflowbinaryid = workflowbinaryid;
        _x.referencename = referencename;
        _x.name = name;
        _x.versionnumber = versionnumber;
        _x.data_name = data_name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Workflowbinary[");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("data=");
        b.append(this.data);
        b.append(", ");
        b.append("metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_process_value=");
        b.append(this._process_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("mimetype=");
        b.append(this.mimetype);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_flowsessionid_value=");
        b.append(this._flowsessionid_value);
        b.append(", ");
        b.append("workflowbinaryid=");
        b.append(this.workflowbinaryid);
        b.append(", ");
        b.append("referencename=");
        b.append(this.referencename);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("data_name=");
        b.append(this.data_name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
