package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.SavedqueryvisualizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ThemeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserqueryvisualizationCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "overwritetime", 
    "solutionid", 
    "versionnumber", 
    "componentstate", 
    "_modifiedonbehalfby_value", 
    "_modifiedby_value", 
    "webresourcetype", 
    "ishidden", 
    "description", 
    "canbedeleted", 
    "introducedversion", 
    "content", 
    "content_binary", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "languagecode", 
    "contentjson", 
    "_createdby_value", 
    "isenabledformobileclient", 
    "webresourceidunique", 
    "webresourceid", 
    "_organizationid_value", 
    "iscustomizable", 
    "dependencyxml", 
    "silverlightversion", 
    "ismanaged", 
    "createdon", 
    "isavailableformobileoffline", 
    "displayname", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class Webresource extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.webresource";
    }

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("webresourcetype")
    protected Integer webresourcetype;

    @JsonProperty("ishidden")
    protected BooleanManagedProperty ishidden;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("canbedeleted")
    protected BooleanManagedProperty canbedeleted;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("content")
    protected String content;

    @JsonProperty("content_binary")
    protected byte[] content_binary;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("languagecode")
    protected Integer languagecode;

    @JsonProperty("contentjson")
    protected String contentjson;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("isenabledformobileclient")
    protected Boolean isenabledformobileclient;

    @JsonProperty("webresourceidunique")
    protected UUID webresourceidunique;

    @JsonProperty("webresourceid")
    protected UUID webresourceid;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("dependencyxml")
    protected String dependencyxml;

    @JsonProperty("silverlightversion")
    protected String silverlightversion;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("isavailableformobileoffline")
    protected Boolean isavailableformobileoffline;

    @JsonProperty("displayname")
    protected String displayname;

    @JsonProperty("name")
    protected String name;

    protected Webresource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWebresource() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime overwritetime;
        private UUID solutionid;
        private Long versionnumber;
        private Integer componentstate;
        private UUID _modifiedonbehalfby_value;
        private UUID _modifiedby_value;
        private Integer webresourcetype;
        private BooleanManagedProperty ishidden;
        private String description;
        private BooleanManagedProperty canbedeleted;
        private String introducedversion;
        private String content;
        private byte[] content_binary;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private Integer languagecode;
        private String contentjson;
        private UUID _createdby_value;
        private Boolean isenabledformobileclient;
        private UUID webresourceidunique;
        private UUID webresourceid;
        private UUID _organizationid_value;
        private BooleanManagedProperty iscustomizable;
        private String dependencyxml;
        private String silverlightversion;
        private Boolean ismanaged;
        private OffsetDateTime createdon;
        private Boolean isavailableformobileoffline;
        private String displayname;
        private String name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder webresourcetype(Integer webresourcetype) {
            this.webresourcetype = webresourcetype;
            this.changedFields = changedFields.add("webresourcetype");
            return this;
        }

        public Builder ishidden(BooleanManagedProperty ishidden) {
            this.ishidden = ishidden;
            this.changedFields = changedFields.add("ishidden");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder canbedeleted(BooleanManagedProperty canbedeleted) {
            this.canbedeleted = canbedeleted;
            this.changedFields = changedFields.add("canbedeleted");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder content_binary(byte[] content_binary) {
            this.content_binary = content_binary;
            this.changedFields = changedFields.add("content_binary");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder languagecode(Integer languagecode) {
            this.languagecode = languagecode;
            this.changedFields = changedFields.add("languagecode");
            return this;
        }

        public Builder contentjson(String contentjson) {
            this.contentjson = contentjson;
            this.changedFields = changedFields.add("contentjson");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder isenabledformobileclient(Boolean isenabledformobileclient) {
            this.isenabledformobileclient = isenabledformobileclient;
            this.changedFields = changedFields.add("isenabledformobileclient");
            return this;
        }

        public Builder webresourceidunique(UUID webresourceidunique) {
            this.webresourceidunique = webresourceidunique;
            this.changedFields = changedFields.add("webresourceidunique");
            return this;
        }

        public Builder webresourceid(UUID webresourceid) {
            this.webresourceid = webresourceid;
            this.changedFields = changedFields.add("webresourceid");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder dependencyxml(String dependencyxml) {
            this.dependencyxml = dependencyxml;
            this.changedFields = changedFields.add("dependencyxml");
            return this;
        }

        public Builder silverlightversion(String silverlightversion) {
            this.silverlightversion = silverlightversion;
            this.changedFields = changedFields.add("silverlightversion");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder isavailableformobileoffline(Boolean isavailableformobileoffline) {
            this.isavailableformobileoffline = isavailableformobileoffline;
            this.changedFields = changedFields.add("isavailableformobileoffline");
            return this;
        }

        public Builder displayname(String displayname) {
            this.displayname = displayname;
            this.changedFields = changedFields.add("displayname");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Webresource build() {
            Webresource _x = new Webresource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.webresource";
            _x.overwritetime = overwritetime;
            _x.solutionid = solutionid;
            _x.versionnumber = versionnumber;
            _x.componentstate = componentstate;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.webresourcetype = webresourcetype;
            _x.ishidden = ishidden;
            _x.description = description;
            _x.canbedeleted = canbedeleted;
            _x.introducedversion = introducedversion;
            _x.content = content;
            _x.content_binary = content_binary;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x.languagecode = languagecode;
            _x.contentjson = contentjson;
            _x._createdby_value = _createdby_value;
            _x.isenabledformobileclient = isenabledformobileclient;
            _x.webresourceidunique = webresourceidunique;
            _x.webresourceid = webresourceid;
            _x._organizationid_value = _organizationid_value;
            _x.iscustomizable = iscustomizable;
            _x.dependencyxml = dependencyxml;
            _x.silverlightversion = silverlightversion;
            _x.ismanaged = ismanaged;
            _x.createdon = createdon;
            _x.isavailableformobileoffline = isavailableformobileoffline;
            _x.displayname = displayname;
            _x.name = name;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && webresourceid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(webresourceid, UUID.class));
        }
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Webresource withOverwritetime(OffsetDateTime overwritetime) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Webresource withSolutionid(UUID solutionid) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Webresource withVersionnumber(Long versionnumber) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Webresource withComponentstate(Integer componentstate) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Webresource with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Webresource with_modifiedby_value(UUID _modifiedby_value) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="webresourcetype")
    @JsonIgnore
    public Optional<Integer> getWebresourcetype() {
        return Optional.ofNullable(webresourcetype);
    }

    public Webresource withWebresourcetype(Integer webresourcetype) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("webresourcetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.webresourcetype = webresourcetype;
        return _x;
    }

    @Property(name="ishidden")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIshidden() {
        return Optional.ofNullable(ishidden);
    }

    public Webresource withIshidden(BooleanManagedProperty ishidden) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("ishidden");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.ishidden = ishidden;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Webresource withDescription(String description) {
        Checks.checkIsAscii(description);
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.description = description;
        return _x;
    }

    @Property(name="canbedeleted")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanbedeleted() {
        return Optional.ofNullable(canbedeleted);
    }

    public Webresource withCanbedeleted(BooleanManagedProperty canbedeleted) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("canbedeleted");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.canbedeleted = canbedeleted;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Webresource withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    public Webresource withContent(String content) {
        Checks.checkIsAscii(content);
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.content = content;
        return _x;
    }

    @Property(name="content_binary")
    @JsonIgnore
    public Optional<byte[]> getContent_binary() {
        return Optional.ofNullable(content_binary);
    }

    public Webresource withContent_binary(byte[] content_binary) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("content_binary");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.content_binary = content_binary;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Webresource with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Webresource withModifiedon(OffsetDateTime modifiedon) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="languagecode")
    @JsonIgnore
    public Optional<Integer> getLanguagecode() {
        return Optional.ofNullable(languagecode);
    }

    public Webresource withLanguagecode(Integer languagecode) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("languagecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.languagecode = languagecode;
        return _x;
    }

    @Property(name="contentjson")
    @JsonIgnore
    public Optional<String> getContentjson() {
        return Optional.ofNullable(contentjson);
    }

    public Webresource withContentjson(String contentjson) {
        Checks.checkIsAscii(contentjson);
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("contentjson");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.contentjson = contentjson;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Webresource with_createdby_value(UUID _createdby_value) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="isenabledformobileclient")
    @JsonIgnore
    public Optional<Boolean> getIsenabledformobileclient() {
        return Optional.ofNullable(isenabledformobileclient);
    }

    public Webresource withIsenabledformobileclient(Boolean isenabledformobileclient) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("isenabledformobileclient");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.isenabledformobileclient = isenabledformobileclient;
        return _x;
    }

    @Property(name="webresourceidunique")
    @JsonIgnore
    public Optional<UUID> getWebresourceidunique() {
        return Optional.ofNullable(webresourceidunique);
    }

    public Webresource withWebresourceidunique(UUID webresourceidunique) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("webresourceidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.webresourceidunique = webresourceidunique;
        return _x;
    }

    @Property(name="webresourceid")
    @JsonIgnore
    public Optional<UUID> getWebresourceid() {
        return Optional.ofNullable(webresourceid);
    }

    public Webresource withWebresourceid(UUID webresourceid) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("webresourceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.webresourceid = webresourceid;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Webresource with_organizationid_value(UUID _organizationid_value) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Webresource withIscustomizable(BooleanManagedProperty iscustomizable) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="dependencyxml")
    @JsonIgnore
    public Optional<String> getDependencyxml() {
        return Optional.ofNullable(dependencyxml);
    }

    public Webresource withDependencyxml(String dependencyxml) {
        Checks.checkIsAscii(dependencyxml);
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("dependencyxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.dependencyxml = dependencyxml;
        return _x;
    }

    @Property(name="silverlightversion")
    @JsonIgnore
    public Optional<String> getSilverlightversion() {
        return Optional.ofNullable(silverlightversion);
    }

    public Webresource withSilverlightversion(String silverlightversion) {
        Checks.checkIsAscii(silverlightversion);
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("silverlightversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.silverlightversion = silverlightversion;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Webresource withIsmanaged(Boolean ismanaged) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Webresource withCreatedon(OffsetDateTime createdon) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="isavailableformobileoffline")
    @JsonIgnore
    public Optional<Boolean> getIsavailableformobileoffline() {
        return Optional.ofNullable(isavailableformobileoffline);
    }

    public Webresource withIsavailableformobileoffline(Boolean isavailableformobileoffline) {
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("isavailableformobileoffline");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.isavailableformobileoffline = isavailableformobileoffline;
        return _x;
    }

    @Property(name="displayname")
    @JsonIgnore
    public Optional<String> getDisplayname() {
        return Optional.ofNullable(displayname);
    }

    public Webresource withDisplayname(String displayname) {
        Checks.checkIsAscii(displayname);
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("displayname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.displayname = displayname;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Webresource withName(String name) {
        Checks.checkIsAscii(name);
        Webresource _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.webresource");
        _x.name = name;
        return _x;
    }

    public Webresource withUnmappedField(String name, String value) {
        Webresource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="solution_configuration_webresource")
    @JsonIgnore
    public SolutionCollectionRequest getSolution_configuration_webresource() {
        return new SolutionCollectionRequest(
                        contextPath.addSegment("solution_configuration_webresource"), RequestHelper.getValue(unmappedFields, "solution_configuration_webresource"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="webresource_userqueryvisualizations")
    @JsonIgnore
    public UserqueryvisualizationCollectionRequest getWebresource_userqueryvisualizations() {
        return new UserqueryvisualizationCollectionRequest(
                        contextPath.addSegment("webresource_userqueryvisualizations"), RequestHelper.getValue(unmappedFields, "webresource_userqueryvisualizations"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="webresource_savedqueryvisualizations")
    @JsonIgnore
    public SavedqueryvisualizationCollectionRequest getWebresource_savedqueryvisualizations() {
        return new SavedqueryvisualizationCollectionRequest(
                        contextPath.addSegment("webresource_savedqueryvisualizations"), RequestHelper.getValue(unmappedFields, "webresource_savedqueryvisualizations"));
    }

    @NavigationProperty(name="lk_theme_logoid")
    @JsonIgnore
    public ThemeCollectionRequest getLk_theme_logoid() {
        return new ThemeCollectionRequest(
                        contextPath.addSegment("lk_theme_logoid"), RequestHelper.getValue(unmappedFields, "lk_theme_logoid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Webresource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Webresource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Webresource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Webresource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Webresource _copy() {
        Webresource _x = new Webresource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.overwritetime = overwritetime;
        _x.solutionid = solutionid;
        _x.versionnumber = versionnumber;
        _x.componentstate = componentstate;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.webresourcetype = webresourcetype;
        _x.ishidden = ishidden;
        _x.description = description;
        _x.canbedeleted = canbedeleted;
        _x.introducedversion = introducedversion;
        _x.content = content;
        _x.content_binary = content_binary;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x.languagecode = languagecode;
        _x.contentjson = contentjson;
        _x._createdby_value = _createdby_value;
        _x.isenabledformobileclient = isenabledformobileclient;
        _x.webresourceidunique = webresourceidunique;
        _x.webresourceid = webresourceid;
        _x._organizationid_value = _organizationid_value;
        _x.iscustomizable = iscustomizable;
        _x.dependencyxml = dependencyxml;
        _x.silverlightversion = silverlightversion;
        _x.ismanaged = ismanaged;
        _x.createdon = createdon;
        _x.isavailableformobileoffline = isavailableformobileoffline;
        _x.displayname = displayname;
        _x.name = name;
        return _x;
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Webresource> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Webresource>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Webresource.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Webresource[");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("webresourcetype=");
        b.append(this.webresourcetype);
        b.append(", ");
        b.append("ishidden=");
        b.append(this.ishidden);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("canbedeleted=");
        b.append(this.canbedeleted);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("content_binary=");
        b.append(this.content_binary);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("languagecode=");
        b.append(this.languagecode);
        b.append(", ");
        b.append("contentjson=");
        b.append(this.contentjson);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("isenabledformobileclient=");
        b.append(this.isenabledformobileclient);
        b.append(", ");
        b.append("webresourceidunique=");
        b.append(this.webresourceidunique);
        b.append(", ");
        b.append("webresourceid=");
        b.append(this.webresourceid);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("dependencyxml=");
        b.append(this.dependencyxml);
        b.append(", ");
        b.append("silverlightversion=");
        b.append(this.silverlightversion);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("isavailableformobileoffline=");
        b.append(this.isavailableformobileoffline);
        b.append(", ");
        b.append("displayname=");
        b.append(this.displayname);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
