package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "timestamp", 
    "date", 
    "timestampdatemappingid"})
@JsonInclude(Include.NON_NULL)
public class Timestampdatemapping extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.timestampdatemapping";
    }

    @JsonProperty("timestamp")
    protected Long timestamp;

    @JsonProperty("date")
    protected OffsetDateTime date;

    @JsonProperty("timestampdatemappingid")
    protected UUID timestampdatemappingid;

    protected Timestampdatemapping() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTimestampdatemapping() {
        return new Builder();
    }

    public static final class Builder {
        private Long timestamp;
        private OffsetDateTime date;
        private UUID timestampdatemappingid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            this.changedFields = changedFields.add("timestamp");
            return this;
        }

        public Builder date(OffsetDateTime date) {
            this.date = date;
            this.changedFields = changedFields.add("date");
            return this;
        }

        public Builder timestampdatemappingid(UUID timestampdatemappingid) {
            this.timestampdatemappingid = timestampdatemappingid;
            this.changedFields = changedFields.add("timestampdatemappingid");
            return this;
        }

        public Timestampdatemapping build() {
            Timestampdatemapping _x = new Timestampdatemapping();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.timestampdatemapping";
            _x.timestamp = timestamp;
            _x.date = date;
            _x.timestampdatemappingid = timestampdatemappingid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && timestampdatemappingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(timestampdatemappingid, UUID.class));
        }
    }

    @Property(name="timestamp")
    @JsonIgnore
    public Optional<Long> getTimestamp() {
        return Optional.ofNullable(timestamp);
    }

    public Timestampdatemapping withTimestamp(Long timestamp) {
        Timestampdatemapping _x = _copy();
        _x.changedFields = changedFields.add("timestamp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timestampdatemapping");
        _x.timestamp = timestamp;
        return _x;
    }

    @Property(name="date")
    @JsonIgnore
    public Optional<OffsetDateTime> getDate() {
        return Optional.ofNullable(date);
    }

    public Timestampdatemapping withDate(OffsetDateTime date) {
        Timestampdatemapping _x = _copy();
        _x.changedFields = changedFields.add("date");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timestampdatemapping");
        _x.date = date;
        return _x;
    }

    @Property(name="timestampdatemappingid")
    @JsonIgnore
    public Optional<UUID> getTimestampdatemappingid() {
        return Optional.ofNullable(timestampdatemappingid);
    }

    public Timestampdatemapping withTimestampdatemappingid(UUID timestampdatemappingid) {
        Timestampdatemapping _x = _copy();
        _x.changedFields = changedFields.add("timestampdatemappingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timestampdatemapping");
        _x.timestampdatemappingid = timestampdatemappingid;
        return _x;
    }

    public Timestampdatemapping withUnmappedField(String name, String value) {
        Timestampdatemapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Timestampdatemapping patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Timestampdatemapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Timestampdatemapping put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Timestampdatemapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Timestampdatemapping _copy() {
        Timestampdatemapping _x = new Timestampdatemapping();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.timestamp = timestamp;
        _x.date = date;
        _x.timestampdatemappingid = timestampdatemappingid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Timestampdatemapping[");
        b.append("timestamp=");
        b.append(this.timestamp);
        b.append(", ");
        b.append("date=");
        b.append(this.date);
        b.append(", ");
        b.append("timestampdatemappingid=");
        b.append(this.timestampdatemappingid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
