package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "subscriptionid", 
    "versionnumber", 
    "track", 
    "objectid", 
    "objecttypecode", 
    "subscriptionmanuallytrackedobjectid"})
@JsonInclude(Include.NON_NULL)
public class Subscriptionmanuallytrackedobject extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.subscriptionmanuallytrackedobject";
    }

    @JsonProperty("subscriptionid")
    protected UUID subscriptionid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("track")
    protected Boolean track;

    @JsonProperty("objectid")
    protected UUID objectid;

    @JsonProperty("objecttypecode")
    protected String objecttypecode;

    @JsonProperty("subscriptionmanuallytrackedobjectid")
    protected UUID subscriptionmanuallytrackedobjectid;

    protected Subscriptionmanuallytrackedobject() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSubscriptionmanuallytrackedobject() {
        return new Builder();
    }

    public static final class Builder {
        private UUID subscriptionid;
        private Long versionnumber;
        private Boolean track;
        private UUID objectid;
        private String objecttypecode;
        private UUID subscriptionmanuallytrackedobjectid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder subscriptionid(UUID subscriptionid) {
            this.subscriptionid = subscriptionid;
            this.changedFields = changedFields.add("subscriptionid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder track(Boolean track) {
            this.track = track;
            this.changedFields = changedFields.add("track");
            return this;
        }

        public Builder objectid(UUID objectid) {
            this.objectid = objectid;
            this.changedFields = changedFields.add("objectid");
            return this;
        }

        public Builder objecttypecode(String objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Builder subscriptionmanuallytrackedobjectid(UUID subscriptionmanuallytrackedobjectid) {
            this.subscriptionmanuallytrackedobjectid = subscriptionmanuallytrackedobjectid;
            this.changedFields = changedFields.add("subscriptionmanuallytrackedobjectid");
            return this;
        }

        public Subscriptionmanuallytrackedobject build() {
            Subscriptionmanuallytrackedobject _x = new Subscriptionmanuallytrackedobject();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.subscriptionmanuallytrackedobject";
            _x.subscriptionid = subscriptionid;
            _x.versionnumber = versionnumber;
            _x.track = track;
            _x.objectid = objectid;
            _x.objecttypecode = objecttypecode;
            _x.subscriptionmanuallytrackedobjectid = subscriptionmanuallytrackedobjectid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && subscriptionmanuallytrackedobjectid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(subscriptionmanuallytrackedobjectid, UUID.class));
        }
    }

    @Property(name="subscriptionid")
    @JsonIgnore
    public Optional<UUID> getSubscriptionid() {
        return Optional.ofNullable(subscriptionid);
    }

    public Subscriptionmanuallytrackedobject withSubscriptionid(UUID subscriptionid) {
        Subscriptionmanuallytrackedobject _x = _copy();
        _x.changedFields = changedFields.add("subscriptionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionmanuallytrackedobject");
        _x.subscriptionid = subscriptionid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Subscriptionmanuallytrackedobject withVersionnumber(Long versionnumber) {
        Subscriptionmanuallytrackedobject _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionmanuallytrackedobject");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="track")
    @JsonIgnore
    public Optional<Boolean> getTrack() {
        return Optional.ofNullable(track);
    }

    public Subscriptionmanuallytrackedobject withTrack(Boolean track) {
        Subscriptionmanuallytrackedobject _x = _copy();
        _x.changedFields = changedFields.add("track");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionmanuallytrackedobject");
        _x.track = track;
        return _x;
    }

    @Property(name="objectid")
    @JsonIgnore
    public Optional<UUID> getObjectid() {
        return Optional.ofNullable(objectid);
    }

    public Subscriptionmanuallytrackedobject withObjectid(UUID objectid) {
        Subscriptionmanuallytrackedobject _x = _copy();
        _x.changedFields = changedFields.add("objectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionmanuallytrackedobject");
        _x.objectid = objectid;
        return _x;
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<String> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Subscriptionmanuallytrackedobject withObjecttypecode(String objecttypecode) {
        Checks.checkIsAscii(objecttypecode);
        Subscriptionmanuallytrackedobject _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionmanuallytrackedobject");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Property(name="subscriptionmanuallytrackedobjectid")
    @JsonIgnore
    public Optional<UUID> getSubscriptionmanuallytrackedobjectid() {
        return Optional.ofNullable(subscriptionmanuallytrackedobjectid);
    }

    public Subscriptionmanuallytrackedobject withSubscriptionmanuallytrackedobjectid(UUID subscriptionmanuallytrackedobjectid) {
        Subscriptionmanuallytrackedobject _x = _copy();
        _x.changedFields = changedFields.add("subscriptionmanuallytrackedobjectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionmanuallytrackedobject");
        _x.subscriptionmanuallytrackedobjectid = subscriptionmanuallytrackedobjectid;
        return _x;
    }

    public Subscriptionmanuallytrackedobject withUnmappedField(String name, String value) {
        Subscriptionmanuallytrackedobject _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subscriptionmanuallytrackedobject patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Subscriptionmanuallytrackedobject _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subscriptionmanuallytrackedobject put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Subscriptionmanuallytrackedobject _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Subscriptionmanuallytrackedobject _copy() {
        Subscriptionmanuallytrackedobject _x = new Subscriptionmanuallytrackedobject();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.subscriptionid = subscriptionid;
        _x.versionnumber = versionnumber;
        _x.track = track;
        _x.objectid = objectid;
        _x.objecttypecode = objecttypecode;
        _x.subscriptionmanuallytrackedobjectid = subscriptionmanuallytrackedobjectid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Subscriptionmanuallytrackedobject[");
        b.append("subscriptionid=");
        b.append(this.subscriptionid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("track=");
        b.append(this.track);
        b.append(", ");
        b.append("objectid=");
        b.append(this.objectid);
        b.append(", ");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append(", ");
        b.append("subscriptionmanuallytrackedobjectid=");
        b.append(this.subscriptionmanuallytrackedobjectid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
