package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.EntityrelationshipRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "solutioncomponentrelationshipconfigurationid", 
    "componentidunique", 
    "overriddencreatedon", 
    "versionnumber", 
    "createdon", 
    "_createdonbehalfby_value", 
    "utcconversiontimezonecode", 
    "_organizationid_value", 
    "_entityrelationshipid_value", 
    "name", 
    "statuscode", 
    "solutionid", 
    "secondaryentitydependencytype", 
    "importsequencenumber", 
    "timezoneruleversionnumber", 
    "overwritetime", 
    "modifiedon", 
    "primaryentitydependencytype", 
    "componentstate", 
    "statecode", 
    "_modifiedonbehalfby_value", 
    "iscustomizable", 
    "_createdby_value", 
    "_modifiedby_value", 
    "ismanaged"})
@JsonInclude(Include.NON_NULL)
public class Solutioncomponentrelationshipconfiguration extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration";
    }

    @JsonProperty("solutioncomponentrelationshipconfigurationid")
    protected UUID solutioncomponentrelationshipconfigurationid;

    @JsonProperty("componentidunique")
    protected UUID componentidunique;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("_entityrelationshipid_value")
    protected UUID _entityrelationshipid_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("secondaryentitydependencytype")
    protected Integer secondaryentitydependencytype;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("primaryentitydependencytype")
    protected Integer primaryentitydependencytype;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    protected Solutioncomponentrelationshipconfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSolutioncomponentrelationshipconfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private UUID solutioncomponentrelationshipconfigurationid;
        private UUID componentidunique;
        private OffsetDateTime overriddencreatedon;
        private Long versionnumber;
        private OffsetDateTime createdon;
        private UUID _createdonbehalfby_value;
        private Integer utcconversiontimezonecode;
        private UUID _organizationid_value;
        private UUID _entityrelationshipid_value;
        private String name;
        private Integer statuscode;
        private UUID solutionid;
        private Integer secondaryentitydependencytype;
        private Integer importsequencenumber;
        private Integer timezoneruleversionnumber;
        private OffsetDateTime overwritetime;
        private OffsetDateTime modifiedon;
        private Integer primaryentitydependencytype;
        private Integer componentstate;
        private Integer statecode;
        private UUID _modifiedonbehalfby_value;
        private BooleanManagedProperty iscustomizable;
        private UUID _createdby_value;
        private UUID _modifiedby_value;
        private Boolean ismanaged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder solutioncomponentrelationshipconfigurationid(UUID solutioncomponentrelationshipconfigurationid) {
            this.solutioncomponentrelationshipconfigurationid = solutioncomponentrelationshipconfigurationid;
            this.changedFields = changedFields.add("solutioncomponentrelationshipconfigurationid");
            return this;
        }

        public Builder componentidunique(UUID componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _entityrelationshipid_value(UUID _entityrelationshipid_value) {
            this._entityrelationshipid_value = _entityrelationshipid_value;
            this.changedFields = changedFields.add("_entityrelationshipid_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder secondaryentitydependencytype(Integer secondaryentitydependencytype) {
            this.secondaryentitydependencytype = secondaryentitydependencytype;
            this.changedFields = changedFields.add("secondaryentitydependencytype");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder primaryentitydependencytype(Integer primaryentitydependencytype) {
            this.primaryentitydependencytype = primaryentitydependencytype;
            this.changedFields = changedFields.add("primaryentitydependencytype");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Solutioncomponentrelationshipconfiguration build() {
            Solutioncomponentrelationshipconfiguration _x = new Solutioncomponentrelationshipconfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration";
            _x.solutioncomponentrelationshipconfigurationid = solutioncomponentrelationshipconfigurationid;
            _x.componentidunique = componentidunique;
            _x.overriddencreatedon = overriddencreatedon;
            _x.versionnumber = versionnumber;
            _x.createdon = createdon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._organizationid_value = _organizationid_value;
            _x._entityrelationshipid_value = _entityrelationshipid_value;
            _x.name = name;
            _x.statuscode = statuscode;
            _x.solutionid = solutionid;
            _x.secondaryentitydependencytype = secondaryentitydependencytype;
            _x.importsequencenumber = importsequencenumber;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.overwritetime = overwritetime;
            _x.modifiedon = modifiedon;
            _x.primaryentitydependencytype = primaryentitydependencytype;
            _x.componentstate = componentstate;
            _x.statecode = statecode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.iscustomizable = iscustomizable;
            _x._createdby_value = _createdby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.ismanaged = ismanaged;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && solutioncomponentrelationshipconfigurationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(solutioncomponentrelationshipconfigurationid, UUID.class));
        }
    }

    @Property(name="solutioncomponentrelationshipconfigurationid")
    @JsonIgnore
    public Optional<UUID> getSolutioncomponentrelationshipconfigurationid() {
        return Optional.ofNullable(solutioncomponentrelationshipconfigurationid);
    }

    public Solutioncomponentrelationshipconfiguration withSolutioncomponentrelationshipconfigurationid(UUID solutioncomponentrelationshipconfigurationid) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("solutioncomponentrelationshipconfigurationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.solutioncomponentrelationshipconfigurationid = solutioncomponentrelationshipconfigurationid;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<UUID> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Solutioncomponentrelationshipconfiguration withComponentidunique(UUID componentidunique) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Solutioncomponentrelationshipconfiguration withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Solutioncomponentrelationshipconfiguration withVersionnumber(Long versionnumber) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Solutioncomponentrelationshipconfiguration withCreatedon(OffsetDateTime createdon) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Solutioncomponentrelationshipconfiguration with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Solutioncomponentrelationshipconfiguration withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Solutioncomponentrelationshipconfiguration with_organizationid_value(UUID _organizationid_value) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_entityrelationshipid_value")
    @JsonIgnore
    public Optional<UUID> get_entityrelationshipid_value() {
        return Optional.ofNullable(_entityrelationshipid_value);
    }

    public Solutioncomponentrelationshipconfiguration with_entityrelationshipid_value(UUID _entityrelationshipid_value) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_entityrelationshipid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x._entityrelationshipid_value = _entityrelationshipid_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Solutioncomponentrelationshipconfiguration withName(String name) {
        Checks.checkIsAscii(name);
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.name = name;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Solutioncomponentrelationshipconfiguration withStatuscode(Integer statuscode) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Solutioncomponentrelationshipconfiguration withSolutionid(UUID solutionid) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="secondaryentitydependencytype")
    @JsonIgnore
    public Optional<Integer> getSecondaryentitydependencytype() {
        return Optional.ofNullable(secondaryentitydependencytype);
    }

    public Solutioncomponentrelationshipconfiguration withSecondaryentitydependencytype(Integer secondaryentitydependencytype) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("secondaryentitydependencytype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.secondaryentitydependencytype = secondaryentitydependencytype;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Solutioncomponentrelationshipconfiguration withImportsequencenumber(Integer importsequencenumber) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Solutioncomponentrelationshipconfiguration withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Solutioncomponentrelationshipconfiguration withOverwritetime(OffsetDateTime overwritetime) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Solutioncomponentrelationshipconfiguration withModifiedon(OffsetDateTime modifiedon) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="primaryentitydependencytype")
    @JsonIgnore
    public Optional<Integer> getPrimaryentitydependencytype() {
        return Optional.ofNullable(primaryentitydependencytype);
    }

    public Solutioncomponentrelationshipconfiguration withPrimaryentitydependencytype(Integer primaryentitydependencytype) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("primaryentitydependencytype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.primaryentitydependencytype = primaryentitydependencytype;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Solutioncomponentrelationshipconfiguration withComponentstate(Integer componentstate) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Solutioncomponentrelationshipconfiguration withStatecode(Integer statecode) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Solutioncomponentrelationshipconfiguration with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Solutioncomponentrelationshipconfiguration withIscustomizable(BooleanManagedProperty iscustomizable) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Solutioncomponentrelationshipconfiguration with_createdby_value(UUID _createdby_value) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Solutioncomponentrelationshipconfiguration with_modifiedby_value(UUID _modifiedby_value) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Solutioncomponentrelationshipconfiguration withIsmanaged(Boolean ismanaged) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.solutioncomponentrelationshipconfiguration");
        _x.ismanaged = ismanaged;
        return _x;
    }

    public Solutioncomponentrelationshipconfiguration withUnmappedField(String name, String value) {
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="solutioncomponentrelationshipconfiguration_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getSolutioncomponentrelationshipconfiguration_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("solutioncomponentrelationshipconfiguration_SyncErrors"), RequestHelper.getValue(unmappedFields, "solutioncomponentrelationshipconfiguration_SyncErrors"));
    }

    @NavigationProperty(name="solutioncomponentrelationshipconfiguration_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getSolutioncomponentrelationshipconfiguration_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("solutioncomponentrelationshipconfiguration_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "solutioncomponentrelationshipconfiguration_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="solutioncomponentrelationshipconfiguration_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getSolutioncomponentrelationshipconfiguration_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("solutioncomponentrelationshipconfiguration_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "solutioncomponentrelationshipconfiguration_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="solutioncomponentrelationshipconfiguration_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getSolutioncomponentrelationshipconfiguration_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("solutioncomponentrelationshipconfiguration_AsyncOperations"), RequestHelper.getValue(unmappedFields, "solutioncomponentrelationshipconfiguration_AsyncOperations"));
    }

    @NavigationProperty(name="solutioncomponentrelationshipconfiguration_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getSolutioncomponentrelationshipconfiguration_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("solutioncomponentrelationshipconfiguration_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "solutioncomponentrelationshipconfiguration_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="solutioncomponentrelationshipconfiguration_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getSolutioncomponentrelationshipconfiguration_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("solutioncomponentrelationshipconfiguration_ProcessSession"), RequestHelper.getValue(unmappedFields, "solutioncomponentrelationshipconfiguration_ProcessSession"));
    }

    @NavigationProperty(name="solutioncomponentrelationshipconfiguration_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getSolutioncomponentrelationshipconfiguration_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("solutioncomponentrelationshipconfiguration_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "solutioncomponentrelationshipconfiguration_BulkDeleteFailures"));
    }

    @NavigationProperty(name="solutioncomponentrelationshipconfiguration_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getSolutioncomponentrelationshipconfiguration_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("solutioncomponentrelationshipconfiguration_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "solutioncomponentrelationshipconfiguration_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="EntityRelationshipId")
    @JsonIgnore
    public EntityrelationshipRequest getEntityRelationshipId() {
        return new EntityrelationshipRequest(contextPath.addSegment("EntityRelationshipId"), RequestHelper.getValue(unmappedFields, "EntityRelationshipId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Solutioncomponentrelationshipconfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Solutioncomponentrelationshipconfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Solutioncomponentrelationshipconfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Solutioncomponentrelationshipconfiguration _copy() {
        Solutioncomponentrelationshipconfiguration _x = new Solutioncomponentrelationshipconfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.solutioncomponentrelationshipconfigurationid = solutioncomponentrelationshipconfigurationid;
        _x.componentidunique = componentidunique;
        _x.overriddencreatedon = overriddencreatedon;
        _x.versionnumber = versionnumber;
        _x.createdon = createdon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._organizationid_value = _organizationid_value;
        _x._entityrelationshipid_value = _entityrelationshipid_value;
        _x.name = name;
        _x.statuscode = statuscode;
        _x.solutionid = solutionid;
        _x.secondaryentitydependencytype = secondaryentitydependencytype;
        _x.importsequencenumber = importsequencenumber;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.overwritetime = overwritetime;
        _x.modifiedon = modifiedon;
        _x.primaryentitydependencytype = primaryentitydependencytype;
        _x.componentstate = componentstate;
        _x.statecode = statecode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.iscustomizable = iscustomizable;
        _x._createdby_value = _createdby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Solutioncomponentrelationshipconfiguration[");
        b.append("solutioncomponentrelationshipconfigurationid=");
        b.append(this.solutioncomponentrelationshipconfigurationid);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_entityrelationshipid_value=");
        b.append(this._entityrelationshipid_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("secondaryentitydependencytype=");
        b.append(this.secondaryentitydependencytype);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("primaryentitydependencytype=");
        b.append(this.primaryentitydependencytype);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
