package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;

@JsonPropertyOrder({
    "@odata.type", 
    "overwritetime", 
    "componentstate", 
    "appmoduleid", 
    "componentidunique", 
    "solutionid", 
    "versionnumber", 
    "serviceplanid", 
    "serviceplanappmodulesid", 
    "iscustomizable", 
    "ismanaged"})
@JsonInclude(Include.NON_NULL)
public class Serviceplanappmodules extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.serviceplanappmodules";
    }

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("appmoduleid")
    protected UUID appmoduleid;

    @JsonProperty("componentidunique")
    protected UUID componentidunique;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("serviceplanid")
    protected UUID serviceplanid;

    @JsonProperty("serviceplanappmodulesid")
    protected UUID serviceplanappmodulesid;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    protected Serviceplanappmodules() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServiceplanappmodules() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime overwritetime;
        private Integer componentstate;
        private UUID appmoduleid;
        private UUID componentidunique;
        private UUID solutionid;
        private Long versionnumber;
        private UUID serviceplanid;
        private UUID serviceplanappmodulesid;
        private BooleanManagedProperty iscustomizable;
        private Boolean ismanaged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder appmoduleid(UUID appmoduleid) {
            this.appmoduleid = appmoduleid;
            this.changedFields = changedFields.add("appmoduleid");
            return this;
        }

        public Builder componentidunique(UUID componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder serviceplanid(UUID serviceplanid) {
            this.serviceplanid = serviceplanid;
            this.changedFields = changedFields.add("serviceplanid");
            return this;
        }

        public Builder serviceplanappmodulesid(UUID serviceplanappmodulesid) {
            this.serviceplanappmodulesid = serviceplanappmodulesid;
            this.changedFields = changedFields.add("serviceplanappmodulesid");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Serviceplanappmodules build() {
            Serviceplanappmodules _x = new Serviceplanappmodules();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.serviceplanappmodules";
            _x.overwritetime = overwritetime;
            _x.componentstate = componentstate;
            _x.appmoduleid = appmoduleid;
            _x.componentidunique = componentidunique;
            _x.solutionid = solutionid;
            _x.versionnumber = versionnumber;
            _x.serviceplanid = serviceplanid;
            _x.serviceplanappmodulesid = serviceplanappmodulesid;
            _x.iscustomizable = iscustomizable;
            _x.ismanaged = ismanaged;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && serviceplanappmodulesid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(serviceplanappmodulesid, UUID.class));
        }
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Serviceplanappmodules withOverwritetime(OffsetDateTime overwritetime) {
        Serviceplanappmodules _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplanappmodules");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Serviceplanappmodules withComponentstate(Integer componentstate) {
        Serviceplanappmodules _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplanappmodules");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="appmoduleid")
    @JsonIgnore
    public Optional<UUID> getAppmoduleid() {
        return Optional.ofNullable(appmoduleid);
    }

    public Serviceplanappmodules withAppmoduleid(UUID appmoduleid) {
        Serviceplanappmodules _x = _copy();
        _x.changedFields = changedFields.add("appmoduleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplanappmodules");
        _x.appmoduleid = appmoduleid;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<UUID> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Serviceplanappmodules withComponentidunique(UUID componentidunique) {
        Serviceplanappmodules _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplanappmodules");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Serviceplanappmodules withSolutionid(UUID solutionid) {
        Serviceplanappmodules _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplanappmodules");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Serviceplanappmodules withVersionnumber(Long versionnumber) {
        Serviceplanappmodules _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplanappmodules");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="serviceplanid")
    @JsonIgnore
    public Optional<UUID> getServiceplanid() {
        return Optional.ofNullable(serviceplanid);
    }

    public Serviceplanappmodules withServiceplanid(UUID serviceplanid) {
        Serviceplanappmodules _x = _copy();
        _x.changedFields = changedFields.add("serviceplanid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplanappmodules");
        _x.serviceplanid = serviceplanid;
        return _x;
    }

    @Property(name="serviceplanappmodulesid")
    @JsonIgnore
    public Optional<UUID> getServiceplanappmodulesid() {
        return Optional.ofNullable(serviceplanappmodulesid);
    }

    public Serviceplanappmodules withServiceplanappmodulesid(UUID serviceplanappmodulesid) {
        Serviceplanappmodules _x = _copy();
        _x.changedFields = changedFields.add("serviceplanappmodulesid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplanappmodules");
        _x.serviceplanappmodulesid = serviceplanappmodulesid;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Serviceplanappmodules withIscustomizable(BooleanManagedProperty iscustomizable) {
        Serviceplanappmodules _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplanappmodules");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Serviceplanappmodules withIsmanaged(Boolean ismanaged) {
        Serviceplanappmodules _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplanappmodules");
        _x.ismanaged = ismanaged;
        return _x;
    }

    public Serviceplanappmodules withUnmappedField(String name, String value) {
        Serviceplanappmodules _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Serviceplanappmodules patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Serviceplanappmodules _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Serviceplanappmodules put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Serviceplanappmodules _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Serviceplanappmodules _copy() {
        Serviceplanappmodules _x = new Serviceplanappmodules();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.overwritetime = overwritetime;
        _x.componentstate = componentstate;
        _x.appmoduleid = appmoduleid;
        _x.componentidunique = componentidunique;
        _x.solutionid = solutionid;
        _x.versionnumber = versionnumber;
        _x.serviceplanid = serviceplanid;
        _x.serviceplanappmodulesid = serviceplanappmodulesid;
        _x.iscustomizable = iscustomizable;
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Serviceplanappmodules[");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("appmoduleid=");
        b.append(this.appmoduleid);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("serviceplanid=");
        b.append(this.serviceplanid);
        b.append(", ");
        b.append("serviceplanappmodulesid=");
        b.append(this.serviceplanappmodulesid);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
