package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepimageCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PlugintypeRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageRequest;
import microsoft.dynamics.crm.entity.request.SdkmessagefilterRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepsecureconfigRequest;
import microsoft.dynamics.crm.entity.request.ServiceendpointRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedonbehalfby_value", 
    "_createdonbehalfby_value", 
    "sdkmessageprocessingstepid", 
    "ishidden", 
    "eventexpander", 
    "introducedversion", 
    "_sdkmessageid_value", 
    "componentstate", 
    "configuration", 
    "canusereadonlyconnection", 
    "filteringattributes", 
    "statecode", 
    "overwritetime", 
    "_modifiedby_value", 
    "modifiedon", 
    "solutionid", 
    "asyncautodelete", 
    "sdkmessageprocessingstepidunique", 
    "mode", 
    "_sdkmessagefilterid_value", 
    "_organizationid_value", 
    "rank", 
    "_sdkmessageprocessingstepsecureconfigid_value", 
    "name", 
    "createdon", 
    "stage", 
    "customizationlevel", 
    "versionnumber", 
    "supporteddeployment", 
    "ismanaged", 
    "_eventhandler_value", 
    "_impersonatinguserid_value", 
    "statuscode", 
    "_createdby_value", 
    "iscustomizable", 
    "description"})
@JsonInclude(Include.NON_NULL)
public class Sdkmessageprocessingstep extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.sdkmessageprocessingstep";
    }

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("sdkmessageprocessingstepid")
    protected UUID sdkmessageprocessingstepid;

    @JsonProperty("ishidden")
    protected BooleanManagedProperty ishidden;

    @JsonProperty("eventexpander")
    protected String eventexpander;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_sdkmessageid_value")
    protected UUID _sdkmessageid_value;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("configuration")
    protected String configuration;

    @JsonProperty("canusereadonlyconnection")
    protected Boolean canusereadonlyconnection;

    @JsonProperty("filteringattributes")
    protected String filteringattributes;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("asyncautodelete")
    protected Boolean asyncautodelete;

    @JsonProperty("sdkmessageprocessingstepidunique")
    protected UUID sdkmessageprocessingstepidunique;

    @JsonProperty("mode")
    protected Integer mode;

    @JsonProperty("_sdkmessagefilterid_value")
    protected UUID _sdkmessagefilterid_value;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("rank")
    protected Integer rank;

    @JsonProperty("_sdkmessageprocessingstepsecureconfigid_value")
    protected UUID _sdkmessageprocessingstepsecureconfigid_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("stage")
    protected Integer stage;

    @JsonProperty("customizationlevel")
    protected Integer customizationlevel;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("supporteddeployment")
    protected Integer supporteddeployment;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_eventhandler_value")
    protected UUID _eventhandler_value;

    @JsonProperty("_impersonatinguserid_value")
    protected UUID _impersonatinguserid_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("description")
    protected String description;

    protected Sdkmessageprocessingstep() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSdkmessageprocessingstep() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _modifiedonbehalfby_value;
        private UUID _createdonbehalfby_value;
        private UUID sdkmessageprocessingstepid;
        private BooleanManagedProperty ishidden;
        private String eventexpander;
        private String introducedversion;
        private UUID _sdkmessageid_value;
        private Integer componentstate;
        private String configuration;
        private Boolean canusereadonlyconnection;
        private String filteringattributes;
        private Integer statecode;
        private OffsetDateTime overwritetime;
        private UUID _modifiedby_value;
        private OffsetDateTime modifiedon;
        private UUID solutionid;
        private Boolean asyncautodelete;
        private UUID sdkmessageprocessingstepidunique;
        private Integer mode;
        private UUID _sdkmessagefilterid_value;
        private UUID _organizationid_value;
        private Integer rank;
        private UUID _sdkmessageprocessingstepsecureconfigid_value;
        private String name;
        private OffsetDateTime createdon;
        private Integer stage;
        private Integer customizationlevel;
        private Long versionnumber;
        private Integer supporteddeployment;
        private Boolean ismanaged;
        private UUID _eventhandler_value;
        private UUID _impersonatinguserid_value;
        private Integer statuscode;
        private UUID _createdby_value;
        private BooleanManagedProperty iscustomizable;
        private String description;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder sdkmessageprocessingstepid(UUID sdkmessageprocessingstepid) {
            this.sdkmessageprocessingstepid = sdkmessageprocessingstepid;
            this.changedFields = changedFields.add("sdkmessageprocessingstepid");
            return this;
        }

        public Builder ishidden(BooleanManagedProperty ishidden) {
            this.ishidden = ishidden;
            this.changedFields = changedFields.add("ishidden");
            return this;
        }

        public Builder eventexpander(String eventexpander) {
            this.eventexpander = eventexpander;
            this.changedFields = changedFields.add("eventexpander");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _sdkmessageid_value(UUID _sdkmessageid_value) {
            this._sdkmessageid_value = _sdkmessageid_value;
            this.changedFields = changedFields.add("_sdkmessageid_value");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder configuration(String configuration) {
            this.configuration = configuration;
            this.changedFields = changedFields.add("configuration");
            return this;
        }

        public Builder canusereadonlyconnection(Boolean canusereadonlyconnection) {
            this.canusereadonlyconnection = canusereadonlyconnection;
            this.changedFields = changedFields.add("canusereadonlyconnection");
            return this;
        }

        public Builder filteringattributes(String filteringattributes) {
            this.filteringattributes = filteringattributes;
            this.changedFields = changedFields.add("filteringattributes");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder asyncautodelete(Boolean asyncautodelete) {
            this.asyncautodelete = asyncautodelete;
            this.changedFields = changedFields.add("asyncautodelete");
            return this;
        }

        public Builder sdkmessageprocessingstepidunique(UUID sdkmessageprocessingstepidunique) {
            this.sdkmessageprocessingstepidunique = sdkmessageprocessingstepidunique;
            this.changedFields = changedFields.add("sdkmessageprocessingstepidunique");
            return this;
        }

        public Builder mode(Integer mode) {
            this.mode = mode;
            this.changedFields = changedFields.add("mode");
            return this;
        }

        public Builder _sdkmessagefilterid_value(UUID _sdkmessagefilterid_value) {
            this._sdkmessagefilterid_value = _sdkmessagefilterid_value;
            this.changedFields = changedFields.add("_sdkmessagefilterid_value");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder rank(Integer rank) {
            this.rank = rank;
            this.changedFields = changedFields.add("rank");
            return this;
        }

        public Builder _sdkmessageprocessingstepsecureconfigid_value(UUID _sdkmessageprocessingstepsecureconfigid_value) {
            this._sdkmessageprocessingstepsecureconfigid_value = _sdkmessageprocessingstepsecureconfigid_value;
            this.changedFields = changedFields.add("_sdkmessageprocessingstepsecureconfigid_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder stage(Integer stage) {
            this.stage = stage;
            this.changedFields = changedFields.add("stage");
            return this;
        }

        public Builder customizationlevel(Integer customizationlevel) {
            this.customizationlevel = customizationlevel;
            this.changedFields = changedFields.add("customizationlevel");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder supporteddeployment(Integer supporteddeployment) {
            this.supporteddeployment = supporteddeployment;
            this.changedFields = changedFields.add("supporteddeployment");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _eventhandler_value(UUID _eventhandler_value) {
            this._eventhandler_value = _eventhandler_value;
            this.changedFields = changedFields.add("_eventhandler_value");
            return this;
        }

        public Builder _impersonatinguserid_value(UUID _impersonatinguserid_value) {
            this._impersonatinguserid_value = _impersonatinguserid_value;
            this.changedFields = changedFields.add("_impersonatinguserid_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Sdkmessageprocessingstep build() {
            Sdkmessageprocessingstep _x = new Sdkmessageprocessingstep();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.sdkmessageprocessingstep";
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.sdkmessageprocessingstepid = sdkmessageprocessingstepid;
            _x.ishidden = ishidden;
            _x.eventexpander = eventexpander;
            _x.introducedversion = introducedversion;
            _x._sdkmessageid_value = _sdkmessageid_value;
            _x.componentstate = componentstate;
            _x.configuration = configuration;
            _x.canusereadonlyconnection = canusereadonlyconnection;
            _x.filteringattributes = filteringattributes;
            _x.statecode = statecode;
            _x.overwritetime = overwritetime;
            _x._modifiedby_value = _modifiedby_value;
            _x.modifiedon = modifiedon;
            _x.solutionid = solutionid;
            _x.asyncautodelete = asyncautodelete;
            _x.sdkmessageprocessingstepidunique = sdkmessageprocessingstepidunique;
            _x.mode = mode;
            _x._sdkmessagefilterid_value = _sdkmessagefilterid_value;
            _x._organizationid_value = _organizationid_value;
            _x.rank = rank;
            _x._sdkmessageprocessingstepsecureconfigid_value = _sdkmessageprocessingstepsecureconfigid_value;
            _x.name = name;
            _x.createdon = createdon;
            _x.stage = stage;
            _x.customizationlevel = customizationlevel;
            _x.versionnumber = versionnumber;
            _x.supporteddeployment = supporteddeployment;
            _x.ismanaged = ismanaged;
            _x._eventhandler_value = _eventhandler_value;
            _x._impersonatinguserid_value = _impersonatinguserid_value;
            _x.statuscode = statuscode;
            _x._createdby_value = _createdby_value;
            _x.iscustomizable = iscustomizable;
            _x.description = description;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && sdkmessageprocessingstepid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(sdkmessageprocessingstepid, UUID.class));
        }
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Sdkmessageprocessingstep with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Sdkmessageprocessingstep with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="sdkmessageprocessingstepid")
    @JsonIgnore
    public Optional<UUID> getSdkmessageprocessingstepid() {
        return Optional.ofNullable(sdkmessageprocessingstepid);
    }

    public Sdkmessageprocessingstep withSdkmessageprocessingstepid(UUID sdkmessageprocessingstepid) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("sdkmessageprocessingstepid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.sdkmessageprocessingstepid = sdkmessageprocessingstepid;
        return _x;
    }

    @Property(name="ishidden")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIshidden() {
        return Optional.ofNullable(ishidden);
    }

    public Sdkmessageprocessingstep withIshidden(BooleanManagedProperty ishidden) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("ishidden");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.ishidden = ishidden;
        return _x;
    }

    @Property(name="eventexpander")
    @JsonIgnore
    public Optional<String> getEventexpander() {
        return Optional.ofNullable(eventexpander);
    }

    public Sdkmessageprocessingstep withEventexpander(String eventexpander) {
        Checks.checkIsAscii(eventexpander);
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("eventexpander");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.eventexpander = eventexpander;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Sdkmessageprocessingstep withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_sdkmessageid_value")
    @JsonIgnore
    public Optional<UUID> get_sdkmessageid_value() {
        return Optional.ofNullable(_sdkmessageid_value);
    }

    public Sdkmessageprocessingstep with_sdkmessageid_value(UUID _sdkmessageid_value) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("_sdkmessageid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x._sdkmessageid_value = _sdkmessageid_value;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Sdkmessageprocessingstep withComponentstate(Integer componentstate) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="configuration")
    @JsonIgnore
    public Optional<String> getConfiguration() {
        return Optional.ofNullable(configuration);
    }

    public Sdkmessageprocessingstep withConfiguration(String configuration) {
        Checks.checkIsAscii(configuration);
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("configuration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.configuration = configuration;
        return _x;
    }

    @Property(name="canusereadonlyconnection")
    @JsonIgnore
    public Optional<Boolean> getCanusereadonlyconnection() {
        return Optional.ofNullable(canusereadonlyconnection);
    }

    public Sdkmessageprocessingstep withCanusereadonlyconnection(Boolean canusereadonlyconnection) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("canusereadonlyconnection");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.canusereadonlyconnection = canusereadonlyconnection;
        return _x;
    }

    @Property(name="filteringattributes")
    @JsonIgnore
    public Optional<String> getFilteringattributes() {
        return Optional.ofNullable(filteringattributes);
    }

    public Sdkmessageprocessingstep withFilteringattributes(String filteringattributes) {
        Checks.checkIsAscii(filteringattributes);
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("filteringattributes");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.filteringattributes = filteringattributes;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Sdkmessageprocessingstep withStatecode(Integer statecode) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Sdkmessageprocessingstep withOverwritetime(OffsetDateTime overwritetime) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Sdkmessageprocessingstep with_modifiedby_value(UUID _modifiedby_value) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Sdkmessageprocessingstep withModifiedon(OffsetDateTime modifiedon) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Sdkmessageprocessingstep withSolutionid(UUID solutionid) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="asyncautodelete")
    @JsonIgnore
    public Optional<Boolean> getAsyncautodelete() {
        return Optional.ofNullable(asyncautodelete);
    }

    public Sdkmessageprocessingstep withAsyncautodelete(Boolean asyncautodelete) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("asyncautodelete");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.asyncautodelete = asyncautodelete;
        return _x;
    }

    @Property(name="sdkmessageprocessingstepidunique")
    @JsonIgnore
    public Optional<UUID> getSdkmessageprocessingstepidunique() {
        return Optional.ofNullable(sdkmessageprocessingstepidunique);
    }

    public Sdkmessageprocessingstep withSdkmessageprocessingstepidunique(UUID sdkmessageprocessingstepidunique) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("sdkmessageprocessingstepidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.sdkmessageprocessingstepidunique = sdkmessageprocessingstepidunique;
        return _x;
    }

    @Property(name="mode")
    @JsonIgnore
    public Optional<Integer> getMode() {
        return Optional.ofNullable(mode);
    }

    public Sdkmessageprocessingstep withMode(Integer mode) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("mode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.mode = mode;
        return _x;
    }

    @Property(name="_sdkmessagefilterid_value")
    @JsonIgnore
    public Optional<UUID> get_sdkmessagefilterid_value() {
        return Optional.ofNullable(_sdkmessagefilterid_value);
    }

    public Sdkmessageprocessingstep with_sdkmessagefilterid_value(UUID _sdkmessagefilterid_value) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("_sdkmessagefilterid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x._sdkmessagefilterid_value = _sdkmessagefilterid_value;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Sdkmessageprocessingstep with_organizationid_value(UUID _organizationid_value) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="rank")
    @JsonIgnore
    public Optional<Integer> getRank() {
        return Optional.ofNullable(rank);
    }

    public Sdkmessageprocessingstep withRank(Integer rank) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("rank");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.rank = rank;
        return _x;
    }

    @Property(name="_sdkmessageprocessingstepsecureconfigid_value")
    @JsonIgnore
    public Optional<UUID> get_sdkmessageprocessingstepsecureconfigid_value() {
        return Optional.ofNullable(_sdkmessageprocessingstepsecureconfigid_value);
    }

    public Sdkmessageprocessingstep with_sdkmessageprocessingstepsecureconfigid_value(UUID _sdkmessageprocessingstepsecureconfigid_value) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("_sdkmessageprocessingstepsecureconfigid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x._sdkmessageprocessingstepsecureconfigid_value = _sdkmessageprocessingstepsecureconfigid_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Sdkmessageprocessingstep withName(String name) {
        Checks.checkIsAscii(name);
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.name = name;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Sdkmessageprocessingstep withCreatedon(OffsetDateTime createdon) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="stage")
    @JsonIgnore
    public Optional<Integer> getStage() {
        return Optional.ofNullable(stage);
    }

    public Sdkmessageprocessingstep withStage(Integer stage) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("stage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.stage = stage;
        return _x;
    }

    @Property(name="customizationlevel")
    @JsonIgnore
    public Optional<Integer> getCustomizationlevel() {
        return Optional.ofNullable(customizationlevel);
    }

    public Sdkmessageprocessingstep withCustomizationlevel(Integer customizationlevel) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("customizationlevel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.customizationlevel = customizationlevel;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Sdkmessageprocessingstep withVersionnumber(Long versionnumber) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="supporteddeployment")
    @JsonIgnore
    public Optional<Integer> getSupporteddeployment() {
        return Optional.ofNullable(supporteddeployment);
    }

    public Sdkmessageprocessingstep withSupporteddeployment(Integer supporteddeployment) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("supporteddeployment");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.supporteddeployment = supporteddeployment;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Sdkmessageprocessingstep withIsmanaged(Boolean ismanaged) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_eventhandler_value")
    @JsonIgnore
    public Optional<UUID> get_eventhandler_value() {
        return Optional.ofNullable(_eventhandler_value);
    }

    public Sdkmessageprocessingstep with_eventhandler_value(UUID _eventhandler_value) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("_eventhandler_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x._eventhandler_value = _eventhandler_value;
        return _x;
    }

    @Property(name="_impersonatinguserid_value")
    @JsonIgnore
    public Optional<UUID> get_impersonatinguserid_value() {
        return Optional.ofNullable(_impersonatinguserid_value);
    }

    public Sdkmessageprocessingstep with_impersonatinguserid_value(UUID _impersonatinguserid_value) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("_impersonatinguserid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x._impersonatinguserid_value = _impersonatinguserid_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Sdkmessageprocessingstep withStatuscode(Integer statuscode) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Sdkmessageprocessingstep with_createdby_value(UUID _createdby_value) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Sdkmessageprocessingstep withIscustomizable(BooleanManagedProperty iscustomizable) {
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Sdkmessageprocessingstep withDescription(String description) {
        Checks.checkIsAscii(description);
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstep");
        _x.description = description;
        return _x;
    }

    public Sdkmessageprocessingstep withUnmappedField(String name, String value) {
        Sdkmessageprocessingstep _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="sdkmessageprocessingstepsecureconfigid")
    @JsonIgnore
    public SdkmessageprocessingstepsecureconfigRequest getSdkmessageprocessingstepsecureconfigid() {
        return new SdkmessageprocessingstepsecureconfigRequest(contextPath.addSegment("sdkmessageprocessingstepsecureconfigid"), RequestHelper.getValue(unmappedFields, "sdkmessageprocessingstepsecureconfigid"));
    }

    @NavigationProperty(name="sdkmessageid")
    @JsonIgnore
    public SdkmessageRequest getSdkmessageid() {
        return new SdkmessageRequest(contextPath.addSegment("sdkmessageid"), RequestHelper.getValue(unmappedFields, "sdkmessageid"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="sdkmessagefilterid")
    @JsonIgnore
    public SdkmessagefilterRequest getSdkmessagefilterid() {
        return new SdkmessagefilterRequest(contextPath.addSegment("sdkmessagefilterid"), RequestHelper.getValue(unmappedFields, "sdkmessagefilterid"));
    }

    @NavigationProperty(name="impersonatinguserid")
    @JsonIgnore
    public SystemuserRequest getImpersonatinguserid() {
        return new SystemuserRequest(contextPath.addSegment("impersonatinguserid"), RequestHelper.getValue(unmappedFields, "impersonatinguserid"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="plugintypeid")
    @JsonIgnore
    public PlugintypeRequest getPlugintypeid() {
        return new PlugintypeRequest(contextPath.addSegment("plugintypeid"), RequestHelper.getValue(unmappedFields, "plugintypeid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="eventhandler_plugintype")
    @JsonIgnore
    public PlugintypeRequest getEventhandler_plugintype() {
        return new PlugintypeRequest(contextPath.addSegment("eventhandler_plugintype"), RequestHelper.getValue(unmappedFields, "eventhandler_plugintype"));
    }

    @NavigationProperty(name="SdkMessageProcessingStep_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getSdkMessageProcessingStep_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SdkMessageProcessingStep_AsyncOperations"), RequestHelper.getValue(unmappedFields, "SdkMessageProcessingStep_AsyncOperations"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="sdkmessageprocessingstepid_sdkmessageprocessingstepimage")
    @JsonIgnore
    public SdkmessageprocessingstepimageCollectionRequest getSdkmessageprocessingstepid_sdkmessageprocessingstepimage() {
        return new SdkmessageprocessingstepimageCollectionRequest(
                        contextPath.addSegment("sdkmessageprocessingstepid_sdkmessageprocessingstepimage"), RequestHelper.getValue(unmappedFields, "sdkmessageprocessingstepid_sdkmessageprocessingstepimage"));
    }

    @NavigationProperty(name="eventhandler_serviceendpoint")
    @JsonIgnore
    public ServiceendpointRequest getEventhandler_serviceendpoint() {
        return new ServiceendpointRequest(contextPath.addSegment("eventhandler_serviceendpoint"), RequestHelper.getValue(unmappedFields, "eventhandler_serviceendpoint"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sdkmessageprocessingstep patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sdkmessageprocessingstep put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Sdkmessageprocessingstep _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Sdkmessageprocessingstep _copy() {
        Sdkmessageprocessingstep _x = new Sdkmessageprocessingstep();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.sdkmessageprocessingstepid = sdkmessageprocessingstepid;
        _x.ishidden = ishidden;
        _x.eventexpander = eventexpander;
        _x.introducedversion = introducedversion;
        _x._sdkmessageid_value = _sdkmessageid_value;
        _x.componentstate = componentstate;
        _x.configuration = configuration;
        _x.canusereadonlyconnection = canusereadonlyconnection;
        _x.filteringattributes = filteringattributes;
        _x.statecode = statecode;
        _x.overwritetime = overwritetime;
        _x._modifiedby_value = _modifiedby_value;
        _x.modifiedon = modifiedon;
        _x.solutionid = solutionid;
        _x.asyncautodelete = asyncautodelete;
        _x.sdkmessageprocessingstepidunique = sdkmessageprocessingstepidunique;
        _x.mode = mode;
        _x._sdkmessagefilterid_value = _sdkmessagefilterid_value;
        _x._organizationid_value = _organizationid_value;
        _x.rank = rank;
        _x._sdkmessageprocessingstepsecureconfigid_value = _sdkmessageprocessingstepsecureconfigid_value;
        _x.name = name;
        _x.createdon = createdon;
        _x.stage = stage;
        _x.customizationlevel = customizationlevel;
        _x.versionnumber = versionnumber;
        _x.supporteddeployment = supporteddeployment;
        _x.ismanaged = ismanaged;
        _x._eventhandler_value = _eventhandler_value;
        _x._impersonatinguserid_value = _impersonatinguserid_value;
        _x.statuscode = statuscode;
        _x._createdby_value = _createdby_value;
        _x.iscustomizable = iscustomizable;
        _x.description = description;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Sdkmessageprocessingstep[");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("sdkmessageprocessingstepid=");
        b.append(this.sdkmessageprocessingstepid);
        b.append(", ");
        b.append("ishidden=");
        b.append(this.ishidden);
        b.append(", ");
        b.append("eventexpander=");
        b.append(this.eventexpander);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_sdkmessageid_value=");
        b.append(this._sdkmessageid_value);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("configuration=");
        b.append(this.configuration);
        b.append(", ");
        b.append("canusereadonlyconnection=");
        b.append(this.canusereadonlyconnection);
        b.append(", ");
        b.append("filteringattributes=");
        b.append(this.filteringattributes);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("asyncautodelete=");
        b.append(this.asyncautodelete);
        b.append(", ");
        b.append("sdkmessageprocessingstepidunique=");
        b.append(this.sdkmessageprocessingstepidunique);
        b.append(", ");
        b.append("mode=");
        b.append(this.mode);
        b.append(", ");
        b.append("_sdkmessagefilterid_value=");
        b.append(this._sdkmessagefilterid_value);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("rank=");
        b.append(this.rank);
        b.append(", ");
        b.append("_sdkmessageprocessingstepsecureconfigid_value=");
        b.append(this._sdkmessageprocessingstepsecureconfigid_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("stage=");
        b.append(this.stage);
        b.append(", ");
        b.append("customizationlevel=");
        b.append(this.customizationlevel);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("supporteddeployment=");
        b.append(this.supporteddeployment);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_eventhandler_value=");
        b.append(this._eventhandler_value);
        b.append(", ");
        b.append("_impersonatinguserid_value=");
        b.append(this._impersonatinguserid_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
