package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.MetricRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "goalattribute", 
    "_metricid_value", 
    "rollupfieldid", 
    "sourceattribute", 
    "isstateparententityattribute", 
    "_createdby_value", 
    "sourcestatus", 
    "dateattribute", 
    "createdon", 
    "utcconversiontimezonecode", 
    "versionnumber", 
    "importsequencenumber", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "timezoneruleversionnumber", 
    "entityfordateattribute", 
    "_modifiedonbehalfby_value", 
    "sourceentity", 
    "sourcestate", 
    "_organizationid_value", 
    "_modifiedby_value"})
@JsonInclude(Include.NON_NULL)
public class Rollupfield extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.rollupfield";
    }

    @JsonProperty("goalattribute")
    protected String goalattribute;

    @JsonProperty("_metricid_value")
    protected UUID _metricid_value;

    @JsonProperty("rollupfieldid")
    protected UUID rollupfieldid;

    @JsonProperty("sourceattribute")
    protected String sourceattribute;

    @JsonProperty("isstateparententityattribute")
    protected Boolean isstateparententityattribute;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("sourcestatus")
    protected Integer sourcestatus;

    @JsonProperty("dateattribute")
    protected String dateattribute;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("entityfordateattribute")
    protected String entityfordateattribute;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("sourceentity")
    protected String sourceentity;

    @JsonProperty("sourcestate")
    protected Integer sourcestate;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    protected Rollupfield() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRollupfield() {
        return new Builder();
    }

    public static final class Builder {
        private String goalattribute;
        private UUID _metricid_value;
        private UUID rollupfieldid;
        private String sourceattribute;
        private Boolean isstateparententityattribute;
        private UUID _createdby_value;
        private Integer sourcestatus;
        private String dateattribute;
        private OffsetDateTime createdon;
        private Integer utcconversiontimezonecode;
        private Long versionnumber;
        private Integer importsequencenumber;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private Integer timezoneruleversionnumber;
        private String entityfordateattribute;
        private UUID _modifiedonbehalfby_value;
        private String sourceentity;
        private Integer sourcestate;
        private UUID _organizationid_value;
        private UUID _modifiedby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder goalattribute(String goalattribute) {
            this.goalattribute = goalattribute;
            this.changedFields = changedFields.add("goalattribute");
            return this;
        }

        public Builder _metricid_value(UUID _metricid_value) {
            this._metricid_value = _metricid_value;
            this.changedFields = changedFields.add("_metricid_value");
            return this;
        }

        public Builder rollupfieldid(UUID rollupfieldid) {
            this.rollupfieldid = rollupfieldid;
            this.changedFields = changedFields.add("rollupfieldid");
            return this;
        }

        public Builder sourceattribute(String sourceattribute) {
            this.sourceattribute = sourceattribute;
            this.changedFields = changedFields.add("sourceattribute");
            return this;
        }

        public Builder isstateparententityattribute(Boolean isstateparententityattribute) {
            this.isstateparententityattribute = isstateparententityattribute;
            this.changedFields = changedFields.add("isstateparententityattribute");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder sourcestatus(Integer sourcestatus) {
            this.sourcestatus = sourcestatus;
            this.changedFields = changedFields.add("sourcestatus");
            return this;
        }

        public Builder dateattribute(String dateattribute) {
            this.dateattribute = dateattribute;
            this.changedFields = changedFields.add("dateattribute");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder entityfordateattribute(String entityfordateattribute) {
            this.entityfordateattribute = entityfordateattribute;
            this.changedFields = changedFields.add("entityfordateattribute");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder sourceentity(String sourceentity) {
            this.sourceentity = sourceentity;
            this.changedFields = changedFields.add("sourceentity");
            return this;
        }

        public Builder sourcestate(Integer sourcestate) {
            this.sourcestate = sourcestate;
            this.changedFields = changedFields.add("sourcestate");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Rollupfield build() {
            Rollupfield _x = new Rollupfield();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.rollupfield";
            _x.goalattribute = goalattribute;
            _x._metricid_value = _metricid_value;
            _x.rollupfieldid = rollupfieldid;
            _x.sourceattribute = sourceattribute;
            _x.isstateparententityattribute = isstateparententityattribute;
            _x._createdby_value = _createdby_value;
            _x.sourcestatus = sourcestatus;
            _x.dateattribute = dateattribute;
            _x.createdon = createdon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.versionnumber = versionnumber;
            _x.importsequencenumber = importsequencenumber;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.entityfordateattribute = entityfordateattribute;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.sourceentity = sourceentity;
            _x.sourcestate = sourcestate;
            _x._organizationid_value = _organizationid_value;
            _x._modifiedby_value = _modifiedby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && rollupfieldid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(rollupfieldid, UUID.class));
        }
    }

    @Property(name="goalattribute")
    @JsonIgnore
    public Optional<String> getGoalattribute() {
        return Optional.ofNullable(goalattribute);
    }

    public Rollupfield withGoalattribute(String goalattribute) {
        Checks.checkIsAscii(goalattribute);
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("goalattribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.goalattribute = goalattribute;
        return _x;
    }

    @Property(name="_metricid_value")
    @JsonIgnore
    public Optional<UUID> get_metricid_value() {
        return Optional.ofNullable(_metricid_value);
    }

    public Rollupfield with_metricid_value(UUID _metricid_value) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("_metricid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x._metricid_value = _metricid_value;
        return _x;
    }

    @Property(name="rollupfieldid")
    @JsonIgnore
    public Optional<UUID> getRollupfieldid() {
        return Optional.ofNullable(rollupfieldid);
    }

    public Rollupfield withRollupfieldid(UUID rollupfieldid) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("rollupfieldid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.rollupfieldid = rollupfieldid;
        return _x;
    }

    @Property(name="sourceattribute")
    @JsonIgnore
    public Optional<String> getSourceattribute() {
        return Optional.ofNullable(sourceattribute);
    }

    public Rollupfield withSourceattribute(String sourceattribute) {
        Checks.checkIsAscii(sourceattribute);
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("sourceattribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.sourceattribute = sourceattribute;
        return _x;
    }

    @Property(name="isstateparententityattribute")
    @JsonIgnore
    public Optional<Boolean> getIsstateparententityattribute() {
        return Optional.ofNullable(isstateparententityattribute);
    }

    public Rollupfield withIsstateparententityattribute(Boolean isstateparententityattribute) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("isstateparententityattribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.isstateparententityattribute = isstateparententityattribute;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Rollupfield with_createdby_value(UUID _createdby_value) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="sourcestatus")
    @JsonIgnore
    public Optional<Integer> getSourcestatus() {
        return Optional.ofNullable(sourcestatus);
    }

    public Rollupfield withSourcestatus(Integer sourcestatus) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("sourcestatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.sourcestatus = sourcestatus;
        return _x;
    }

    @Property(name="dateattribute")
    @JsonIgnore
    public Optional<String> getDateattribute() {
        return Optional.ofNullable(dateattribute);
    }

    public Rollupfield withDateattribute(String dateattribute) {
        Checks.checkIsAscii(dateattribute);
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("dateattribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.dateattribute = dateattribute;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Rollupfield withCreatedon(OffsetDateTime createdon) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Rollupfield withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Rollupfield withVersionnumber(Long versionnumber) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Rollupfield withImportsequencenumber(Integer importsequencenumber) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Rollupfield with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Rollupfield withModifiedon(OffsetDateTime modifiedon) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Rollupfield withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="entityfordateattribute")
    @JsonIgnore
    public Optional<String> getEntityfordateattribute() {
        return Optional.ofNullable(entityfordateattribute);
    }

    public Rollupfield withEntityfordateattribute(String entityfordateattribute) {
        Checks.checkIsAscii(entityfordateattribute);
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("entityfordateattribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.entityfordateattribute = entityfordateattribute;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Rollupfield with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="sourceentity")
    @JsonIgnore
    public Optional<String> getSourceentity() {
        return Optional.ofNullable(sourceentity);
    }

    public Rollupfield withSourceentity(String sourceentity) {
        Checks.checkIsAscii(sourceentity);
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("sourceentity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.sourceentity = sourceentity;
        return _x;
    }

    @Property(name="sourcestate")
    @JsonIgnore
    public Optional<Integer> getSourcestate() {
        return Optional.ofNullable(sourcestate);
    }

    public Rollupfield withSourcestate(Integer sourcestate) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("sourcestate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x.sourcestate = sourcestate;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Rollupfield with_organizationid_value(UUID _organizationid_value) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Rollupfield with_modifiedby_value(UUID _modifiedby_value) {
        Rollupfield _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.rollupfield");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    public Rollupfield withUnmappedField(String name, String value) {
        Rollupfield _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="metricid")
    @JsonIgnore
    public MetricRequest getMetricid() {
        return new MetricRequest(contextPath.addSegment("metricid"), RequestHelper.getValue(unmappedFields, "metricid"));
    }

    @NavigationProperty(name="rollupfield_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getRollupfield_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("rollupfield_ProcessSessions"), RequestHelper.getValue(unmappedFields, "rollupfield_ProcessSessions"));
    }

    @NavigationProperty(name="rollupfield_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getRollupfield_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("rollupfield_AsyncOperations"), RequestHelper.getValue(unmappedFields, "rollupfield_AsyncOperations"));
    }

    @NavigationProperty(name="RollupField_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getRollupField_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("RollupField_SyncErrors"), RequestHelper.getValue(unmappedFields, "RollupField_SyncErrors"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Rollupfield patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Rollupfield _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Rollupfield put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Rollupfield _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Rollupfield _copy() {
        Rollupfield _x = new Rollupfield();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.goalattribute = goalattribute;
        _x._metricid_value = _metricid_value;
        _x.rollupfieldid = rollupfieldid;
        _x.sourceattribute = sourceattribute;
        _x.isstateparententityattribute = isstateparententityattribute;
        _x._createdby_value = _createdby_value;
        _x.sourcestatus = sourcestatus;
        _x.dateattribute = dateattribute;
        _x.createdon = createdon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.versionnumber = versionnumber;
        _x.importsequencenumber = importsequencenumber;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.entityfordateattribute = entityfordateattribute;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.sourceentity = sourceentity;
        _x.sourcestate = sourcestate;
        _x._organizationid_value = _organizationid_value;
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Rollupfield[");
        b.append("goalattribute=");
        b.append(this.goalattribute);
        b.append(", ");
        b.append("_metricid_value=");
        b.append(this._metricid_value);
        b.append(", ");
        b.append("rollupfieldid=");
        b.append(this.rollupfieldid);
        b.append(", ");
        b.append("sourceattribute=");
        b.append(this.sourceattribute);
        b.append(", ");
        b.append("isstateparententityattribute=");
        b.append(this.isstateparententityattribute);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("sourcestatus=");
        b.append(this.sourcestatus);
        b.append(", ");
        b.append("dateattribute=");
        b.append(this.dateattribute);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("entityfordateattribute=");
        b.append(this.entityfordateattribute);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("sourceentity=");
        b.append(this.sourceentity);
        b.append(", ");
        b.append("sourcestate=");
        b.append(this.sourcestate);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
