package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdon", 
    "author", 
    "filetype", 
    "editurl", 
    "versionnumber", 
    "title", 
    "_modifiedby_value", 
    "source", 
    "externaldocumentid", 
    "timezoneruleversionnumber", 
    "_transactioncurrencyid_value", 
    "iconclassname", 
    "externalmodifiedby", 
    "_organizationid_value", 
    "readurl", 
    "location", 
    "exchangerate", 
    "modifiedon", 
    "version", 
    "utcconversiontimezonecode", 
    "fullname", 
    "_createdby_value", 
    "filesize", 
    "absoluteurl", 
    "contenttype", 
    "_createdonbehalfby_value", 
    "_modifiedonbehalfby_value", 
    "recommendeddocumentid", 
    "_regardingobjectid_value", 
    "associatedrecordname"})
@JsonInclude(Include.NON_NULL)
public class Recommendeddocument extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.recommendeddocument";
    }

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("author")
    protected String author;

    @JsonProperty("filetype")
    protected String filetype;

    @JsonProperty("editurl")
    protected String editurl;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("source")
    protected String source;

    @JsonProperty("externaldocumentid")
    protected String externaldocumentid;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("iconclassname")
    protected String iconclassname;

    @JsonProperty("externalmodifiedby")
    protected String externalmodifiedby;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("readurl")
    protected String readurl;

    @JsonProperty("location")
    protected String location;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("fullname")
    protected String fullname;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("filesize")
    protected Integer filesize;

    @JsonProperty("absoluteurl")
    protected String absoluteurl;

    @JsonProperty("contenttype")
    protected String contenttype;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("recommendeddocumentid")
    protected UUID recommendeddocumentid;

    @JsonProperty("_regardingobjectid_value")
    protected UUID _regardingobjectid_value;

    @JsonProperty("associatedrecordname")
    protected String associatedrecordname;

    protected Recommendeddocument() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRecommendeddocument() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime createdon;
        private String author;
        private String filetype;
        private String editurl;
        private Long versionnumber;
        private String title;
        private UUID _modifiedby_value;
        private String source;
        private String externaldocumentid;
        private Integer timezoneruleversionnumber;
        private UUID _transactioncurrencyid_value;
        private String iconclassname;
        private String externalmodifiedby;
        private UUID _organizationid_value;
        private String readurl;
        private String location;
        private BigDecimal exchangerate;
        private OffsetDateTime modifiedon;
        private String version;
        private Integer utcconversiontimezonecode;
        private String fullname;
        private UUID _createdby_value;
        private Integer filesize;
        private String absoluteurl;
        private String contenttype;
        private UUID _createdonbehalfby_value;
        private UUID _modifiedonbehalfby_value;
        private UUID recommendeddocumentid;
        private UUID _regardingobjectid_value;
        private String associatedrecordname;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder author(String author) {
            this.author = author;
            this.changedFields = changedFields.add("author");
            return this;
        }

        public Builder filetype(String filetype) {
            this.filetype = filetype;
            this.changedFields = changedFields.add("filetype");
            return this;
        }

        public Builder editurl(String editurl) {
            this.editurl = editurl;
            this.changedFields = changedFields.add("editurl");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder externaldocumentid(String externaldocumentid) {
            this.externaldocumentid = externaldocumentid;
            this.changedFields = changedFields.add("externaldocumentid");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder iconclassname(String iconclassname) {
            this.iconclassname = iconclassname;
            this.changedFields = changedFields.add("iconclassname");
            return this;
        }

        public Builder externalmodifiedby(String externalmodifiedby) {
            this.externalmodifiedby = externalmodifiedby;
            this.changedFields = changedFields.add("externalmodifiedby");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder readurl(String readurl) {
            this.readurl = readurl;
            this.changedFields = changedFields.add("readurl");
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder fullname(String fullname) {
            this.fullname = fullname;
            this.changedFields = changedFields.add("fullname");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder filesize(Integer filesize) {
            this.filesize = filesize;
            this.changedFields = changedFields.add("filesize");
            return this;
        }

        public Builder absoluteurl(String absoluteurl) {
            this.absoluteurl = absoluteurl;
            this.changedFields = changedFields.add("absoluteurl");
            return this;
        }

        public Builder contenttype(String contenttype) {
            this.contenttype = contenttype;
            this.changedFields = changedFields.add("contenttype");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder recommendeddocumentid(UUID recommendeddocumentid) {
            this.recommendeddocumentid = recommendeddocumentid;
            this.changedFields = changedFields.add("recommendeddocumentid");
            return this;
        }

        public Builder _regardingobjectid_value(UUID _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder associatedrecordname(String associatedrecordname) {
            this.associatedrecordname = associatedrecordname;
            this.changedFields = changedFields.add("associatedrecordname");
            return this;
        }

        public Recommendeddocument build() {
            Recommendeddocument _x = new Recommendeddocument();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.recommendeddocument";
            _x.createdon = createdon;
            _x.author = author;
            _x.filetype = filetype;
            _x.editurl = editurl;
            _x.versionnumber = versionnumber;
            _x.title = title;
            _x._modifiedby_value = _modifiedby_value;
            _x.source = source;
            _x.externaldocumentid = externaldocumentid;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.iconclassname = iconclassname;
            _x.externalmodifiedby = externalmodifiedby;
            _x._organizationid_value = _organizationid_value;
            _x.readurl = readurl;
            _x.location = location;
            _x.exchangerate = exchangerate;
            _x.modifiedon = modifiedon;
            _x.version = version;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.fullname = fullname;
            _x._createdby_value = _createdby_value;
            _x.filesize = filesize;
            _x.absoluteurl = absoluteurl;
            _x.contenttype = contenttype;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.recommendeddocumentid = recommendeddocumentid;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.associatedrecordname = associatedrecordname;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && recommendeddocumentid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(recommendeddocumentid, UUID.class));
        }
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Recommendeddocument withCreatedon(OffsetDateTime createdon) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="author")
    @JsonIgnore
    public Optional<String> getAuthor() {
        return Optional.ofNullable(author);
    }

    public Recommendeddocument withAuthor(String author) {
        Checks.checkIsAscii(author);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("author");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.author = author;
        return _x;
    }

    @Property(name="filetype")
    @JsonIgnore
    public Optional<String> getFiletype() {
        return Optional.ofNullable(filetype);
    }

    public Recommendeddocument withFiletype(String filetype) {
        Checks.checkIsAscii(filetype);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("filetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.filetype = filetype;
        return _x;
    }

    @Property(name="editurl")
    @JsonIgnore
    public Optional<String> getEditurl() {
        return Optional.ofNullable(editurl);
    }

    public Recommendeddocument withEditurl(String editurl) {
        Checks.checkIsAscii(editurl);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("editurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.editurl = editurl;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Recommendeddocument withVersionnumber(Long versionnumber) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Recommendeddocument withTitle(String title) {
        Checks.checkIsAscii(title);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.title = title;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Recommendeddocument with_modifiedby_value(UUID _modifiedby_value) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<String> getSource() {
        return Optional.ofNullable(source);
    }

    public Recommendeddocument withSource(String source) {
        Checks.checkIsAscii(source);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.source = source;
        return _x;
    }

    @Property(name="externaldocumentid")
    @JsonIgnore
    public Optional<String> getExternaldocumentid() {
        return Optional.ofNullable(externaldocumentid);
    }

    public Recommendeddocument withExternaldocumentid(String externaldocumentid) {
        Checks.checkIsAscii(externaldocumentid);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("externaldocumentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.externaldocumentid = externaldocumentid;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Recommendeddocument withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Recommendeddocument with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="iconclassname")
    @JsonIgnore
    public Optional<String> getIconclassname() {
        return Optional.ofNullable(iconclassname);
    }

    public Recommendeddocument withIconclassname(String iconclassname) {
        Checks.checkIsAscii(iconclassname);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("iconclassname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.iconclassname = iconclassname;
        return _x;
    }

    @Property(name="externalmodifiedby")
    @JsonIgnore
    public Optional<String> getExternalmodifiedby() {
        return Optional.ofNullable(externalmodifiedby);
    }

    public Recommendeddocument withExternalmodifiedby(String externalmodifiedby) {
        Checks.checkIsAscii(externalmodifiedby);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("externalmodifiedby");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.externalmodifiedby = externalmodifiedby;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Recommendeddocument with_organizationid_value(UUID _organizationid_value) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="readurl")
    @JsonIgnore
    public Optional<String> getReadurl() {
        return Optional.ofNullable(readurl);
    }

    public Recommendeddocument withReadurl(String readurl) {
        Checks.checkIsAscii(readurl);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("readurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.readurl = readurl;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<String> getLocation() {
        return Optional.ofNullable(location);
    }

    public Recommendeddocument withLocation(String location) {
        Checks.checkIsAscii(location);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.location = location;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Recommendeddocument withExchangerate(BigDecimal exchangerate) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Recommendeddocument withModifiedon(OffsetDateTime modifiedon) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public Recommendeddocument withVersion(String version) {
        Checks.checkIsAscii(version);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.version = version;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Recommendeddocument withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="fullname")
    @JsonIgnore
    public Optional<String> getFullname() {
        return Optional.ofNullable(fullname);
    }

    public Recommendeddocument withFullname(String fullname) {
        Checks.checkIsAscii(fullname);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("fullname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.fullname = fullname;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Recommendeddocument with_createdby_value(UUID _createdby_value) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="filesize")
    @JsonIgnore
    public Optional<Integer> getFilesize() {
        return Optional.ofNullable(filesize);
    }

    public Recommendeddocument withFilesize(Integer filesize) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("filesize");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.filesize = filesize;
        return _x;
    }

    @Property(name="absoluteurl")
    @JsonIgnore
    public Optional<String> getAbsoluteurl() {
        return Optional.ofNullable(absoluteurl);
    }

    public Recommendeddocument withAbsoluteurl(String absoluteurl) {
        Checks.checkIsAscii(absoluteurl);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("absoluteurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.absoluteurl = absoluteurl;
        return _x;
    }

    @Property(name="contenttype")
    @JsonIgnore
    public Optional<String> getContenttype() {
        return Optional.ofNullable(contenttype);
    }

    public Recommendeddocument withContenttype(String contenttype) {
        Checks.checkIsAscii(contenttype);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("contenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.contenttype = contenttype;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Recommendeddocument with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Recommendeddocument with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="recommendeddocumentid")
    @JsonIgnore
    public Optional<UUID> getRecommendeddocumentid() {
        return Optional.ofNullable(recommendeddocumentid);
    }

    public Recommendeddocument withRecommendeddocumentid(UUID recommendeddocumentid) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("recommendeddocumentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.recommendeddocumentid = recommendeddocumentid;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Recommendeddocument with_regardingobjectid_value(UUID _regardingobjectid_value) {
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="associatedrecordname")
    @JsonIgnore
    public Optional<String> getAssociatedrecordname() {
        return Optional.ofNullable(associatedrecordname);
    }

    public Recommendeddocument withAssociatedrecordname(String associatedrecordname) {
        Checks.checkIsAscii(associatedrecordname);
        Recommendeddocument _x = _copy();
        _x.changedFields = changedFields.add("associatedrecordname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recommendeddocument");
        _x.associatedrecordname = associatedrecordname;
        return _x;
    }

    public Recommendeddocument withUnmappedField(String name, String value) {
        Recommendeddocument _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdbyname")
    @JsonIgnore
    public SystemuserRequest getCreatedbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdbyname"), RequestHelper.getValue(unmappedFields, "createdbyname"));
    }

    @NavigationProperty(name="createdonbehalfbyname")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfbyname"), RequestHelper.getValue(unmappedFields, "createdonbehalfbyname"));
    }

    @NavigationProperty(name="modifiedbyname")
    @JsonIgnore
    public SystemuserRequest getModifiedbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedbyname"), RequestHelper.getValue(unmappedFields, "modifiedbyname"));
    }

    @NavigationProperty(name="modifiedonbehalfbyname")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfbyname"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfbyname"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="transactioncurrencyidname")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyidname() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyidname"), RequestHelper.getValue(unmappedFields, "transactioncurrencyidname"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Recommendeddocument patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Recommendeddocument _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Recommendeddocument put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Recommendeddocument _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Recommendeddocument _copy() {
        Recommendeddocument _x = new Recommendeddocument();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.createdon = createdon;
        _x.author = author;
        _x.filetype = filetype;
        _x.editurl = editurl;
        _x.versionnumber = versionnumber;
        _x.title = title;
        _x._modifiedby_value = _modifiedby_value;
        _x.source = source;
        _x.externaldocumentid = externaldocumentid;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.iconclassname = iconclassname;
        _x.externalmodifiedby = externalmodifiedby;
        _x._organizationid_value = _organizationid_value;
        _x.readurl = readurl;
        _x.location = location;
        _x.exchangerate = exchangerate;
        _x.modifiedon = modifiedon;
        _x.version = version;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.fullname = fullname;
        _x._createdby_value = _createdby_value;
        _x.filesize = filesize;
        _x.absoluteurl = absoluteurl;
        _x.contenttype = contenttype;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.recommendeddocumentid = recommendeddocumentid;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.associatedrecordname = associatedrecordname;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Recommendeddocument[");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("author=");
        b.append(this.author);
        b.append(", ");
        b.append("filetype=");
        b.append(this.filetype);
        b.append(", ");
        b.append("editurl=");
        b.append(this.editurl);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("externaldocumentid=");
        b.append(this.externaldocumentid);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("iconclassname=");
        b.append(this.iconclassname);
        b.append(", ");
        b.append("externalmodifiedby=");
        b.append(this.externalmodifiedby);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("readurl=");
        b.append(this.readurl);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("fullname=");
        b.append(this.fullname);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("filesize=");
        b.append(this.filesize);
        b.append(", ");
        b.append("absoluteurl=");
        b.append(this.absoluteurl);
        b.append(", ");
        b.append("contenttype=");
        b.append(this.contenttype);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("recommendeddocumentid=");
        b.append(this.recommendeddocumentid);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("associatedrecordname=");
        b.append(this.associatedrecordname);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
