package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.AddToQueueResponse;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.MailboxRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "entityimage_timestamp", 
    "versionnumber", 
    "name", 
    "queueviewtype", 
    "entityimage_url", 
    "outgoingemaildeliverymethod", 
    "_owningbusinessunit_value", 
    "_modifiedby_value", 
    "ignoreunsolicitedemail", 
    "emailaddress", 
    "incomingemaildeliverymethod", 
    "_ownerid_value", 
    "importsequencenumber", 
    "_owninguser_value", 
    "description", 
    "entityimage", 
    "_createdby_value", 
    "_createdonbehalfby_value", 
    "statecode", 
    "_organizationid_value", 
    "statuscode", 
    "_modifiedonbehalfby_value", 
    "exchangerate", 
    "_transactioncurrencyid_value", 
    "entityimageid", 
    "queueid", 
    "emailrouteraccessapproval", 
    "_defaultmailbox_value", 
    "modifiedon", 
    "overriddencreatedon", 
    "isemailaddressapprovedbyo365admin", 
    "createdon", 
    "numberofmembers", 
    "_owningteam_value", 
    "queuetypecode", 
    "incomingemailfilteringmethod", 
    "numberofitems"})
@JsonInclude(Include.NON_NULL)
public class Queue extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.queue";
    }

    @JsonProperty("entityimage_timestamp")
    protected Long entityimage_timestamp;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("queueviewtype")
    protected Integer queueviewtype;

    @JsonProperty("entityimage_url")
    protected String entityimage_url;

    @JsonProperty("outgoingemaildeliverymethod")
    protected Integer outgoingemaildeliverymethod;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("ignoreunsolicitedemail")
    protected Boolean ignoreunsolicitedemail;

    @JsonProperty("emailaddress")
    protected String emailaddress;

    @JsonProperty("incomingemaildeliverymethod")
    protected Integer incomingemaildeliverymethod;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("entityimage")
    protected byte[] entityimage;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("entityimageid")
    protected UUID entityimageid;

    @JsonProperty("queueid")
    protected UUID queueid;

    @JsonProperty("emailrouteraccessapproval")
    protected Integer emailrouteraccessapproval;

    @JsonProperty("_defaultmailbox_value")
    protected UUID _defaultmailbox_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("isemailaddressapprovedbyo365admin")
    protected Boolean isemailaddressapprovedbyo365admin;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("numberofmembers")
    protected Integer numberofmembers;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("queuetypecode")
    protected Integer queuetypecode;

    @JsonProperty("incomingemailfilteringmethod")
    protected Integer incomingemailfilteringmethod;

    @JsonProperty("numberofitems")
    protected Integer numberofitems;

    protected Queue() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderQueue() {
        return new Builder();
    }

    public static final class Builder {
        private Long entityimage_timestamp;
        private Long versionnumber;
        private String name;
        private Integer queueviewtype;
        private String entityimage_url;
        private Integer outgoingemaildeliverymethod;
        private UUID _owningbusinessunit_value;
        private UUID _modifiedby_value;
        private Boolean ignoreunsolicitedemail;
        private String emailaddress;
        private Integer incomingemaildeliverymethod;
        private UUID _ownerid_value;
        private Integer importsequencenumber;
        private UUID _owninguser_value;
        private String description;
        private byte[] entityimage;
        private UUID _createdby_value;
        private UUID _createdonbehalfby_value;
        private Integer statecode;
        private UUID _organizationid_value;
        private Integer statuscode;
        private UUID _modifiedonbehalfby_value;
        private BigDecimal exchangerate;
        private UUID _transactioncurrencyid_value;
        private UUID entityimageid;
        private UUID queueid;
        private Integer emailrouteraccessapproval;
        private UUID _defaultmailbox_value;
        private OffsetDateTime modifiedon;
        private OffsetDateTime overriddencreatedon;
        private Boolean isemailaddressapprovedbyo365admin;
        private OffsetDateTime createdon;
        private Integer numberofmembers;
        private UUID _owningteam_value;
        private Integer queuetypecode;
        private Integer incomingemailfilteringmethod;
        private Integer numberofitems;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder entityimage_timestamp(Long entityimage_timestamp) {
            this.entityimage_timestamp = entityimage_timestamp;
            this.changedFields = changedFields.add("entityimage_timestamp");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder queueviewtype(Integer queueviewtype) {
            this.queueviewtype = queueviewtype;
            this.changedFields = changedFields.add("queueviewtype");
            return this;
        }

        public Builder entityimage_url(String entityimage_url) {
            this.entityimage_url = entityimage_url;
            this.changedFields = changedFields.add("entityimage_url");
            return this;
        }

        public Builder outgoingemaildeliverymethod(Integer outgoingemaildeliverymethod) {
            this.outgoingemaildeliverymethod = outgoingemaildeliverymethod;
            this.changedFields = changedFields.add("outgoingemaildeliverymethod");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder ignoreunsolicitedemail(Boolean ignoreunsolicitedemail) {
            this.ignoreunsolicitedemail = ignoreunsolicitedemail;
            this.changedFields = changedFields.add("ignoreunsolicitedemail");
            return this;
        }

        public Builder emailaddress(String emailaddress) {
            this.emailaddress = emailaddress;
            this.changedFields = changedFields.add("emailaddress");
            return this;
        }

        public Builder incomingemaildeliverymethod(Integer incomingemaildeliverymethod) {
            this.incomingemaildeliverymethod = incomingemaildeliverymethod;
            this.changedFields = changedFields.add("incomingemaildeliverymethod");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder entityimage(byte[] entityimage) {
            this.entityimage = entityimage;
            this.changedFields = changedFields.add("entityimage");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder entityimageid(UUID entityimageid) {
            this.entityimageid = entityimageid;
            this.changedFields = changedFields.add("entityimageid");
            return this;
        }

        public Builder queueid(UUID queueid) {
            this.queueid = queueid;
            this.changedFields = changedFields.add("queueid");
            return this;
        }

        public Builder emailrouteraccessapproval(Integer emailrouteraccessapproval) {
            this.emailrouteraccessapproval = emailrouteraccessapproval;
            this.changedFields = changedFields.add("emailrouteraccessapproval");
            return this;
        }

        public Builder _defaultmailbox_value(UUID _defaultmailbox_value) {
            this._defaultmailbox_value = _defaultmailbox_value;
            this.changedFields = changedFields.add("_defaultmailbox_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder isemailaddressapprovedbyo365admin(Boolean isemailaddressapprovedbyo365admin) {
            this.isemailaddressapprovedbyo365admin = isemailaddressapprovedbyo365admin;
            this.changedFields = changedFields.add("isemailaddressapprovedbyo365admin");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder numberofmembers(Integer numberofmembers) {
            this.numberofmembers = numberofmembers;
            this.changedFields = changedFields.add("numberofmembers");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder queuetypecode(Integer queuetypecode) {
            this.queuetypecode = queuetypecode;
            this.changedFields = changedFields.add("queuetypecode");
            return this;
        }

        public Builder incomingemailfilteringmethod(Integer incomingemailfilteringmethod) {
            this.incomingemailfilteringmethod = incomingemailfilteringmethod;
            this.changedFields = changedFields.add("incomingemailfilteringmethod");
            return this;
        }

        public Builder numberofitems(Integer numberofitems) {
            this.numberofitems = numberofitems;
            this.changedFields = changedFields.add("numberofitems");
            return this;
        }

        public Queue build() {
            Queue _x = new Queue();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.queue";
            _x.entityimage_timestamp = entityimage_timestamp;
            _x.versionnumber = versionnumber;
            _x.name = name;
            _x.queueviewtype = queueviewtype;
            _x.entityimage_url = entityimage_url;
            _x.outgoingemaildeliverymethod = outgoingemaildeliverymethod;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.ignoreunsolicitedemail = ignoreunsolicitedemail;
            _x.emailaddress = emailaddress;
            _x.incomingemaildeliverymethod = incomingemaildeliverymethod;
            _x._ownerid_value = _ownerid_value;
            _x.importsequencenumber = importsequencenumber;
            _x._owninguser_value = _owninguser_value;
            _x.description = description;
            _x.entityimage = entityimage;
            _x._createdby_value = _createdby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.statecode = statecode;
            _x._organizationid_value = _organizationid_value;
            _x.statuscode = statuscode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.exchangerate = exchangerate;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.entityimageid = entityimageid;
            _x.queueid = queueid;
            _x.emailrouteraccessapproval = emailrouteraccessapproval;
            _x._defaultmailbox_value = _defaultmailbox_value;
            _x.modifiedon = modifiedon;
            _x.overriddencreatedon = overriddencreatedon;
            _x.isemailaddressapprovedbyo365admin = isemailaddressapprovedbyo365admin;
            _x.createdon = createdon;
            _x.numberofmembers = numberofmembers;
            _x._owningteam_value = _owningteam_value;
            _x.queuetypecode = queuetypecode;
            _x.incomingemailfilteringmethod = incomingemailfilteringmethod;
            _x.numberofitems = numberofitems;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && queueid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(queueid, UUID.class));
        }
    }

    @Property(name="entityimage_timestamp")
    @JsonIgnore
    public Optional<Long> getEntityimage_timestamp() {
        return Optional.ofNullable(entityimage_timestamp);
    }

    public Queue withEntityimage_timestamp(Long entityimage_timestamp) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("entityimage_timestamp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.entityimage_timestamp = entityimage_timestamp;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Queue withVersionnumber(Long versionnumber) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Queue withName(String name) {
        Checks.checkIsAscii(name);
        Queue _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.name = name;
        return _x;
    }

    @Property(name="queueviewtype")
    @JsonIgnore
    public Optional<Integer> getQueueviewtype() {
        return Optional.ofNullable(queueviewtype);
    }

    public Queue withQueueviewtype(Integer queueviewtype) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("queueviewtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.queueviewtype = queueviewtype;
        return _x;
    }

    @Property(name="entityimage_url")
    @JsonIgnore
    public Optional<String> getEntityimage_url() {
        return Optional.ofNullable(entityimage_url);
    }

    public Queue withEntityimage_url(String entityimage_url) {
        Checks.checkIsAscii(entityimage_url);
        Queue _x = _copy();
        _x.changedFields = changedFields.add("entityimage_url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.entityimage_url = entityimage_url;
        return _x;
    }

    @Property(name="outgoingemaildeliverymethod")
    @JsonIgnore
    public Optional<Integer> getOutgoingemaildeliverymethod() {
        return Optional.ofNullable(outgoingemaildeliverymethod);
    }

    public Queue withOutgoingemaildeliverymethod(Integer outgoingemaildeliverymethod) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("outgoingemaildeliverymethod");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.outgoingemaildeliverymethod = outgoingemaildeliverymethod;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Queue with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Queue with_modifiedby_value(UUID _modifiedby_value) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="ignoreunsolicitedemail")
    @JsonIgnore
    public Optional<Boolean> getIgnoreunsolicitedemail() {
        return Optional.ofNullable(ignoreunsolicitedemail);
    }

    public Queue withIgnoreunsolicitedemail(Boolean ignoreunsolicitedemail) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("ignoreunsolicitedemail");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.ignoreunsolicitedemail = ignoreunsolicitedemail;
        return _x;
    }

    @Property(name="emailaddress")
    @JsonIgnore
    public Optional<String> getEmailaddress() {
        return Optional.ofNullable(emailaddress);
    }

    public Queue withEmailaddress(String emailaddress) {
        Checks.checkIsAscii(emailaddress);
        Queue _x = _copy();
        _x.changedFields = changedFields.add("emailaddress");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.emailaddress = emailaddress;
        return _x;
    }

    @Property(name="incomingemaildeliverymethod")
    @JsonIgnore
    public Optional<Integer> getIncomingemaildeliverymethod() {
        return Optional.ofNullable(incomingemaildeliverymethod);
    }

    public Queue withIncomingemaildeliverymethod(Integer incomingemaildeliverymethod) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("incomingemaildeliverymethod");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.incomingemaildeliverymethod = incomingemaildeliverymethod;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Queue with_ownerid_value(UUID _ownerid_value) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Queue withImportsequencenumber(Integer importsequencenumber) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Queue with_owninguser_value(UUID _owninguser_value) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Queue withDescription(String description) {
        Checks.checkIsAscii(description);
        Queue _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.description = description;
        return _x;
    }

    @Property(name="entityimage")
    @JsonIgnore
    public Optional<byte[]> getEntityimage() {
        return Optional.ofNullable(entityimage);
    }

    public Queue withEntityimage(byte[] entityimage) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("entityimage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.entityimage = entityimage;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Queue with_createdby_value(UUID _createdby_value) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Queue with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Queue withStatecode(Integer statecode) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Queue with_organizationid_value(UUID _organizationid_value) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Queue withStatuscode(Integer statuscode) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Queue with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Queue withExchangerate(BigDecimal exchangerate) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Queue with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="entityimageid")
    @JsonIgnore
    public Optional<UUID> getEntityimageid() {
        return Optional.ofNullable(entityimageid);
    }

    public Queue withEntityimageid(UUID entityimageid) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("entityimageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.entityimageid = entityimageid;
        return _x;
    }

    @Property(name="queueid")
    @JsonIgnore
    public Optional<UUID> getQueueid() {
        return Optional.ofNullable(queueid);
    }

    public Queue withQueueid(UUID queueid) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("queueid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.queueid = queueid;
        return _x;
    }

    @Property(name="emailrouteraccessapproval")
    @JsonIgnore
    public Optional<Integer> getEmailrouteraccessapproval() {
        return Optional.ofNullable(emailrouteraccessapproval);
    }

    public Queue withEmailrouteraccessapproval(Integer emailrouteraccessapproval) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("emailrouteraccessapproval");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.emailrouteraccessapproval = emailrouteraccessapproval;
        return _x;
    }

    @Property(name="_defaultmailbox_value")
    @JsonIgnore
    public Optional<UUID> get_defaultmailbox_value() {
        return Optional.ofNullable(_defaultmailbox_value);
    }

    public Queue with_defaultmailbox_value(UUID _defaultmailbox_value) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("_defaultmailbox_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x._defaultmailbox_value = _defaultmailbox_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Queue withModifiedon(OffsetDateTime modifiedon) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Queue withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="isemailaddressapprovedbyo365admin")
    @JsonIgnore
    public Optional<Boolean> getIsemailaddressapprovedbyo365admin() {
        return Optional.ofNullable(isemailaddressapprovedbyo365admin);
    }

    public Queue withIsemailaddressapprovedbyo365admin(Boolean isemailaddressapprovedbyo365admin) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("isemailaddressapprovedbyo365admin");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.isemailaddressapprovedbyo365admin = isemailaddressapprovedbyo365admin;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Queue withCreatedon(OffsetDateTime createdon) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="numberofmembers")
    @JsonIgnore
    public Optional<Integer> getNumberofmembers() {
        return Optional.ofNullable(numberofmembers);
    }

    public Queue withNumberofmembers(Integer numberofmembers) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("numberofmembers");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.numberofmembers = numberofmembers;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Queue with_owningteam_value(UUID _owningteam_value) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="queuetypecode")
    @JsonIgnore
    public Optional<Integer> getQueuetypecode() {
        return Optional.ofNullable(queuetypecode);
    }

    public Queue withQueuetypecode(Integer queuetypecode) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("queuetypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.queuetypecode = queuetypecode;
        return _x;
    }

    @Property(name="incomingemailfilteringmethod")
    @JsonIgnore
    public Optional<Integer> getIncomingemailfilteringmethod() {
        return Optional.ofNullable(incomingemailfilteringmethod);
    }

    public Queue withIncomingemailfilteringmethod(Integer incomingemailfilteringmethod) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("incomingemailfilteringmethod");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.incomingemailfilteringmethod = incomingemailfilteringmethod;
        return _x;
    }

    @Property(name="numberofitems")
    @JsonIgnore
    public Optional<Integer> getNumberofitems() {
        return Optional.ofNullable(numberofitems);
    }

    public Queue withNumberofitems(Integer numberofitems) {
        Queue _x = _copy();
        _x.changedFields = changedFields.add("numberofitems");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queue");
        _x.numberofitems = numberofitems;
        return _x;
    }

    public Queue withUnmappedField(String name, String value) {
        Queue _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="defaultmailbox")
    @JsonIgnore
    public MailboxRequest getDefaultmailbox() {
        return new MailboxRequest(contextPath.addSegment("defaultmailbox"), RequestHelper.getValue(unmappedFields, "defaultmailbox"));
    }

    @NavigationProperty(name="Queue_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getQueue_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Queue_ProcessSessions"), RequestHelper.getValue(unmappedFields, "Queue_ProcessSessions"));
    }

    @NavigationProperty(name="Queue_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getQueue_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Queue_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Queue_BulkDeleteFailures"));
    }

    @NavigationProperty(name="businessunitid")
    @JsonIgnore
    public BusinessunitRequest getBusinessunitid() {
        return new BusinessunitRequest(contextPath.addSegment("businessunitid"), RequestHelper.getValue(unmappedFields, "businessunitid"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="queue_PostFollows")
    @JsonIgnore
    public PostfollowCollectionRequest getQueue_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("queue_PostFollows"), RequestHelper.getValue(unmappedFields, "queue_PostFollows"));
    }

    @NavigationProperty(name="mailbox_regarding_queue")
    @JsonIgnore
    public MailboxCollectionRequest getMailbox_regarding_queue() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("mailbox_regarding_queue"), RequestHelper.getValue(unmappedFields, "mailbox_regarding_queue"));
    }

    @NavigationProperty(name="queue_team")
    @JsonIgnore
    public TeamCollectionRequest getQueue_team() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("queue_team"), RequestHelper.getValue(unmappedFields, "queue_team"));
    }

    @NavigationProperty(name="queue_entries")
    @JsonIgnore
    public QueueitemCollectionRequest getQueue_entries() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("queue_entries"), RequestHelper.getValue(unmappedFields, "queue_entries"));
    }

    @NavigationProperty(name="queue_activity_parties")
    @JsonIgnore
    public ActivitypartyCollectionRequest getQueue_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("queue_activity_parties"), RequestHelper.getValue(unmappedFields, "queue_activity_parties"));
    }

    @NavigationProperty(name="Queue_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getQueue_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Queue_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Queue_AsyncOperations"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="primaryuserid")
    @JsonIgnore
    public SystemuserRequest getPrimaryuserid() {
        return new SystemuserRequest(contextPath.addSegment("primaryuserid"), RequestHelper.getValue(unmappedFields, "primaryuserid"));
    }

    @NavigationProperty(name="Queue_Email_EmailSender")
    @JsonIgnore
    public EmailCollectionRequest getQueue_Email_EmailSender() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("Queue_Email_EmailSender"), RequestHelper.getValue(unmappedFields, "Queue_Email_EmailSender"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="queuemembership_association")
    @JsonIgnore
    public SystemuserCollectionRequest getQueuemembership_association() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("queuemembership_association"), RequestHelper.getValue(unmappedFields, "queuemembership_association"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="Queue_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getQueue_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Queue_SyncErrors"), RequestHelper.getValue(unmappedFields, "Queue_SyncErrors"));
    }

    @NavigationProperty(name="queue_system_user")
    @JsonIgnore
    public SystemuserCollectionRequest getQueue_system_user() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("queue_system_user"), RequestHelper.getValue(unmappedFields, "queue_system_user"));
    }

    @NavigationProperty(name="queue_PostRegardings")
    @JsonIgnore
    public PostregardingCollectionRequest getQueue_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("queue_PostRegardings"), RequestHelper.getValue(unmappedFields, "queue_PostRegardings"));
    }

    @NavigationProperty(name="queue_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getQueue_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("queue_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "queue_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="Queue_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getQueue_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Queue_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "Queue_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="Queue_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getQueue_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Queue_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "Queue_DuplicateBaseRecord"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Queue patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Queue _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Queue put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Queue _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Queue _copy() {
        Queue _x = new Queue();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityimage_timestamp = entityimage_timestamp;
        _x.versionnumber = versionnumber;
        _x.name = name;
        _x.queueviewtype = queueviewtype;
        _x.entityimage_url = entityimage_url;
        _x.outgoingemaildeliverymethod = outgoingemaildeliverymethod;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.ignoreunsolicitedemail = ignoreunsolicitedemail;
        _x.emailaddress = emailaddress;
        _x.incomingemaildeliverymethod = incomingemaildeliverymethod;
        _x._ownerid_value = _ownerid_value;
        _x.importsequencenumber = importsequencenumber;
        _x._owninguser_value = _owninguser_value;
        _x.description = description;
        _x.entityimage = entityimage;
        _x._createdby_value = _createdby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.statecode = statecode;
        _x._organizationid_value = _organizationid_value;
        _x.statuscode = statuscode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.exchangerate = exchangerate;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.entityimageid = entityimageid;
        _x.queueid = queueid;
        _x.emailrouteraccessapproval = emailrouteraccessapproval;
        _x._defaultmailbox_value = _defaultmailbox_value;
        _x.modifiedon = modifiedon;
        _x.overriddencreatedon = overriddencreatedon;
        _x.isemailaddressapprovedbyo365admin = isemailaddressapprovedbyo365admin;
        _x.createdon = createdon;
        _x.numberofmembers = numberofmembers;
        _x._owningteam_value = _owningteam_value;
        _x.queuetypecode = queuetypecode;
        _x.incomingemailfilteringmethod = incomingemailfilteringmethod;
        _x.numberofitems = numberofitems;
        return _x;
    }

    @Action(name = "AddPrincipalToQueue")
    @JsonIgnore
    public ActionRequestNoReturn addPrincipalToQueue(Crmbaseentity principal) {
        Preconditions.checkNotNull(principal, "principal cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Principal", "Microsoft.Dynamics.CRM.crmbaseentity", principal)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddPrincipalToQueue"), _parameters);
    }

    @Action(name = "AddToQueue")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AddToQueueResponse> addToQueue(Crmbaseentity target, Queue sourceQueue, Queueitem queueItemProperties) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .put("SourceQueue", "Microsoft.Dynamics.CRM.queue", sourceQueue)
            .put("QueueItemProperties", "Microsoft.Dynamics.CRM.queueitem", queueItemProperties)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AddToQueueResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddToQueue"), AddToQueueResponse.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Queue[");
        b.append("entityimage_timestamp=");
        b.append(this.entityimage_timestamp);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("queueviewtype=");
        b.append(this.queueviewtype);
        b.append(", ");
        b.append("entityimage_url=");
        b.append(this.entityimage_url);
        b.append(", ");
        b.append("outgoingemaildeliverymethod=");
        b.append(this.outgoingemaildeliverymethod);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("ignoreunsolicitedemail=");
        b.append(this.ignoreunsolicitedemail);
        b.append(", ");
        b.append("emailaddress=");
        b.append(this.emailaddress);
        b.append(", ");
        b.append("incomingemaildeliverymethod=");
        b.append(this.incomingemaildeliverymethod);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("entityimage=");
        b.append(this.entityimage);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("entityimageid=");
        b.append(this.entityimageid);
        b.append(", ");
        b.append("queueid=");
        b.append(this.queueid);
        b.append(", ");
        b.append("emailrouteraccessapproval=");
        b.append(this.emailrouteraccessapproval);
        b.append(", ");
        b.append("_defaultmailbox_value=");
        b.append(this._defaultmailbox_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("isemailaddressapprovedbyo365admin=");
        b.append(this.isemailaddressapprovedbyo365admin);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("numberofmembers=");
        b.append(this.numberofmembers);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("queuetypecode=");
        b.append(this.queuetypecode);
        b.append(", ");
        b.append("incomingemailfilteringmethod=");
        b.append(this.incomingemailfilteringmethod);
        b.append(", ");
        b.append("numberofitems=");
        b.append(this.numberofitems);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
