package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowlogCollectionRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "statuscode", 
    "createdon", 
    "_modifiedonbehalfby_value", 
    "_createdby_value", 
    "_organizationid_value", 
    "completedon", 
    "statecode", 
    "_modifiedby_value", 
    "_transactioncurrencyid_value", 
    "activestagestartedon", 
    "modifiedon", 
    "_createdonbehalfby_value", 
    "duration", 
    "overriddencreatedon", 
    "exchangerate", 
    "importsequencenumber", 
    "name", 
    "traversedpath", 
    "versionnumber", 
    "_knowledgearticleid_value", 
    "_processid_value", 
    "_activestageid_value", 
    "businessprocessflowinstanceid"})
@JsonInclude(Include.NON_NULL)
public class Newprocess extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.newprocess";
    }

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("completedon")
    protected OffsetDateTime completedon;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("activestagestartedon")
    protected OffsetDateTime activestagestartedon;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("duration")
    protected Integer duration;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("traversedpath")
    protected String traversedpath;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_knowledgearticleid_value")
    protected UUID _knowledgearticleid_value;

    @JsonProperty("_processid_value")
    protected UUID _processid_value;

    @JsonProperty("_activestageid_value")
    protected UUID _activestageid_value;

    @JsonProperty("businessprocessflowinstanceid")
    protected UUID businessprocessflowinstanceid;

    protected Newprocess() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNewprocess() {
        return new Builder();
    }

    public static final class Builder {
        private Integer statuscode;
        private OffsetDateTime createdon;
        private UUID _modifiedonbehalfby_value;
        private UUID _createdby_value;
        private UUID _organizationid_value;
        private OffsetDateTime completedon;
        private Integer statecode;
        private UUID _modifiedby_value;
        private UUID _transactioncurrencyid_value;
        private OffsetDateTime activestagestartedon;
        private OffsetDateTime modifiedon;
        private UUID _createdonbehalfby_value;
        private Integer duration;
        private OffsetDateTime overriddencreatedon;
        private BigDecimal exchangerate;
        private Integer importsequencenumber;
        private String name;
        private String traversedpath;
        private Long versionnumber;
        private UUID _knowledgearticleid_value;
        private UUID _processid_value;
        private UUID _activestageid_value;
        private UUID businessprocessflowinstanceid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder completedon(OffsetDateTime completedon) {
            this.completedon = completedon;
            this.changedFields = changedFields.add("completedon");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder activestagestartedon(OffsetDateTime activestagestartedon) {
            this.activestagestartedon = activestagestartedon;
            this.changedFields = changedFields.add("activestagestartedon");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder traversedpath(String traversedpath) {
            this.traversedpath = traversedpath;
            this.changedFields = changedFields.add("traversedpath");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _knowledgearticleid_value(UUID _knowledgearticleid_value) {
            this._knowledgearticleid_value = _knowledgearticleid_value;
            this.changedFields = changedFields.add("_knowledgearticleid_value");
            return this;
        }

        public Builder _processid_value(UUID _processid_value) {
            this._processid_value = _processid_value;
            this.changedFields = changedFields.add("_processid_value");
            return this;
        }

        public Builder _activestageid_value(UUID _activestageid_value) {
            this._activestageid_value = _activestageid_value;
            this.changedFields = changedFields.add("_activestageid_value");
            return this;
        }

        public Builder businessprocessflowinstanceid(UUID businessprocessflowinstanceid) {
            this.businessprocessflowinstanceid = businessprocessflowinstanceid;
            this.changedFields = changedFields.add("businessprocessflowinstanceid");
            return this;
        }

        public Newprocess build() {
            Newprocess _x = new Newprocess();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.newprocess";
            _x.statuscode = statuscode;
            _x.createdon = createdon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x._organizationid_value = _organizationid_value;
            _x.completedon = completedon;
            _x.statecode = statecode;
            _x._modifiedby_value = _modifiedby_value;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.activestagestartedon = activestagestartedon;
            _x.modifiedon = modifiedon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.duration = duration;
            _x.overriddencreatedon = overriddencreatedon;
            _x.exchangerate = exchangerate;
            _x.importsequencenumber = importsequencenumber;
            _x.name = name;
            _x.traversedpath = traversedpath;
            _x.versionnumber = versionnumber;
            _x._knowledgearticleid_value = _knowledgearticleid_value;
            _x._processid_value = _processid_value;
            _x._activestageid_value = _activestageid_value;
            _x.businessprocessflowinstanceid = businessprocessflowinstanceid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && businessprocessflowinstanceid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(businessprocessflowinstanceid, UUID.class));
        }
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Newprocess withStatuscode(Integer statuscode) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Newprocess withCreatedon(OffsetDateTime createdon) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Newprocess with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Newprocess with_createdby_value(UUID _createdby_value) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Newprocess with_organizationid_value(UUID _organizationid_value) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="completedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedon() {
        return Optional.ofNullable(completedon);
    }

    public Newprocess withCompletedon(OffsetDateTime completedon) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("completedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.completedon = completedon;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Newprocess withStatecode(Integer statecode) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Newprocess with_modifiedby_value(UUID _modifiedby_value) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Newprocess with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="activestagestartedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getActivestagestartedon() {
        return Optional.ofNullable(activestagestartedon);
    }

    public Newprocess withActivestagestartedon(OffsetDateTime activestagestartedon) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("activestagestartedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.activestagestartedon = activestagestartedon;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Newprocess withModifiedon(OffsetDateTime modifiedon) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Newprocess with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<Integer> getDuration() {
        return Optional.ofNullable(duration);
    }

    public Newprocess withDuration(Integer duration) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("duration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.duration = duration;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Newprocess withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Newprocess withExchangerate(BigDecimal exchangerate) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Newprocess withImportsequencenumber(Integer importsequencenumber) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Newprocess withName(String name) {
        Checks.checkIsAscii(name);
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.name = name;
        return _x;
    }

    @Property(name="traversedpath")
    @JsonIgnore
    public Optional<String> getTraversedpath() {
        return Optional.ofNullable(traversedpath);
    }

    public Newprocess withTraversedpath(String traversedpath) {
        Checks.checkIsAscii(traversedpath);
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("traversedpath");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.traversedpath = traversedpath;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Newprocess withVersionnumber(Long versionnumber) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_knowledgearticleid_value")
    @JsonIgnore
    public Optional<UUID> get_knowledgearticleid_value() {
        return Optional.ofNullable(_knowledgearticleid_value);
    }

    public Newprocess with_knowledgearticleid_value(UUID _knowledgearticleid_value) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("_knowledgearticleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x._knowledgearticleid_value = _knowledgearticleid_value;
        return _x;
    }

    @Property(name="_processid_value")
    @JsonIgnore
    public Optional<UUID> get_processid_value() {
        return Optional.ofNullable(_processid_value);
    }

    public Newprocess with_processid_value(UUID _processid_value) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("_processid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x._processid_value = _processid_value;
        return _x;
    }

    @Property(name="_activestageid_value")
    @JsonIgnore
    public Optional<UUID> get_activestageid_value() {
        return Optional.ofNullable(_activestageid_value);
    }

    public Newprocess with_activestageid_value(UUID _activestageid_value) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("_activestageid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x._activestageid_value = _activestageid_value;
        return _x;
    }

    @Property(name="businessprocessflowinstanceid")
    @JsonIgnore
    public Optional<UUID> getBusinessprocessflowinstanceid() {
        return Optional.ofNullable(businessprocessflowinstanceid);
    }

    public Newprocess withBusinessprocessflowinstanceid(UUID businessprocessflowinstanceid) {
        Newprocess _x = _copy();
        _x.changedFields = changedFields.add("businessprocessflowinstanceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.newprocess");
        _x.businessprocessflowinstanceid = businessprocessflowinstanceid;
        return _x;
    }

    public Newprocess withUnmappedField(String name, String value) {
        Newprocess _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdbyname")
    @JsonIgnore
    public SystemuserRequest getCreatedbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdbyname"), RequestHelper.getValue(unmappedFields, "createdbyname"));
    }

    @NavigationProperty(name="modifiedbyname")
    @JsonIgnore
    public SystemuserRequest getModifiedbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedbyname"), RequestHelper.getValue(unmappedFields, "modifiedbyname"));
    }

    @NavigationProperty(name="knowledgearticleid")
    @JsonIgnore
    public KnowledgearticleRequest getKnowledgearticleid() {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticleid"), RequestHelper.getValue(unmappedFields, "knowledgearticleid"));
    }

    @NavigationProperty(name="NewProcess_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getNewProcess_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("NewProcess_ProcessSessions"), RequestHelper.getValue(unmappedFields, "NewProcess_ProcessSessions"));
    }

    @NavigationProperty(name="activestageid")
    @JsonIgnore
    public ProcessstageRequest getActivestageid() {
        return new ProcessstageRequest(contextPath.addSegment("activestageid"), RequestHelper.getValue(unmappedFields, "activestageid"));
    }

    @NavigationProperty(name="createdonbehalfbyname")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfbyname"), RequestHelper.getValue(unmappedFields, "createdonbehalfbyname"));
    }

    @NavigationProperty(name="workflowlogs_newprocess")
    @JsonIgnore
    public WorkflowlogCollectionRequest getWorkflowlogs_newprocess() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("workflowlogs_newprocess"), RequestHelper.getValue(unmappedFields, "workflowlogs_newprocess"));
    }

    @NavigationProperty(name="processid")
    @JsonIgnore
    public WorkflowRequest getProcessid() {
        return new WorkflowRequest(contextPath.addSegment("processid"), RequestHelper.getValue(unmappedFields, "processid"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="modifiedonbehalfbyname")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfbyname"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfbyname"));
    }

    @NavigationProperty(name="NewProcess_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getNewProcess_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("NewProcess_SyncErrors"), RequestHelper.getValue(unmappedFields, "NewProcess_SyncErrors"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Newprocess patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Newprocess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Newprocess put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Newprocess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Newprocess _copy() {
        Newprocess _x = new Newprocess();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.statuscode = statuscode;
        _x.createdon = createdon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x._organizationid_value = _organizationid_value;
        _x.completedon = completedon;
        _x.statecode = statecode;
        _x._modifiedby_value = _modifiedby_value;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.activestagestartedon = activestagestartedon;
        _x.modifiedon = modifiedon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.duration = duration;
        _x.overriddencreatedon = overriddencreatedon;
        _x.exchangerate = exchangerate;
        _x.importsequencenumber = importsequencenumber;
        _x.name = name;
        _x.traversedpath = traversedpath;
        _x.versionnumber = versionnumber;
        _x._knowledgearticleid_value = _knowledgearticleid_value;
        _x._processid_value = _processid_value;
        _x._activestageid_value = _activestageid_value;
        _x.businessprocessflowinstanceid = businessprocessflowinstanceid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Newprocess[");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("completedon=");
        b.append(this.completedon);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("activestagestartedon=");
        b.append(this.activestagestartedon);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("traversedpath=");
        b.append(this.traversedpath);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_knowledgearticleid_value=");
        b.append(this._knowledgearticleid_value);
        b.append(", ");
        b.append("_processid_value=");
        b.append(this._processid_value);
        b.append(", ");
        b.append("_activestageid_value=");
        b.append(this._activestageid_value);
        b.append(", ");
        b.append("businessprocessflowinstanceid=");
        b.append(this.businessprocessflowinstanceid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
