package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlaitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "componentstate", 
    "_modifiedby_value", 
    "overriddencreatedon", 
    "componentidunique", 
    "createdon", 
    "msdyn_kpifield", 
    "utcconversiontimezonecode", 
    "msdyn_workflowinfo", 
    "msdyn_applicablefromfield", 
    "versionnumber", 
    "_ownerid_value", 
    "modifiedon", 
    "ismanaged", 
    "overwritetime", 
    "_createdonbehalfby_value", 
    "iscustomizable", 
    "msdyn_entitydisplayname", 
    "msdyn_name", 
    "msdyn_description", 
    "solutionid", 
    "timezoneruleversionnumber", 
    "msdyn_applicablefromdisplayname", 
    "statuscode", 
    "importsequencenumber", 
    "statecode", 
    "_owninguser_value", 
    "msdyn_slakpiid", 
    "_owningteam_value", 
    "_createdby_value", 
    "_modifiedonbehalfby_value", 
    "_owningbusinessunit_value", 
    "msdyn_entityname"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_slakpi extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_slakpi";
    }

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("componentidunique")
    protected UUID componentidunique;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("msdyn_kpifield")
    protected String msdyn_kpifield;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("msdyn_workflowinfo")
    protected String msdyn_workflowinfo;

    @JsonProperty("msdyn_applicablefromfield")
    protected String msdyn_applicablefromfield;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("msdyn_entitydisplayname")
    protected String msdyn_entitydisplayname;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("msdyn_description")
    protected String msdyn_description;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("msdyn_applicablefromdisplayname")
    protected String msdyn_applicablefromdisplayname;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("msdyn_slakpiid")
    protected UUID msdyn_slakpiid;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("msdyn_entityname")
    protected String msdyn_entityname;

    protected Msdyn_slakpi() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_slakpi() {
        return new Builder();
    }

    public static final class Builder {
        private Integer componentstate;
        private UUID _modifiedby_value;
        private OffsetDateTime overriddencreatedon;
        private UUID componentidunique;
        private OffsetDateTime createdon;
        private String msdyn_kpifield;
        private Integer utcconversiontimezonecode;
        private String msdyn_workflowinfo;
        private String msdyn_applicablefromfield;
        private Long versionnumber;
        private UUID _ownerid_value;
        private OffsetDateTime modifiedon;
        private Boolean ismanaged;
        private OffsetDateTime overwritetime;
        private UUID _createdonbehalfby_value;
        private BooleanManagedProperty iscustomizable;
        private String msdyn_entitydisplayname;
        private String msdyn_name;
        private String msdyn_description;
        private UUID solutionid;
        private Integer timezoneruleversionnumber;
        private String msdyn_applicablefromdisplayname;
        private Integer statuscode;
        private Integer importsequencenumber;
        private Integer statecode;
        private UUID _owninguser_value;
        private UUID msdyn_slakpiid;
        private UUID _owningteam_value;
        private UUID _createdby_value;
        private UUID _modifiedonbehalfby_value;
        private UUID _owningbusinessunit_value;
        private String msdyn_entityname;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder componentidunique(UUID componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder msdyn_kpifield(String msdyn_kpifield) {
            this.msdyn_kpifield = msdyn_kpifield;
            this.changedFields = changedFields.add("msdyn_kpifield");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder msdyn_workflowinfo(String msdyn_workflowinfo) {
            this.msdyn_workflowinfo = msdyn_workflowinfo;
            this.changedFields = changedFields.add("msdyn_workflowinfo");
            return this;
        }

        public Builder msdyn_applicablefromfield(String msdyn_applicablefromfield) {
            this.msdyn_applicablefromfield = msdyn_applicablefromfield;
            this.changedFields = changedFields.add("msdyn_applicablefromfield");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder msdyn_entitydisplayname(String msdyn_entitydisplayname) {
            this.msdyn_entitydisplayname = msdyn_entitydisplayname;
            this.changedFields = changedFields.add("msdyn_entitydisplayname");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder msdyn_description(String msdyn_description) {
            this.msdyn_description = msdyn_description;
            this.changedFields = changedFields.add("msdyn_description");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder msdyn_applicablefromdisplayname(String msdyn_applicablefromdisplayname) {
            this.msdyn_applicablefromdisplayname = msdyn_applicablefromdisplayname;
            this.changedFields = changedFields.add("msdyn_applicablefromdisplayname");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder msdyn_slakpiid(UUID msdyn_slakpiid) {
            this.msdyn_slakpiid = msdyn_slakpiid;
            this.changedFields = changedFields.add("msdyn_slakpiid");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder msdyn_entityname(String msdyn_entityname) {
            this.msdyn_entityname = msdyn_entityname;
            this.changedFields = changedFields.add("msdyn_entityname");
            return this;
        }

        public Msdyn_slakpi build() {
            Msdyn_slakpi _x = new Msdyn_slakpi();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_slakpi";
            _x.componentstate = componentstate;
            _x._modifiedby_value = _modifiedby_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.componentidunique = componentidunique;
            _x.createdon = createdon;
            _x.msdyn_kpifield = msdyn_kpifield;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.msdyn_workflowinfo = msdyn_workflowinfo;
            _x.msdyn_applicablefromfield = msdyn_applicablefromfield;
            _x.versionnumber = versionnumber;
            _x._ownerid_value = _ownerid_value;
            _x.modifiedon = modifiedon;
            _x.ismanaged = ismanaged;
            _x.overwritetime = overwritetime;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.iscustomizable = iscustomizable;
            _x.msdyn_entitydisplayname = msdyn_entitydisplayname;
            _x.msdyn_name = msdyn_name;
            _x.msdyn_description = msdyn_description;
            _x.solutionid = solutionid;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.msdyn_applicablefromdisplayname = msdyn_applicablefromdisplayname;
            _x.statuscode = statuscode;
            _x.importsequencenumber = importsequencenumber;
            _x.statecode = statecode;
            _x._owninguser_value = _owninguser_value;
            _x.msdyn_slakpiid = msdyn_slakpiid;
            _x._owningteam_value = _owningteam_value;
            _x._createdby_value = _createdby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.msdyn_entityname = msdyn_entityname;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_slakpiid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_slakpiid, UUID.class));
        }
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Msdyn_slakpi withComponentstate(Integer componentstate) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_slakpi with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_slakpi withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<UUID> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Msdyn_slakpi withComponentidunique(UUID componentidunique) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_slakpi withCreatedon(OffsetDateTime createdon) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="msdyn_kpifield")
    @JsonIgnore
    public Optional<String> getMsdyn_kpifield() {
        return Optional.ofNullable(msdyn_kpifield);
    }

    public Msdyn_slakpi withMsdyn_kpifield(String msdyn_kpifield) {
        Checks.checkIsAscii(msdyn_kpifield);
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("msdyn_kpifield");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.msdyn_kpifield = msdyn_kpifield;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_slakpi withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="msdyn_workflowinfo")
    @JsonIgnore
    public Optional<String> getMsdyn_workflowinfo() {
        return Optional.ofNullable(msdyn_workflowinfo);
    }

    public Msdyn_slakpi withMsdyn_workflowinfo(String msdyn_workflowinfo) {
        Checks.checkIsAscii(msdyn_workflowinfo);
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("msdyn_workflowinfo");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.msdyn_workflowinfo = msdyn_workflowinfo;
        return _x;
    }

    @Property(name="msdyn_applicablefromfield")
    @JsonIgnore
    public Optional<String> getMsdyn_applicablefromfield() {
        return Optional.ofNullable(msdyn_applicablefromfield);
    }

    public Msdyn_slakpi withMsdyn_applicablefromfield(String msdyn_applicablefromfield) {
        Checks.checkIsAscii(msdyn_applicablefromfield);
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("msdyn_applicablefromfield");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.msdyn_applicablefromfield = msdyn_applicablefromfield;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_slakpi withVersionnumber(Long versionnumber) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_slakpi with_ownerid_value(UUID _ownerid_value) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_slakpi withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Msdyn_slakpi withIsmanaged(Boolean ismanaged) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Msdyn_slakpi withOverwritetime(OffsetDateTime overwritetime) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_slakpi with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Msdyn_slakpi withIscustomizable(BooleanManagedProperty iscustomizable) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="msdyn_entitydisplayname")
    @JsonIgnore
    public Optional<String> getMsdyn_entitydisplayname() {
        return Optional.ofNullable(msdyn_entitydisplayname);
    }

    public Msdyn_slakpi withMsdyn_entitydisplayname(String msdyn_entitydisplayname) {
        Checks.checkIsAscii(msdyn_entitydisplayname);
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("msdyn_entitydisplayname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.msdyn_entitydisplayname = msdyn_entitydisplayname;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_slakpi withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="msdyn_description")
    @JsonIgnore
    public Optional<String> getMsdyn_description() {
        return Optional.ofNullable(msdyn_description);
    }

    public Msdyn_slakpi withMsdyn_description(String msdyn_description) {
        Checks.checkIsAscii(msdyn_description);
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("msdyn_description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.msdyn_description = msdyn_description;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Msdyn_slakpi withSolutionid(UUID solutionid) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_slakpi withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="msdyn_applicablefromdisplayname")
    @JsonIgnore
    public Optional<String> getMsdyn_applicablefromdisplayname() {
        return Optional.ofNullable(msdyn_applicablefromdisplayname);
    }

    public Msdyn_slakpi withMsdyn_applicablefromdisplayname(String msdyn_applicablefromdisplayname) {
        Checks.checkIsAscii(msdyn_applicablefromdisplayname);
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("msdyn_applicablefromdisplayname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.msdyn_applicablefromdisplayname = msdyn_applicablefromdisplayname;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_slakpi withStatuscode(Integer statuscode) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_slakpi withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_slakpi withStatecode(Integer statecode) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_slakpi with_owninguser_value(UUID _owninguser_value) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="msdyn_slakpiid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_slakpiid() {
        return Optional.ofNullable(msdyn_slakpiid);
    }

    public Msdyn_slakpi withMsdyn_slakpiid(UUID msdyn_slakpiid) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("msdyn_slakpiid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.msdyn_slakpiid = msdyn_slakpiid;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_slakpi with_owningteam_value(UUID _owningteam_value) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_slakpi with_createdby_value(UUID _createdby_value) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_slakpi with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_slakpi with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="msdyn_entityname")
    @JsonIgnore
    public Optional<String> getMsdyn_entityname() {
        return Optional.ofNullable(msdyn_entityname);
    }

    public Msdyn_slakpi withMsdyn_entityname(String msdyn_entityname) {
        Checks.checkIsAscii(msdyn_entityname);
        Msdyn_slakpi _x = _copy();
        _x.changedFields = changedFields.add("msdyn_entityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_slakpi");
        _x.msdyn_entityname = msdyn_entityname;
        return _x;
    }

    public Msdyn_slakpi withUnmappedField(String name, String value) {
        Msdyn_slakpi _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_slakpi_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_slakpi_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_slakpi_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_slakpi_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_slakpi_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_slakpi_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_slakpi_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_slakpi_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_slakpi_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_slakpi_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_slakpi_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_slakpi_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_slakpi_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_slakpi_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_slakpi_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_slakpi_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_slakpi_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_slakpi_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_slakpi_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_slakpi_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_slakpi_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_slakpi_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_slakpi_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_slakpi_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_slakpi_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_slakpi_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_slakpi_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_slakpi_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_slakpi_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_slakpi_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_slakpi_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_slakpi_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_msdyn_slakpi_slaitem")
    @JsonIgnore
    public SlaitemCollectionRequest getMsdyn_msdyn_slakpi_slaitem() {
        return new SlaitemCollectionRequest(
                        contextPath.addSegment("msdyn_msdyn_slakpi_slaitem"), RequestHelper.getValue(unmappedFields, "msdyn_msdyn_slakpi_slaitem"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_slakpi patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_slakpi _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_slakpi put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_slakpi _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_slakpi _copy() {
        Msdyn_slakpi _x = new Msdyn_slakpi();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentstate = componentstate;
        _x._modifiedby_value = _modifiedby_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.componentidunique = componentidunique;
        _x.createdon = createdon;
        _x.msdyn_kpifield = msdyn_kpifield;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.msdyn_workflowinfo = msdyn_workflowinfo;
        _x.msdyn_applicablefromfield = msdyn_applicablefromfield;
        _x.versionnumber = versionnumber;
        _x._ownerid_value = _ownerid_value;
        _x.modifiedon = modifiedon;
        _x.ismanaged = ismanaged;
        _x.overwritetime = overwritetime;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.iscustomizable = iscustomizable;
        _x.msdyn_entitydisplayname = msdyn_entitydisplayname;
        _x.msdyn_name = msdyn_name;
        _x.msdyn_description = msdyn_description;
        _x.solutionid = solutionid;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.msdyn_applicablefromdisplayname = msdyn_applicablefromdisplayname;
        _x.statuscode = statuscode;
        _x.importsequencenumber = importsequencenumber;
        _x.statecode = statecode;
        _x._owninguser_value = _owninguser_value;
        _x.msdyn_slakpiid = msdyn_slakpiid;
        _x._owningteam_value = _owningteam_value;
        _x._createdby_value = _createdby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.msdyn_entityname = msdyn_entityname;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_slakpi[");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("msdyn_kpifield=");
        b.append(this.msdyn_kpifield);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("msdyn_workflowinfo=");
        b.append(this.msdyn_workflowinfo);
        b.append(", ");
        b.append("msdyn_applicablefromfield=");
        b.append(this.msdyn_applicablefromfield);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("msdyn_entitydisplayname=");
        b.append(this.msdyn_entitydisplayname);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("msdyn_description=");
        b.append(this.msdyn_description);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("msdyn_applicablefromdisplayname=");
        b.append(this.msdyn_applicablefromdisplayname);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("msdyn_slakpiid=");
        b.append(this.msdyn_slakpiid);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("msdyn_entityname=");
        b.append(this.msdyn_entityname);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
