package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "versionnumber", 
    "_owningbusinessunit_value", 
    "_modifiedby_value", 
    "_msdyn_parentknowledgearticleid_value", 
    "overriddencreatedon", 
    "msdyn_blobfile_name", 
    "_createdby_value", 
    "_owninguser_value", 
    "_owningteam_value", 
    "modifiedon", 
    "msdyn_knowledgearticleimageid", 
    "_ownerid_value", 
    "_createdonbehalfby_value", 
    "statuscode", 
    "createdon", 
    "_modifiedonbehalfby_value", 
    "msdyn_blobfile", 
    "msdyn_filename", 
    "utcconversiontimezonecode", 
    "statecode", 
    "timezoneruleversionnumber", 
    "importsequencenumber"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_knowledgearticleimage extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage";
    }

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_msdyn_parentknowledgearticleid_value")
    protected UUID _msdyn_parentknowledgearticleid_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("msdyn_blobfile_name")
    protected String msdyn_blobfile_name;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("msdyn_knowledgearticleimageid")
    protected UUID msdyn_knowledgearticleimageid;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("msdyn_blobfile")
    protected byte[] msdyn_blobfile;

    @JsonProperty("msdyn_filename")
    protected String msdyn_filename;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    protected Msdyn_knowledgearticleimage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_knowledgearticleimage() {
        return new Builder();
    }

    public static final class Builder {
        private Long versionnumber;
        private UUID _owningbusinessunit_value;
        private UUID _modifiedby_value;
        private UUID _msdyn_parentknowledgearticleid_value;
        private OffsetDateTime overriddencreatedon;
        private String msdyn_blobfile_name;
        private UUID _createdby_value;
        private UUID _owninguser_value;
        private UUID _owningteam_value;
        private OffsetDateTime modifiedon;
        private UUID msdyn_knowledgearticleimageid;
        private UUID _ownerid_value;
        private UUID _createdonbehalfby_value;
        private Integer statuscode;
        private OffsetDateTime createdon;
        private UUID _modifiedonbehalfby_value;
        private byte[] msdyn_blobfile;
        private String msdyn_filename;
        private Integer utcconversiontimezonecode;
        private Integer statecode;
        private Integer timezoneruleversionnumber;
        private Integer importsequencenumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _msdyn_parentknowledgearticleid_value(UUID _msdyn_parentknowledgearticleid_value) {
            this._msdyn_parentknowledgearticleid_value = _msdyn_parentknowledgearticleid_value;
            this.changedFields = changedFields.add("_msdyn_parentknowledgearticleid_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder msdyn_blobfile_name(String msdyn_blobfile_name) {
            this.msdyn_blobfile_name = msdyn_blobfile_name;
            this.changedFields = changedFields.add("msdyn_blobfile_name");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder msdyn_knowledgearticleimageid(UUID msdyn_knowledgearticleimageid) {
            this.msdyn_knowledgearticleimageid = msdyn_knowledgearticleimageid;
            this.changedFields = changedFields.add("msdyn_knowledgearticleimageid");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder msdyn_blobfile(byte[] msdyn_blobfile) {
            this.msdyn_blobfile = msdyn_blobfile;
            this.changedFields = changedFields.add("msdyn_blobfile");
            return this;
        }

        public Builder msdyn_filename(String msdyn_filename) {
            this.msdyn_filename = msdyn_filename;
            this.changedFields = changedFields.add("msdyn_filename");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Msdyn_knowledgearticleimage build() {
            Msdyn_knowledgearticleimage _x = new Msdyn_knowledgearticleimage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage";
            _x.versionnumber = versionnumber;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._msdyn_parentknowledgearticleid_value = _msdyn_parentknowledgearticleid_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.msdyn_blobfile_name = msdyn_blobfile_name;
            _x._createdby_value = _createdby_value;
            _x._owninguser_value = _owninguser_value;
            _x._owningteam_value = _owningteam_value;
            _x.modifiedon = modifiedon;
            _x.msdyn_knowledgearticleimageid = msdyn_knowledgearticleimageid;
            _x._ownerid_value = _ownerid_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.statuscode = statuscode;
            _x.createdon = createdon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.msdyn_blobfile = msdyn_blobfile;
            _x.msdyn_filename = msdyn_filename;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.statecode = statecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.importsequencenumber = importsequencenumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_knowledgearticleimageid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_knowledgearticleimageid, UUID.class));
        }
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_knowledgearticleimage withVersionnumber(Long versionnumber) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_knowledgearticleimage with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_knowledgearticleimage with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_msdyn_parentknowledgearticleid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_parentknowledgearticleid_value() {
        return Optional.ofNullable(_msdyn_parentknowledgearticleid_value);
    }

    public Msdyn_knowledgearticleimage with_msdyn_parentknowledgearticleid_value(UUID _msdyn_parentknowledgearticleid_value) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_parentknowledgearticleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x._msdyn_parentknowledgearticleid_value = _msdyn_parentknowledgearticleid_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_knowledgearticleimage withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="msdyn_blobfile_name")
    @JsonIgnore
    public Optional<String> getMsdyn_blobfile_name() {
        return Optional.ofNullable(msdyn_blobfile_name);
    }

    public Msdyn_knowledgearticleimage withMsdyn_blobfile_name(String msdyn_blobfile_name) {
        Checks.checkIsAscii(msdyn_blobfile_name);
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_blobfile_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.msdyn_blobfile_name = msdyn_blobfile_name;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_knowledgearticleimage with_createdby_value(UUID _createdby_value) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_knowledgearticleimage with_owninguser_value(UUID _owninguser_value) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_knowledgearticleimage with_owningteam_value(UUID _owningteam_value) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_knowledgearticleimage withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="msdyn_knowledgearticleimageid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_knowledgearticleimageid() {
        return Optional.ofNullable(msdyn_knowledgearticleimageid);
    }

    public Msdyn_knowledgearticleimage withMsdyn_knowledgearticleimageid(UUID msdyn_knowledgearticleimageid) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_knowledgearticleimageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.msdyn_knowledgearticleimageid = msdyn_knowledgearticleimageid;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_knowledgearticleimage with_ownerid_value(UUID _ownerid_value) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_knowledgearticleimage with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_knowledgearticleimage withStatuscode(Integer statuscode) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_knowledgearticleimage withCreatedon(OffsetDateTime createdon) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_knowledgearticleimage with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_blobfile")
    @JsonIgnore
    public Optional<byte[]> getMsdyn_blobfile() {
        return Optional.ofNullable(msdyn_blobfile);
    }

    public Msdyn_knowledgearticleimage withMsdyn_blobfile(byte[] msdyn_blobfile) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_blobfile");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.msdyn_blobfile = msdyn_blobfile;
        return _x;
    }

    @Property(name="msdyn_filename")
    @JsonIgnore
    public Optional<String> getMsdyn_filename() {
        return Optional.ofNullable(msdyn_filename);
    }

    public Msdyn_knowledgearticleimage withMsdyn_filename(String msdyn_filename) {
        Checks.checkIsAscii(msdyn_filename);
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_filename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.msdyn_filename = msdyn_filename;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_knowledgearticleimage withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_knowledgearticleimage withStatecode(Integer statecode) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_knowledgearticleimage withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_knowledgearticleimage withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticleimage");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    public Msdyn_knowledgearticleimage withUnmappedField(String name, String value) {
        Msdyn_knowledgearticleimage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_knowledgearticleimage_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_knowledgearticleimage_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticleimage_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticleimage_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_knowledgearticleimage_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_knowledgearticleimage_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticleimage_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticleimage_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_knowledgearticleimage_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_knowledgearticleimage_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticleimage_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticleimage_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_knowledgearticleimage_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_knowledgearticleimage_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticleimage_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticleimage_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_knowledgearticleimage_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_knowledgearticleimage_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticleimage_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticleimage_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_knowledgearticleimage_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_knowledgearticleimage_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticleimage_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticleimage_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_knowledgearticleimage_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_knowledgearticleimage_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticleimage_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticleimage_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_knowledgearticleimage_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_knowledgearticleimage_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticleimage_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticleimage_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_knowledgearticleimage_FileAttachments")
    @JsonIgnore
    public FileattachmentCollectionRequest getMsdyn_knowledgearticleimage_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticleimage_FileAttachments"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticleimage_FileAttachments"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_knowledgearticleimage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_knowledgearticleimage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_knowledgearticleimage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_knowledgearticleimage _copy() {
        Msdyn_knowledgearticleimage _x = new Msdyn_knowledgearticleimage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.versionnumber = versionnumber;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._msdyn_parentknowledgearticleid_value = _msdyn_parentknowledgearticleid_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.msdyn_blobfile_name = msdyn_blobfile_name;
        _x._createdby_value = _createdby_value;
        _x._owninguser_value = _owninguser_value;
        _x._owningteam_value = _owningteam_value;
        _x.modifiedon = modifiedon;
        _x.msdyn_knowledgearticleimageid = msdyn_knowledgearticleimageid;
        _x._ownerid_value = _ownerid_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.statuscode = statuscode;
        _x.createdon = createdon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.msdyn_blobfile = msdyn_blobfile;
        _x.msdyn_filename = msdyn_filename;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.statecode = statecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_knowledgearticleimage[");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_msdyn_parentknowledgearticleid_value=");
        b.append(this._msdyn_parentknowledgearticleid_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("msdyn_blobfile_name=");
        b.append(this.msdyn_blobfile_name);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("msdyn_knowledgearticleimageid=");
        b.append(this.msdyn_knowledgearticleimageid);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("msdyn_blobfile=");
        b.append(this.msdyn_blobfile);
        b.append(", ");
        b.append("msdyn_filename=");
        b.append(this.msdyn_filename);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
