package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aimodelCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_templateversion", 
    "overriddencreatedon", 
    "msdyn_defaultrunschedulingoptions", 
    "importsequencenumber", 
    "msdyn_rundataspecification", 
    "msdyn_aitemplateidunique", 
    "msdyn_uxconfiguration", 
    "_owningbusinessunit_value", 
    "_createdby_value", 
    "_createdonbehalfby_value", 
    "_ownerid_value", 
    "_modifiedonbehalfby_value", 
    "timezoneruleversionnumber", 
    "msdyn_aitemplateid", 
    "introducedversion", 
    "msdyn_databinding", 
    "utcconversiontimezonecode", 
    "iscustomizable", 
    "solutionid", 
    "ismanaged", 
    "overwritetime", 
    "msdyn_trainingconfigschema", 
    "_owningteam_value", 
    "_owninguser_value", 
    "versionnumber", 
    "msdyn_resourceinfo", 
    "_modifiedby_value", 
    "modifiedon", 
    "statecode", 
    "msdyn_trainingdataspecification", 
    "msdyn_runconfigschema", 
    "componentstate", 
    "msdyn_istrainable", 
    "msdyn_uniquename", 
    "statuscode", 
    "createdon"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_aitemplate extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_aitemplate";
    }

    @JsonProperty("msdyn_templateversion")
    protected Integer msdyn_templateversion;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("msdyn_defaultrunschedulingoptions")
    protected String msdyn_defaultrunschedulingoptions;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("msdyn_rundataspecification")
    protected String msdyn_rundataspecification;

    @JsonProperty("msdyn_aitemplateidunique")
    protected UUID msdyn_aitemplateidunique;

    @JsonProperty("msdyn_uxconfiguration")
    protected String msdyn_uxconfiguration;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("msdyn_aitemplateid")
    protected UUID msdyn_aitemplateid;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("msdyn_databinding")
    protected String msdyn_databinding;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("msdyn_trainingconfigschema")
    protected String msdyn_trainingconfigschema;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("msdyn_resourceinfo")
    protected String msdyn_resourceinfo;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("msdyn_trainingdataspecification")
    protected String msdyn_trainingdataspecification;

    @JsonProperty("msdyn_runconfigschema")
    protected String msdyn_runconfigschema;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("msdyn_istrainable")
    protected Boolean msdyn_istrainable;

    @JsonProperty("msdyn_uniquename")
    protected String msdyn_uniquename;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    protected Msdyn_aitemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_aitemplate() {
        return new Builder();
    }

    public static final class Builder {
        private Integer msdyn_templateversion;
        private OffsetDateTime overriddencreatedon;
        private String msdyn_defaultrunschedulingoptions;
        private Integer importsequencenumber;
        private String msdyn_rundataspecification;
        private UUID msdyn_aitemplateidunique;
        private String msdyn_uxconfiguration;
        private UUID _owningbusinessunit_value;
        private UUID _createdby_value;
        private UUID _createdonbehalfby_value;
        private UUID _ownerid_value;
        private UUID _modifiedonbehalfby_value;
        private Integer timezoneruleversionnumber;
        private UUID msdyn_aitemplateid;
        private String introducedversion;
        private String msdyn_databinding;
        private Integer utcconversiontimezonecode;
        private BooleanManagedProperty iscustomizable;
        private UUID solutionid;
        private Boolean ismanaged;
        private OffsetDateTime overwritetime;
        private String msdyn_trainingconfigschema;
        private UUID _owningteam_value;
        private UUID _owninguser_value;
        private Long versionnumber;
        private String msdyn_resourceinfo;
        private UUID _modifiedby_value;
        private OffsetDateTime modifiedon;
        private Integer statecode;
        private String msdyn_trainingdataspecification;
        private String msdyn_runconfigschema;
        private Integer componentstate;
        private Boolean msdyn_istrainable;
        private String msdyn_uniquename;
        private Integer statuscode;
        private OffsetDateTime createdon;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_templateversion(Integer msdyn_templateversion) {
            this.msdyn_templateversion = msdyn_templateversion;
            this.changedFields = changedFields.add("msdyn_templateversion");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder msdyn_defaultrunschedulingoptions(String msdyn_defaultrunschedulingoptions) {
            this.msdyn_defaultrunschedulingoptions = msdyn_defaultrunschedulingoptions;
            this.changedFields = changedFields.add("msdyn_defaultrunschedulingoptions");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder msdyn_rundataspecification(String msdyn_rundataspecification) {
            this.msdyn_rundataspecification = msdyn_rundataspecification;
            this.changedFields = changedFields.add("msdyn_rundataspecification");
            return this;
        }

        public Builder msdyn_aitemplateidunique(UUID msdyn_aitemplateidunique) {
            this.msdyn_aitemplateidunique = msdyn_aitemplateidunique;
            this.changedFields = changedFields.add("msdyn_aitemplateidunique");
            return this;
        }

        public Builder msdyn_uxconfiguration(String msdyn_uxconfiguration) {
            this.msdyn_uxconfiguration = msdyn_uxconfiguration;
            this.changedFields = changedFields.add("msdyn_uxconfiguration");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder msdyn_aitemplateid(UUID msdyn_aitemplateid) {
            this.msdyn_aitemplateid = msdyn_aitemplateid;
            this.changedFields = changedFields.add("msdyn_aitemplateid");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder msdyn_databinding(String msdyn_databinding) {
            this.msdyn_databinding = msdyn_databinding;
            this.changedFields = changedFields.add("msdyn_databinding");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder msdyn_trainingconfigschema(String msdyn_trainingconfigschema) {
            this.msdyn_trainingconfigschema = msdyn_trainingconfigschema;
            this.changedFields = changedFields.add("msdyn_trainingconfigschema");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder msdyn_resourceinfo(String msdyn_resourceinfo) {
            this.msdyn_resourceinfo = msdyn_resourceinfo;
            this.changedFields = changedFields.add("msdyn_resourceinfo");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder msdyn_trainingdataspecification(String msdyn_trainingdataspecification) {
            this.msdyn_trainingdataspecification = msdyn_trainingdataspecification;
            this.changedFields = changedFields.add("msdyn_trainingdataspecification");
            return this;
        }

        public Builder msdyn_runconfigschema(String msdyn_runconfigschema) {
            this.msdyn_runconfigschema = msdyn_runconfigschema;
            this.changedFields = changedFields.add("msdyn_runconfigschema");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder msdyn_istrainable(Boolean msdyn_istrainable) {
            this.msdyn_istrainable = msdyn_istrainable;
            this.changedFields = changedFields.add("msdyn_istrainable");
            return this;
        }

        public Builder msdyn_uniquename(String msdyn_uniquename) {
            this.msdyn_uniquename = msdyn_uniquename;
            this.changedFields = changedFields.add("msdyn_uniquename");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Msdyn_aitemplate build() {
            Msdyn_aitemplate _x = new Msdyn_aitemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_aitemplate";
            _x.msdyn_templateversion = msdyn_templateversion;
            _x.overriddencreatedon = overriddencreatedon;
            _x.msdyn_defaultrunschedulingoptions = msdyn_defaultrunschedulingoptions;
            _x.importsequencenumber = importsequencenumber;
            _x.msdyn_rundataspecification = msdyn_rundataspecification;
            _x.msdyn_aitemplateidunique = msdyn_aitemplateidunique;
            _x.msdyn_uxconfiguration = msdyn_uxconfiguration;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._createdby_value = _createdby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._ownerid_value = _ownerid_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.msdyn_aitemplateid = msdyn_aitemplateid;
            _x.introducedversion = introducedversion;
            _x.msdyn_databinding = msdyn_databinding;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.iscustomizable = iscustomizable;
            _x.solutionid = solutionid;
            _x.ismanaged = ismanaged;
            _x.overwritetime = overwritetime;
            _x.msdyn_trainingconfigschema = msdyn_trainingconfigschema;
            _x._owningteam_value = _owningteam_value;
            _x._owninguser_value = _owninguser_value;
            _x.versionnumber = versionnumber;
            _x.msdyn_resourceinfo = msdyn_resourceinfo;
            _x._modifiedby_value = _modifiedby_value;
            _x.modifiedon = modifiedon;
            _x.statecode = statecode;
            _x.msdyn_trainingdataspecification = msdyn_trainingdataspecification;
            _x.msdyn_runconfigschema = msdyn_runconfigschema;
            _x.componentstate = componentstate;
            _x.msdyn_istrainable = msdyn_istrainable;
            _x.msdyn_uniquename = msdyn_uniquename;
            _x.statuscode = statuscode;
            _x.createdon = createdon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_aitemplateid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_aitemplateid, UUID.class));
        }
    }

    @Property(name="msdyn_templateversion")
    @JsonIgnore
    public Optional<Integer> getMsdyn_templateversion() {
        return Optional.ofNullable(msdyn_templateversion);
    }

    public Msdyn_aitemplate withMsdyn_templateversion(Integer msdyn_templateversion) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_templateversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_templateversion = msdyn_templateversion;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_aitemplate withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="msdyn_defaultrunschedulingoptions")
    @JsonIgnore
    public Optional<String> getMsdyn_defaultrunschedulingoptions() {
        return Optional.ofNullable(msdyn_defaultrunschedulingoptions);
    }

    public Msdyn_aitemplate withMsdyn_defaultrunschedulingoptions(String msdyn_defaultrunschedulingoptions) {
        Checks.checkIsAscii(msdyn_defaultrunschedulingoptions);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_defaultrunschedulingoptions");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_defaultrunschedulingoptions = msdyn_defaultrunschedulingoptions;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_aitemplate withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="msdyn_rundataspecification")
    @JsonIgnore
    public Optional<String> getMsdyn_rundataspecification() {
        return Optional.ofNullable(msdyn_rundataspecification);
    }

    public Msdyn_aitemplate withMsdyn_rundataspecification(String msdyn_rundataspecification) {
        Checks.checkIsAscii(msdyn_rundataspecification);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_rundataspecification");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_rundataspecification = msdyn_rundataspecification;
        return _x;
    }

    @Property(name="msdyn_aitemplateidunique")
    @JsonIgnore
    public Optional<UUID> getMsdyn_aitemplateidunique() {
        return Optional.ofNullable(msdyn_aitemplateidunique);
    }

    public Msdyn_aitemplate withMsdyn_aitemplateidunique(UUID msdyn_aitemplateidunique) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aitemplateidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_aitemplateidunique = msdyn_aitemplateidunique;
        return _x;
    }

    @Property(name="msdyn_uxconfiguration")
    @JsonIgnore
    public Optional<String> getMsdyn_uxconfiguration() {
        return Optional.ofNullable(msdyn_uxconfiguration);
    }

    public Msdyn_aitemplate withMsdyn_uxconfiguration(String msdyn_uxconfiguration) {
        Checks.checkIsAscii(msdyn_uxconfiguration);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_uxconfiguration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_uxconfiguration = msdyn_uxconfiguration;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_aitemplate with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_aitemplate with_createdby_value(UUID _createdby_value) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_aitemplate with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_aitemplate with_ownerid_value(UUID _ownerid_value) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_aitemplate with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_aitemplate withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="msdyn_aitemplateid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_aitemplateid() {
        return Optional.ofNullable(msdyn_aitemplateid);
    }

    public Msdyn_aitemplate withMsdyn_aitemplateid(UUID msdyn_aitemplateid) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aitemplateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_aitemplateid = msdyn_aitemplateid;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Msdyn_aitemplate withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="msdyn_databinding")
    @JsonIgnore
    public Optional<String> getMsdyn_databinding() {
        return Optional.ofNullable(msdyn_databinding);
    }

    public Msdyn_aitemplate withMsdyn_databinding(String msdyn_databinding) {
        Checks.checkIsAscii(msdyn_databinding);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_databinding");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_databinding = msdyn_databinding;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_aitemplate withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Msdyn_aitemplate withIscustomizable(BooleanManagedProperty iscustomizable) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Msdyn_aitemplate withSolutionid(UUID solutionid) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Msdyn_aitemplate withIsmanaged(Boolean ismanaged) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Msdyn_aitemplate withOverwritetime(OffsetDateTime overwritetime) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="msdyn_trainingconfigschema")
    @JsonIgnore
    public Optional<String> getMsdyn_trainingconfigschema() {
        return Optional.ofNullable(msdyn_trainingconfigschema);
    }

    public Msdyn_aitemplate withMsdyn_trainingconfigschema(String msdyn_trainingconfigschema) {
        Checks.checkIsAscii(msdyn_trainingconfigschema);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_trainingconfigschema");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_trainingconfigschema = msdyn_trainingconfigschema;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_aitemplate with_owningteam_value(UUID _owningteam_value) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_aitemplate with_owninguser_value(UUID _owninguser_value) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_aitemplate withVersionnumber(Long versionnumber) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="msdyn_resourceinfo")
    @JsonIgnore
    public Optional<String> getMsdyn_resourceinfo() {
        return Optional.ofNullable(msdyn_resourceinfo);
    }

    public Msdyn_aitemplate withMsdyn_resourceinfo(String msdyn_resourceinfo) {
        Checks.checkIsAscii(msdyn_resourceinfo);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_resourceinfo");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_resourceinfo = msdyn_resourceinfo;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_aitemplate with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_aitemplate withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_aitemplate withStatecode(Integer statecode) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="msdyn_trainingdataspecification")
    @JsonIgnore
    public Optional<String> getMsdyn_trainingdataspecification() {
        return Optional.ofNullable(msdyn_trainingdataspecification);
    }

    public Msdyn_aitemplate withMsdyn_trainingdataspecification(String msdyn_trainingdataspecification) {
        Checks.checkIsAscii(msdyn_trainingdataspecification);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_trainingdataspecification");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_trainingdataspecification = msdyn_trainingdataspecification;
        return _x;
    }

    @Property(name="msdyn_runconfigschema")
    @JsonIgnore
    public Optional<String> getMsdyn_runconfigschema() {
        return Optional.ofNullable(msdyn_runconfigschema);
    }

    public Msdyn_aitemplate withMsdyn_runconfigschema(String msdyn_runconfigschema) {
        Checks.checkIsAscii(msdyn_runconfigschema);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_runconfigschema");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_runconfigschema = msdyn_runconfigschema;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Msdyn_aitemplate withComponentstate(Integer componentstate) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="msdyn_istrainable")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_istrainable() {
        return Optional.ofNullable(msdyn_istrainable);
    }

    public Msdyn_aitemplate withMsdyn_istrainable(Boolean msdyn_istrainable) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_istrainable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_istrainable = msdyn_istrainable;
        return _x;
    }

    @Property(name="msdyn_uniquename")
    @JsonIgnore
    public Optional<String> getMsdyn_uniquename() {
        return Optional.ofNullable(msdyn_uniquename);
    }

    public Msdyn_aitemplate withMsdyn_uniquename(String msdyn_uniquename) {
        Checks.checkIsAscii(msdyn_uniquename);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_uniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.msdyn_uniquename = msdyn_uniquename;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_aitemplate withStatuscode(Integer statuscode) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_aitemplate withCreatedon(OffsetDateTime createdon) {
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aitemplate");
        _x.createdon = createdon;
        return _x;
    }

    public Msdyn_aitemplate withUnmappedField(String name, String value) {
        Msdyn_aitemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_aitemplate_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_aitemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aitemplate_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_aitemplate_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_aitemplate_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_aitemplate_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aitemplate_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_aitemplate_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_aitemplate_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_aitemplate_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aitemplate_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_aitemplate_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_aitemplate_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_aitemplate_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aitemplate_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_aitemplate_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_aitemplate_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_aitemplate_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aitemplate_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_aitemplate_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_aitemplate_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_aitemplate_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aitemplate_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_aitemplate_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_aitemplate_msdyn_aimodel")
    @JsonIgnore
    public Msdyn_aimodelCollectionRequest getMsdyn_aitemplate_msdyn_aimodel() {
        return new Msdyn_aimodelCollectionRequest(
                        contextPath.addSegment("msdyn_aitemplate_msdyn_aimodel"), RequestHelper.getValue(unmappedFields, "msdyn_aitemplate_msdyn_aimodel"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aitemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aitemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aitemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_aitemplate _copy() {
        Msdyn_aitemplate _x = new Msdyn_aitemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_templateversion = msdyn_templateversion;
        _x.overriddencreatedon = overriddencreatedon;
        _x.msdyn_defaultrunschedulingoptions = msdyn_defaultrunschedulingoptions;
        _x.importsequencenumber = importsequencenumber;
        _x.msdyn_rundataspecification = msdyn_rundataspecification;
        _x.msdyn_aitemplateidunique = msdyn_aitemplateidunique;
        _x.msdyn_uxconfiguration = msdyn_uxconfiguration;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._createdby_value = _createdby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._ownerid_value = _ownerid_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.msdyn_aitemplateid = msdyn_aitemplateid;
        _x.introducedversion = introducedversion;
        _x.msdyn_databinding = msdyn_databinding;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.iscustomizable = iscustomizable;
        _x.solutionid = solutionid;
        _x.ismanaged = ismanaged;
        _x.overwritetime = overwritetime;
        _x.msdyn_trainingconfigschema = msdyn_trainingconfigschema;
        _x._owningteam_value = _owningteam_value;
        _x._owninguser_value = _owninguser_value;
        _x.versionnumber = versionnumber;
        _x.msdyn_resourceinfo = msdyn_resourceinfo;
        _x._modifiedby_value = _modifiedby_value;
        _x.modifiedon = modifiedon;
        _x.statecode = statecode;
        _x.msdyn_trainingdataspecification = msdyn_trainingdataspecification;
        _x.msdyn_runconfigschema = msdyn_runconfigschema;
        _x.componentstate = componentstate;
        _x.msdyn_istrainable = msdyn_istrainable;
        _x.msdyn_uniquename = msdyn_uniquename;
        _x.statuscode = statuscode;
        _x.createdon = createdon;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_aitemplate[");
        b.append("msdyn_templateversion=");
        b.append(this.msdyn_templateversion);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("msdyn_defaultrunschedulingoptions=");
        b.append(this.msdyn_defaultrunschedulingoptions);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("msdyn_rundataspecification=");
        b.append(this.msdyn_rundataspecification);
        b.append(", ");
        b.append("msdyn_aitemplateidunique=");
        b.append(this.msdyn_aitemplateidunique);
        b.append(", ");
        b.append("msdyn_uxconfiguration=");
        b.append(this.msdyn_uxconfiguration);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("msdyn_aitemplateid=");
        b.append(this.msdyn_aitemplateid);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("msdyn_databinding=");
        b.append(this.msdyn_databinding);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("msdyn_trainingconfigschema=");
        b.append(this.msdyn_trainingconfigschema);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("msdyn_resourceinfo=");
        b.append(this.msdyn_resourceinfo);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("msdyn_trainingdataspecification=");
        b.append(this.msdyn_trainingdataspecification);
        b.append(", ");
        b.append("msdyn_runconfigschema=");
        b.append(this.msdyn_runconfigschema);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("msdyn_istrainable=");
        b.append(this.msdyn_istrainable);
        b.append(", ");
        b.append("msdyn_uniquename=");
        b.append(this.msdyn_uniquename);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
