package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.CustomcontrolresourceCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "ismanaged", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "_modifiedonbehalfby_value", 
    "compatibledatatypes", 
    "solutionid", 
    "_modifiedby_value", 
    "clientjson", 
    "customcontrolid", 
    "_organizationid_value", 
    "authoringmanifest", 
    "version", 
    "customcontrolidunique", 
    "componentstate", 
    "overwritetime", 
    "name", 
    "manifest", 
    "versionnumber", 
    "createdon", 
    "_createdby_value", 
    "introducedversion"})
@JsonInclude(Include.NON_NULL)
public class Customcontrol extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.customcontrol";
    }

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("compatibledatatypes")
    protected String compatibledatatypes;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("clientjson")
    protected String clientjson;

    @JsonProperty("customcontrolid")
    protected UUID customcontrolid;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("authoringmanifest")
    protected String authoringmanifest;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("customcontrolidunique")
    protected UUID customcontrolidunique;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("manifest")
    protected String manifest;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    protected Customcontrol() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCustomcontrol() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean ismanaged;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private UUID _modifiedonbehalfby_value;
        private String compatibledatatypes;
        private UUID solutionid;
        private UUID _modifiedby_value;
        private String clientjson;
        private UUID customcontrolid;
        private UUID _organizationid_value;
        private String authoringmanifest;
        private String version;
        private UUID customcontrolidunique;
        private Integer componentstate;
        private OffsetDateTime overwritetime;
        private String name;
        private String manifest;
        private Long versionnumber;
        private OffsetDateTime createdon;
        private UUID _createdby_value;
        private String introducedversion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder compatibledatatypes(String compatibledatatypes) {
            this.compatibledatatypes = compatibledatatypes;
            this.changedFields = changedFields.add("compatibledatatypes");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder clientjson(String clientjson) {
            this.clientjson = clientjson;
            this.changedFields = changedFields.add("clientjson");
            return this;
        }

        public Builder customcontrolid(UUID customcontrolid) {
            this.customcontrolid = customcontrolid;
            this.changedFields = changedFields.add("customcontrolid");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder authoringmanifest(String authoringmanifest) {
            this.authoringmanifest = authoringmanifest;
            this.changedFields = changedFields.add("authoringmanifest");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder customcontrolidunique(UUID customcontrolidunique) {
            this.customcontrolidunique = customcontrolidunique;
            this.changedFields = changedFields.add("customcontrolidunique");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder manifest(String manifest) {
            this.manifest = manifest;
            this.changedFields = changedFields.add("manifest");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Customcontrol build() {
            Customcontrol _x = new Customcontrol();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.customcontrol";
            _x.ismanaged = ismanaged;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.compatibledatatypes = compatibledatatypes;
            _x.solutionid = solutionid;
            _x._modifiedby_value = _modifiedby_value;
            _x.clientjson = clientjson;
            _x.customcontrolid = customcontrolid;
            _x._organizationid_value = _organizationid_value;
            _x.authoringmanifest = authoringmanifest;
            _x.version = version;
            _x.customcontrolidunique = customcontrolidunique;
            _x.componentstate = componentstate;
            _x.overwritetime = overwritetime;
            _x.name = name;
            _x.manifest = manifest;
            _x.versionnumber = versionnumber;
            _x.createdon = createdon;
            _x._createdby_value = _createdby_value;
            _x.introducedversion = introducedversion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && customcontrolid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(customcontrolid, UUID.class));
        }
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Customcontrol withIsmanaged(Boolean ismanaged) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Customcontrol with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Customcontrol withModifiedon(OffsetDateTime modifiedon) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Customcontrol with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="compatibledatatypes")
    @JsonIgnore
    public Optional<String> getCompatibledatatypes() {
        return Optional.ofNullable(compatibledatatypes);
    }

    public Customcontrol withCompatibledatatypes(String compatibledatatypes) {
        Checks.checkIsAscii(compatibledatatypes);
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("compatibledatatypes");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.compatibledatatypes = compatibledatatypes;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Customcontrol withSolutionid(UUID solutionid) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Customcontrol with_modifiedby_value(UUID _modifiedby_value) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="clientjson")
    @JsonIgnore
    public Optional<String> getClientjson() {
        return Optional.ofNullable(clientjson);
    }

    public Customcontrol withClientjson(String clientjson) {
        Checks.checkIsAscii(clientjson);
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("clientjson");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.clientjson = clientjson;
        return _x;
    }

    @Property(name="customcontrolid")
    @JsonIgnore
    public Optional<UUID> getCustomcontrolid() {
        return Optional.ofNullable(customcontrolid);
    }

    public Customcontrol withCustomcontrolid(UUID customcontrolid) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("customcontrolid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.customcontrolid = customcontrolid;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Customcontrol with_organizationid_value(UUID _organizationid_value) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="authoringmanifest")
    @JsonIgnore
    public Optional<String> getAuthoringmanifest() {
        return Optional.ofNullable(authoringmanifest);
    }

    public Customcontrol withAuthoringmanifest(String authoringmanifest) {
        Checks.checkIsAscii(authoringmanifest);
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("authoringmanifest");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.authoringmanifest = authoringmanifest;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public Customcontrol withVersion(String version) {
        Checks.checkIsAscii(version);
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.version = version;
        return _x;
    }

    @Property(name="customcontrolidunique")
    @JsonIgnore
    public Optional<UUID> getCustomcontrolidunique() {
        return Optional.ofNullable(customcontrolidunique);
    }

    public Customcontrol withCustomcontrolidunique(UUID customcontrolidunique) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("customcontrolidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.customcontrolidunique = customcontrolidunique;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Customcontrol withComponentstate(Integer componentstate) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Customcontrol withOverwritetime(OffsetDateTime overwritetime) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Customcontrol withName(String name) {
        Checks.checkIsAscii(name);
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.name = name;
        return _x;
    }

    @Property(name="manifest")
    @JsonIgnore
    public Optional<String> getManifest() {
        return Optional.ofNullable(manifest);
    }

    public Customcontrol withManifest(String manifest) {
        Checks.checkIsAscii(manifest);
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("manifest");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.manifest = manifest;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Customcontrol withVersionnumber(Long versionnumber) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Customcontrol withCreatedon(OffsetDateTime createdon) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Customcontrol with_createdby_value(UUID _createdby_value) {
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Customcontrol withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Customcontrol _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrol");
        _x.introducedversion = introducedversion;
        return _x;
    }

    public Customcontrol withUnmappedField(String name, String value) {
        Customcontrol _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="customcontrol_resource_id")
    @JsonIgnore
    public CustomcontrolresourceCollectionRequest getCustomcontrol_resource_id() {
        return new CustomcontrolresourceCollectionRequest(
                        contextPath.addSegment("customcontrol_resource_id"), RequestHelper.getValue(unmappedFields, "customcontrol_resource_id"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Customcontrol patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Customcontrol _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Customcontrol put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Customcontrol _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Customcontrol _copy() {
        Customcontrol _x = new Customcontrol();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ismanaged = ismanaged;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.compatibledatatypes = compatibledatatypes;
        _x.solutionid = solutionid;
        _x._modifiedby_value = _modifiedby_value;
        _x.clientjson = clientjson;
        _x.customcontrolid = customcontrolid;
        _x._organizationid_value = _organizationid_value;
        _x.authoringmanifest = authoringmanifest;
        _x.version = version;
        _x.customcontrolidunique = customcontrolidunique;
        _x.componentstate = componentstate;
        _x.overwritetime = overwritetime;
        _x.name = name;
        _x.manifest = manifest;
        _x.versionnumber = versionnumber;
        _x.createdon = createdon;
        _x._createdby_value = _createdby_value;
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Customcontrol[");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("compatibledatatypes=");
        b.append(this.compatibledatatypes);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("clientjson=");
        b.append(this.clientjson);
        b.append(", ");
        b.append("customcontrolid=");
        b.append(this.customcontrolid);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("authoringmanifest=");
        b.append(this.authoringmanifest);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("customcontrolidunique=");
        b.append(this.customcontrolidunique);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("manifest=");
        b.append(this.manifest);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
