package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.ConnectionroleRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PositionRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SocialprofileRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TerritoryRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "record1objecttypecode", 
    "_transactioncurrencyid_value", 
    "statecode", 
    "_record1roleid_value", 
    "effectiveend", 
    "entityimage_url", 
    "name", 
    "connectionid", 
    "exchangerate", 
    "_owningteam_value", 
    "_createdby_value", 
    "_modifiedby_value", 
    "record2objecttypecode", 
    "_ownerid_value", 
    "_owninguser_value", 
    "_record1id_value", 
    "effectivestart", 
    "_relatedconnectionid_value", 
    "modifiedon", 
    "description", 
    "versionnumber", 
    "entityimageid", 
    "entityimage_timestamp", 
    "_createdonbehalfby_value", 
    "overriddencreatedon", 
    "_modifiedonbehalfby_value", 
    "statuscode", 
    "importsequencenumber", 
    "_owningbusinessunit_value", 
    "ismaster", 
    "_record2id_value", 
    "_record2roleid_value", 
    "createdon", 
    "entityimage"})
@JsonInclude(Include.NON_NULL)
public class Connection extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.connection";
    }

    @JsonProperty("record1objecttypecode")
    protected Integer record1objecttypecode;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_record1roleid_value")
    protected UUID _record1roleid_value;

    @JsonProperty("effectiveend")
    protected OffsetDateTime effectiveend;

    @JsonProperty("entityimage_url")
    protected String entityimage_url;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("connectionid")
    protected UUID connectionid;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("record2objecttypecode")
    protected Integer record2objecttypecode;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("_record1id_value")
    protected UUID _record1id_value;

    @JsonProperty("effectivestart")
    protected OffsetDateTime effectivestart;

    @JsonProperty("_relatedconnectionid_value")
    protected UUID _relatedconnectionid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("entityimageid")
    protected UUID entityimageid;

    @JsonProperty("entityimage_timestamp")
    protected Long entityimage_timestamp;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("ismaster")
    protected Boolean ismaster;

    @JsonProperty("_record2id_value")
    protected UUID _record2id_value;

    @JsonProperty("_record2roleid_value")
    protected UUID _record2roleid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("entityimage")
    protected byte[] entityimage;

    protected Connection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConnection() {
        return new Builder();
    }

    public static final class Builder {
        private Integer record1objecttypecode;
        private UUID _transactioncurrencyid_value;
        private Integer statecode;
        private UUID _record1roleid_value;
        private OffsetDateTime effectiveend;
        private String entityimage_url;
        private String name;
        private UUID connectionid;
        private BigDecimal exchangerate;
        private UUID _owningteam_value;
        private UUID _createdby_value;
        private UUID _modifiedby_value;
        private Integer record2objecttypecode;
        private UUID _ownerid_value;
        private UUID _owninguser_value;
        private UUID _record1id_value;
        private OffsetDateTime effectivestart;
        private UUID _relatedconnectionid_value;
        private OffsetDateTime modifiedon;
        private String description;
        private Long versionnumber;
        private UUID entityimageid;
        private Long entityimage_timestamp;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime overriddencreatedon;
        private UUID _modifiedonbehalfby_value;
        private Integer statuscode;
        private Integer importsequencenumber;
        private UUID _owningbusinessunit_value;
        private Boolean ismaster;
        private UUID _record2id_value;
        private UUID _record2roleid_value;
        private OffsetDateTime createdon;
        private byte[] entityimage;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder record1objecttypecode(Integer record1objecttypecode) {
            this.record1objecttypecode = record1objecttypecode;
            this.changedFields = changedFields.add("record1objecttypecode");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _record1roleid_value(UUID _record1roleid_value) {
            this._record1roleid_value = _record1roleid_value;
            this.changedFields = changedFields.add("_record1roleid_value");
            return this;
        }

        public Builder effectiveend(OffsetDateTime effectiveend) {
            this.effectiveend = effectiveend;
            this.changedFields = changedFields.add("effectiveend");
            return this;
        }

        public Builder entityimage_url(String entityimage_url) {
            this.entityimage_url = entityimage_url;
            this.changedFields = changedFields.add("entityimage_url");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder connectionid(UUID connectionid) {
            this.connectionid = connectionid;
            this.changedFields = changedFields.add("connectionid");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder record2objecttypecode(Integer record2objecttypecode) {
            this.record2objecttypecode = record2objecttypecode;
            this.changedFields = changedFields.add("record2objecttypecode");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _record1id_value(UUID _record1id_value) {
            this._record1id_value = _record1id_value;
            this.changedFields = changedFields.add("_record1id_value");
            return this;
        }

        public Builder effectivestart(OffsetDateTime effectivestart) {
            this.effectivestart = effectivestart;
            this.changedFields = changedFields.add("effectivestart");
            return this;
        }

        public Builder _relatedconnectionid_value(UUID _relatedconnectionid_value) {
            this._relatedconnectionid_value = _relatedconnectionid_value;
            this.changedFields = changedFields.add("_relatedconnectionid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder entityimageid(UUID entityimageid) {
            this.entityimageid = entityimageid;
            this.changedFields = changedFields.add("entityimageid");
            return this;
        }

        public Builder entityimage_timestamp(Long entityimage_timestamp) {
            this.entityimage_timestamp = entityimage_timestamp;
            this.changedFields = changedFields.add("entityimage_timestamp");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder ismaster(Boolean ismaster) {
            this.ismaster = ismaster;
            this.changedFields = changedFields.add("ismaster");
            return this;
        }

        public Builder _record2id_value(UUID _record2id_value) {
            this._record2id_value = _record2id_value;
            this.changedFields = changedFields.add("_record2id_value");
            return this;
        }

        public Builder _record2roleid_value(UUID _record2roleid_value) {
            this._record2roleid_value = _record2roleid_value;
            this.changedFields = changedFields.add("_record2roleid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder entityimage(byte[] entityimage) {
            this.entityimage = entityimage;
            this.changedFields = changedFields.add("entityimage");
            return this;
        }

        public Connection build() {
            Connection _x = new Connection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.connection";
            _x.record1objecttypecode = record1objecttypecode;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.statecode = statecode;
            _x._record1roleid_value = _record1roleid_value;
            _x.effectiveend = effectiveend;
            _x.entityimage_url = entityimage_url;
            _x.name = name;
            _x.connectionid = connectionid;
            _x.exchangerate = exchangerate;
            _x._owningteam_value = _owningteam_value;
            _x._createdby_value = _createdby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.record2objecttypecode = record2objecttypecode;
            _x._ownerid_value = _ownerid_value;
            _x._owninguser_value = _owninguser_value;
            _x._record1id_value = _record1id_value;
            _x.effectivestart = effectivestart;
            _x._relatedconnectionid_value = _relatedconnectionid_value;
            _x.modifiedon = modifiedon;
            _x.description = description;
            _x.versionnumber = versionnumber;
            _x.entityimageid = entityimageid;
            _x.entityimage_timestamp = entityimage_timestamp;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.statuscode = statuscode;
            _x.importsequencenumber = importsequencenumber;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.ismaster = ismaster;
            _x._record2id_value = _record2id_value;
            _x._record2roleid_value = _record2roleid_value;
            _x.createdon = createdon;
            _x.entityimage = entityimage;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && connectionid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(connectionid, UUID.class));
        }
    }

    @Property(name="record1objecttypecode")
    @JsonIgnore
    public Optional<Integer> getRecord1objecttypecode() {
        return Optional.ofNullable(record1objecttypecode);
    }

    public Connection withRecord1objecttypecode(Integer record1objecttypecode) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("record1objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.record1objecttypecode = record1objecttypecode;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Connection with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Connection withStatecode(Integer statecode) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_record1roleid_value")
    @JsonIgnore
    public Optional<UUID> get_record1roleid_value() {
        return Optional.ofNullable(_record1roleid_value);
    }

    public Connection with_record1roleid_value(UUID _record1roleid_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_record1roleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._record1roleid_value = _record1roleid_value;
        return _x;
    }

    @Property(name="effectiveend")
    @JsonIgnore
    public Optional<OffsetDateTime> getEffectiveend() {
        return Optional.ofNullable(effectiveend);
    }

    public Connection withEffectiveend(OffsetDateTime effectiveend) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("effectiveend");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.effectiveend = effectiveend;
        return _x;
    }

    @Property(name="entityimage_url")
    @JsonIgnore
    public Optional<String> getEntityimage_url() {
        return Optional.ofNullable(entityimage_url);
    }

    public Connection withEntityimage_url(String entityimage_url) {
        Checks.checkIsAscii(entityimage_url);
        Connection _x = _copy();
        _x.changedFields = changedFields.add("entityimage_url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.entityimage_url = entityimage_url;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Connection withName(String name) {
        Checks.checkIsAscii(name);
        Connection _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.name = name;
        return _x;
    }

    @Property(name="connectionid")
    @JsonIgnore
    public Optional<UUID> getConnectionid() {
        return Optional.ofNullable(connectionid);
    }

    public Connection withConnectionid(UUID connectionid) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("connectionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.connectionid = connectionid;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Connection withExchangerate(BigDecimal exchangerate) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Connection with_owningteam_value(UUID _owningteam_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Connection with_createdby_value(UUID _createdby_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Connection with_modifiedby_value(UUID _modifiedby_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="record2objecttypecode")
    @JsonIgnore
    public Optional<Integer> getRecord2objecttypecode() {
        return Optional.ofNullable(record2objecttypecode);
    }

    public Connection withRecord2objecttypecode(Integer record2objecttypecode) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("record2objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.record2objecttypecode = record2objecttypecode;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Connection with_ownerid_value(UUID _ownerid_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Connection with_owninguser_value(UUID _owninguser_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_record1id_value")
    @JsonIgnore
    public Optional<UUID> get_record1id_value() {
        return Optional.ofNullable(_record1id_value);
    }

    public Connection with_record1id_value(UUID _record1id_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_record1id_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._record1id_value = _record1id_value;
        return _x;
    }

    @Property(name="effectivestart")
    @JsonIgnore
    public Optional<OffsetDateTime> getEffectivestart() {
        return Optional.ofNullable(effectivestart);
    }

    public Connection withEffectivestart(OffsetDateTime effectivestart) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("effectivestart");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.effectivestart = effectivestart;
        return _x;
    }

    @Property(name="_relatedconnectionid_value")
    @JsonIgnore
    public Optional<UUID> get_relatedconnectionid_value() {
        return Optional.ofNullable(_relatedconnectionid_value);
    }

    public Connection with_relatedconnectionid_value(UUID _relatedconnectionid_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_relatedconnectionid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._relatedconnectionid_value = _relatedconnectionid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Connection withModifiedon(OffsetDateTime modifiedon) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Connection withDescription(String description) {
        Checks.checkIsAscii(description);
        Connection _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.description = description;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Connection withVersionnumber(Long versionnumber) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="entityimageid")
    @JsonIgnore
    public Optional<UUID> getEntityimageid() {
        return Optional.ofNullable(entityimageid);
    }

    public Connection withEntityimageid(UUID entityimageid) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("entityimageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.entityimageid = entityimageid;
        return _x;
    }

    @Property(name="entityimage_timestamp")
    @JsonIgnore
    public Optional<Long> getEntityimage_timestamp() {
        return Optional.ofNullable(entityimage_timestamp);
    }

    public Connection withEntityimage_timestamp(Long entityimage_timestamp) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("entityimage_timestamp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.entityimage_timestamp = entityimage_timestamp;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Connection with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Connection withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Connection with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Connection withStatuscode(Integer statuscode) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Connection withImportsequencenumber(Integer importsequencenumber) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Connection with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="ismaster")
    @JsonIgnore
    public Optional<Boolean> getIsmaster() {
        return Optional.ofNullable(ismaster);
    }

    public Connection withIsmaster(Boolean ismaster) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("ismaster");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.ismaster = ismaster;
        return _x;
    }

    @Property(name="_record2id_value")
    @JsonIgnore
    public Optional<UUID> get_record2id_value() {
        return Optional.ofNullable(_record2id_value);
    }

    public Connection with_record2id_value(UUID _record2id_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_record2id_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._record2id_value = _record2id_value;
        return _x;
    }

    @Property(name="_record2roleid_value")
    @JsonIgnore
    public Optional<UUID> get_record2roleid_value() {
        return Optional.ofNullable(_record2roleid_value);
    }

    public Connection with_record2roleid_value(UUID _record2roleid_value) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("_record2roleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x._record2roleid_value = _record2roleid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Connection withCreatedon(OffsetDateTime createdon) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="entityimage")
    @JsonIgnore
    public Optional<byte[]> getEntityimage() {
        return Optional.ofNullable(entityimage);
    }

    public Connection withEntityimage(byte[] entityimage) {
        Connection _x = _copy();
        _x.changedFields = changedFields.add("entityimage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connection");
        _x.entityimage = entityimage;
        return _x;
    }

    public Connection withUnmappedField(String name, String value) {
        Connection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="record1id_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getRecord1id_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("record1id_knowledgearticle"), RequestHelper.getValue(unmappedFields, "record1id_knowledgearticle"));
    }

    @NavigationProperty(name="record2id_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getRecord2id_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("record2id_knowledgearticle"), RequestHelper.getValue(unmappedFields, "record2id_knowledgearticle"));
    }

    @NavigationProperty(name="record1id_knowledgebaserecord")
    @JsonIgnore
    public KnowledgebaserecordRequest getRecord1id_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("record1id_knowledgebaserecord"), RequestHelper.getValue(unmappedFields, "record1id_knowledgebaserecord"));
    }

    @NavigationProperty(name="record2id_knowledgebaserecord")
    @JsonIgnore
    public KnowledgebaserecordRequest getRecord2id_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("record2id_knowledgebaserecord"), RequestHelper.getValue(unmappedFields, "record2id_knowledgebaserecord"));
    }

    @NavigationProperty(name="record1id_contact")
    @JsonIgnore
    public ContactRequest getRecord1id_contact() {
        return new ContactRequest(contextPath.addSegment("record1id_contact"), RequestHelper.getValue(unmappedFields, "record1id_contact"));
    }

    @NavigationProperty(name="record2id_socialactivity")
    @JsonIgnore
    public SocialactivityRequest getRecord2id_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("record2id_socialactivity"), RequestHelper.getValue(unmappedFields, "record2id_socialactivity"));
    }

    @NavigationProperty(name="record2id_task")
    @JsonIgnore
    public TaskRequest getRecord2id_task() {
        return new TaskRequest(contextPath.addSegment("record2id_task"), RequestHelper.getValue(unmappedFields, "record2id_task"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="record1id_systemuser")
    @JsonIgnore
    public SystemuserRequest getRecord1id_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("record1id_systemuser"), RequestHelper.getValue(unmappedFields, "record1id_systemuser"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="record2id_account")
    @JsonIgnore
    public AccountRequest getRecord2id_account() {
        return new AccountRequest(contextPath.addSegment("record2id_account"), RequestHelper.getValue(unmappedFields, "record2id_account"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="record2id_systemuser")
    @JsonIgnore
    public SystemuserRequest getRecord2id_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("record2id_systemuser"), RequestHelper.getValue(unmappedFields, "record2id_systemuser"));
    }

    @NavigationProperty(name="record2id_team")
    @JsonIgnore
    public TeamRequest getRecord2id_team() {
        return new TeamRequest(contextPath.addSegment("record2id_team"), RequestHelper.getValue(unmappedFields, "record2id_team"));
    }

    @NavigationProperty(name="record2id_letter")
    @JsonIgnore
    public LetterRequest getRecord2id_letter() {
        return new LetterRequest(contextPath.addSegment("record2id_letter"), RequestHelper.getValue(unmappedFields, "record2id_letter"));
    }

    @NavigationProperty(name="record1id_email")
    @JsonIgnore
    public EmailRequest getRecord1id_email() {
        return new EmailRequest(contextPath.addSegment("record1id_email"), RequestHelper.getValue(unmappedFields, "record1id_email"));
    }

    @NavigationProperty(name="record1id_socialprofile")
    @JsonIgnore
    public SocialprofileRequest getRecord1id_socialprofile() {
        return new SocialprofileRequest(contextPath.addSegment("record1id_socialprofile"), RequestHelper.getValue(unmappedFields, "record1id_socialprofile"));
    }

    @NavigationProperty(name="connection_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getConnection_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("connection_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "connection_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="record1id_task")
    @JsonIgnore
    public TaskRequest getRecord1id_task() {
        return new TaskRequest(contextPath.addSegment("record1id_task"), RequestHelper.getValue(unmappedFields, "record1id_task"));
    }

    @NavigationProperty(name="record2id_email")
    @JsonIgnore
    public EmailRequest getRecord2id_email() {
        return new EmailRequest(contextPath.addSegment("record2id_email"), RequestHelper.getValue(unmappedFields, "record2id_email"));
    }

    @NavigationProperty(name="record2id_socialprofile")
    @JsonIgnore
    public SocialprofileRequest getRecord2id_socialprofile() {
        return new SocialprofileRequest(contextPath.addSegment("record2id_socialprofile"), RequestHelper.getValue(unmappedFields, "record2id_socialprofile"));
    }

    @NavigationProperty(name="record1id_team")
    @JsonIgnore
    public TeamRequest getRecord1id_team() {
        return new TeamRequest(contextPath.addSegment("record1id_team"), RequestHelper.getValue(unmappedFields, "record1id_team"));
    }

    @NavigationProperty(name="record2roleid")
    @JsonIgnore
    public ConnectionroleRequest getRecord2roleid() {
        return new ConnectionroleRequest(contextPath.addSegment("record2roleid"), RequestHelper.getValue(unmappedFields, "record2roleid"));
    }

    @NavigationProperty(name="record2id_goal")
    @JsonIgnore
    public GoalRequest getRecord2id_goal() {
        return new GoalRequest(contextPath.addSegment("record2id_goal"), RequestHelper.getValue(unmappedFields, "record2id_goal"));
    }

    @NavigationProperty(name="record1id_position")
    @JsonIgnore
    public PositionRequest getRecord1id_position() {
        return new PositionRequest(contextPath.addSegment("record1id_position"), RequestHelper.getValue(unmappedFields, "record1id_position"));
    }

    @NavigationProperty(name="record1id_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getRecord1id_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("record1id_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "record1id_recurringappointmentmaster"));
    }

    @NavigationProperty(name="record1id_processsession")
    @JsonIgnore
    public ProcesssessionRequest getRecord1id_processsession() {
        return new ProcesssessionRequest(contextPath.addSegment("record1id_processsession"), RequestHelper.getValue(unmappedFields, "record1id_processsession"));
    }

    @NavigationProperty(name="Connection_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getConnection_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Connection_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Connection_AsyncOperations"));
    }

    @NavigationProperty(name="Connection_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getConnection_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Connection_ProcessSessions"), RequestHelper.getValue(unmappedFields, "Connection_ProcessSessions"));
    }

    @NavigationProperty(name="record1id_appointment")
    @JsonIgnore
    public AppointmentRequest getRecord1id_appointment() {
        return new AppointmentRequest(contextPath.addSegment("record1id_appointment"), RequestHelper.getValue(unmappedFields, "record1id_appointment"));
    }

    @NavigationProperty(name="record2id_fax")
    @JsonIgnore
    public FaxRequest getRecord2id_fax() {
        return new FaxRequest(contextPath.addSegment("record2id_fax"), RequestHelper.getValue(unmappedFields, "record2id_fax"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="relatedconnectionid")
    @JsonIgnore
    public ConnectionRequest getRelatedconnectionid() {
        return new ConnectionRequest(contextPath.addSegment("relatedconnectionid"), RequestHelper.getValue(unmappedFields, "relatedconnectionid"));
    }

    @NavigationProperty(name="connection_related_connection")
    @JsonIgnore
    public ConnectionCollectionRequest getConnection_related_connection() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("connection_related_connection"), RequestHelper.getValue(unmappedFields, "connection_related_connection"));
    }

    @NavigationProperty(name="record2id_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getRecord2id_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("record2id_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "record2id_recurringappointmentmaster"));
    }

    @NavigationProperty(name="record1id_phonecall")
    @JsonIgnore
    public PhonecallRequest getRecord1id_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("record1id_phonecall"), RequestHelper.getValue(unmappedFields, "record1id_phonecall"));
    }

    @NavigationProperty(name="record2id_appointment")
    @JsonIgnore
    public AppointmentRequest getRecord2id_appointment() {
        return new AppointmentRequest(contextPath.addSegment("record2id_appointment"), RequestHelper.getValue(unmappedFields, "record2id_appointment"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="record1id_goal")
    @JsonIgnore
    public GoalRequest getRecord1id_goal() {
        return new GoalRequest(contextPath.addSegment("record1id_goal"), RequestHelper.getValue(unmappedFields, "record1id_goal"));
    }

    @NavigationProperty(name="record1id_socialactivity")
    @JsonIgnore
    public SocialactivityRequest getRecord1id_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("record1id_socialactivity"), RequestHelper.getValue(unmappedFields, "record1id_socialactivity"));
    }

    @NavigationProperty(name="record1id_fax")
    @JsonIgnore
    public FaxRequest getRecord1id_fax() {
        return new FaxRequest(contextPath.addSegment("record1id_fax"), RequestHelper.getValue(unmappedFields, "record1id_fax"));
    }

    @NavigationProperty(name="record2id_position")
    @JsonIgnore
    public PositionRequest getRecord2id_position() {
        return new PositionRequest(contextPath.addSegment("record2id_position"), RequestHelper.getValue(unmappedFields, "record2id_position"));
    }

    @NavigationProperty(name="record1roleid")
    @JsonIgnore
    public ConnectionroleRequest getRecord1roleid() {
        return new ConnectionroleRequest(contextPath.addSegment("record1roleid"), RequestHelper.getValue(unmappedFields, "record1roleid"));
    }

    @NavigationProperty(name="record1id_letter")
    @JsonIgnore
    public LetterRequest getRecord1id_letter() {
        return new LetterRequest(contextPath.addSegment("record1id_letter"), RequestHelper.getValue(unmappedFields, "record1id_letter"));
    }

    @NavigationProperty(name="record2id_processsession")
    @JsonIgnore
    public ProcesssessionRequest getRecord2id_processsession() {
        return new ProcesssessionRequest(contextPath.addSegment("record2id_processsession"), RequestHelper.getValue(unmappedFields, "record2id_processsession"));
    }

    @NavigationProperty(name="Connection_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getConnection_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Connection_SyncErrors"), RequestHelper.getValue(unmappedFields, "Connection_SyncErrors"));
    }

    @NavigationProperty(name="record2id_activitypointer")
    @JsonIgnore
    public ActivitypointerRequest getRecord2id_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("record2id_activitypointer"), RequestHelper.getValue(unmappedFields, "record2id_activitypointer"));
    }

    @NavigationProperty(name="record1id_account")
    @JsonIgnore
    public AccountRequest getRecord1id_account() {
        return new AccountRequest(contextPath.addSegment("record1id_account"), RequestHelper.getValue(unmappedFields, "record1id_account"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="record2id_contact")
    @JsonIgnore
    public ContactRequest getRecord2id_contact() {
        return new ContactRequest(contextPath.addSegment("record2id_contact"), RequestHelper.getValue(unmappedFields, "record2id_contact"));
    }

    @NavigationProperty(name="record1id_activitypointer")
    @JsonIgnore
    public ActivitypointerRequest getRecord1id_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("record1id_activitypointer"), RequestHelper.getValue(unmappedFields, "record1id_activitypointer"));
    }

    @NavigationProperty(name="record2id_phonecall")
    @JsonIgnore
    public PhonecallRequest getRecord2id_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("record2id_phonecall"), RequestHelper.getValue(unmappedFields, "record2id_phonecall"));
    }

    @NavigationProperty(name="record1id_territory")
    @JsonIgnore
    public TerritoryRequest getRecord1id_territory() {
        return new TerritoryRequest(contextPath.addSegment("record1id_territory"), RequestHelper.getValue(unmappedFields, "record1id_territory"));
    }

    @NavigationProperty(name="record2id_territory")
    @JsonIgnore
    public TerritoryRequest getRecord2id_territory() {
        return new TerritoryRequest(contextPath.addSegment("record2id_territory"), RequestHelper.getValue(unmappedFields, "record2id_territory"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Connection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Connection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Connection _copy() {
        Connection _x = new Connection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.record1objecttypecode = record1objecttypecode;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.statecode = statecode;
        _x._record1roleid_value = _record1roleid_value;
        _x.effectiveend = effectiveend;
        _x.entityimage_url = entityimage_url;
        _x.name = name;
        _x.connectionid = connectionid;
        _x.exchangerate = exchangerate;
        _x._owningteam_value = _owningteam_value;
        _x._createdby_value = _createdby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.record2objecttypecode = record2objecttypecode;
        _x._ownerid_value = _ownerid_value;
        _x._owninguser_value = _owninguser_value;
        _x._record1id_value = _record1id_value;
        _x.effectivestart = effectivestart;
        _x._relatedconnectionid_value = _relatedconnectionid_value;
        _x.modifiedon = modifiedon;
        _x.description = description;
        _x.versionnumber = versionnumber;
        _x.entityimageid = entityimageid;
        _x.entityimage_timestamp = entityimage_timestamp;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.statuscode = statuscode;
        _x.importsequencenumber = importsequencenumber;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.ismaster = ismaster;
        _x._record2id_value = _record2id_value;
        _x._record2roleid_value = _record2roleid_value;
        _x.createdon = createdon;
        _x.entityimage = entityimage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Connection[");
        b.append("record1objecttypecode=");
        b.append(this.record1objecttypecode);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_record1roleid_value=");
        b.append(this._record1roleid_value);
        b.append(", ");
        b.append("effectiveend=");
        b.append(this.effectiveend);
        b.append(", ");
        b.append("entityimage_url=");
        b.append(this.entityimage_url);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("connectionid=");
        b.append(this.connectionid);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("record2objecttypecode=");
        b.append(this.record2objecttypecode);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_record1id_value=");
        b.append(this._record1id_value);
        b.append(", ");
        b.append("effectivestart=");
        b.append(this.effectivestart);
        b.append(", ");
        b.append("_relatedconnectionid_value=");
        b.append(this._relatedconnectionid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("entityimageid=");
        b.append(this.entityimageid);
        b.append(", ");
        b.append("entityimage_timestamp=");
        b.append(this.entityimage_timestamp);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("ismaster=");
        b.append(this.ismaster);
        b.append(", ");
        b.append("_record2id_value=");
        b.append(this._record2id_value);
        b.append(", ");
        b.append("_record2roleid_value=");
        b.append(this._record2roleid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("entityimage=");
        b.append(this.entityimage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
