package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActivitymimeattachmentRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AnnualfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.ApplicationuserRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AttributeimageconfigRequest;
import microsoft.dynamics.crm.entity.request.BulkdeleteoperationRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitnewsarticleRequest;
import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessrecordstrackerRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessversiontrackerRequest;
import microsoft.dynamics.crm.entity.request.ConnectionreferenceRequest;
import microsoft.dynamics.crm.entity.request.ConnectorRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.CustomeraddressRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspaceRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspacepermissionRequest;
import microsoft.dynamics.crm.entity.request.DisplaystringRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.EmailserverprofileRequest;
import microsoft.dynamics.crm.entity.request.EntityanalyticsconfigRequest;
import microsoft.dynamics.crm.entity.request.EntityimageconfigRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariabledefinitionRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariablevalueRequest;
import microsoft.dynamics.crm.entity.request.ExportsolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.FixedmonthlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.FlowsessionRequest;
import microsoft.dynamics.crm.entity.request.Ggw_crewRequest;
import microsoft.dynamics.crm.entity.request.Ggw_eventRequest;
import microsoft.dynamics.crm.entity.request.Ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.Ggw_team_applicationRequest;
import microsoft.dynamics.crm.entity.request.ImportRequest;
import microsoft.dynamics.crm.entity.request.ImportdataRequest;
import microsoft.dynamics.crm.entity.request.ImportfileRequest;
import microsoft.dynamics.crm.entity.request.ImportlogRequest;
import microsoft.dynamics.crm.entity.request.ImportmapRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KbarticlecommentRequest;
import microsoft.dynamics.crm.entity.request.KbarticletemplateRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.MonthlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetrecordRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetscontainerRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileattacheddataRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aifptrainingdocumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aimodelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingboundingboxRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aitemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysiscomponentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisjobRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultdetailRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_dataflowRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_helppageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticleimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_richtextfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_serviceconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_slakpiRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleargumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthrulesetRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PostRequest;
import microsoft.dynamics.crm.entity.request.PrivilegeRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageparameterRequest;
import microsoft.dynamics.crm.entity.request.QuarterlyfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.RelationshipattributeRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.SavedqueryRequest;
import microsoft.dynamics.crm.entity.request.SemiannualfiscalcalendarRequest;
import microsoft.dynamics.crm.entity.request.ServiceplanRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentattributeconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentrelationshipconfigurationRequest;
import microsoft.dynamics.crm.entity.request.StagesolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.SubjectRequest;
import microsoft.dynamics.crm.entity.request.SystemformRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TemplateRequest;
import microsoft.dynamics.crm.entity.request.TerritoryRequest;
import microsoft.dynamics.crm.entity.request.ThemeRequest;
import microsoft.dynamics.crm.entity.request.UserformRequest;
import microsoft.dynamics.crm.entity.request.UsermappingRequest;
import microsoft.dynamics.crm.entity.request.UserqueryRequest;
import microsoft.dynamics.crm.entity.request.WorkflowbinaryRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_regardingobjectid_value", 
    "errornumber", 
    "bulkdeletefailureid", 
    "_asyncoperationid_value", 
    "_ownerid_value", 
    "errordescription", 
    "_bulkdeleteoperationid_value", 
    "orderedqueryindex", 
    "owninguser", 
    "owningbusinessunit"})
@JsonInclude(Include.NON_NULL)
public class Bulkdeletefailure extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.bulkdeletefailure";
    }

    @JsonProperty("_regardingobjectid_value")
    protected UUID _regardingobjectid_value;

    @JsonProperty("errornumber")
    protected Integer errornumber;

    @JsonProperty("bulkdeletefailureid")
    protected UUID bulkdeletefailureid;

    @JsonProperty("_asyncoperationid_value")
    protected UUID _asyncoperationid_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("errordescription")
    protected String errordescription;

    @JsonProperty("_bulkdeleteoperationid_value")
    protected UUID _bulkdeleteoperationid_value;

    @JsonProperty("orderedqueryindex")
    protected Integer orderedqueryindex;

    @JsonProperty("owninguser")
    protected UUID owninguser;

    @JsonProperty("owningbusinessunit")
    protected UUID owningbusinessunit;

    protected Bulkdeletefailure() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBulkdeletefailure() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _regardingobjectid_value;
        private Integer errornumber;
        private UUID bulkdeletefailureid;
        private UUID _asyncoperationid_value;
        private UUID _ownerid_value;
        private String errordescription;
        private UUID _bulkdeleteoperationid_value;
        private Integer orderedqueryindex;
        private UUID owninguser;
        private UUID owningbusinessunit;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _regardingobjectid_value(UUID _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder errornumber(Integer errornumber) {
            this.errornumber = errornumber;
            this.changedFields = changedFields.add("errornumber");
            return this;
        }

        public Builder bulkdeletefailureid(UUID bulkdeletefailureid) {
            this.bulkdeletefailureid = bulkdeletefailureid;
            this.changedFields = changedFields.add("bulkdeletefailureid");
            return this;
        }

        public Builder _asyncoperationid_value(UUID _asyncoperationid_value) {
            this._asyncoperationid_value = _asyncoperationid_value;
            this.changedFields = changedFields.add("_asyncoperationid_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder errordescription(String errordescription) {
            this.errordescription = errordescription;
            this.changedFields = changedFields.add("errordescription");
            return this;
        }

        public Builder _bulkdeleteoperationid_value(UUID _bulkdeleteoperationid_value) {
            this._bulkdeleteoperationid_value = _bulkdeleteoperationid_value;
            this.changedFields = changedFields.add("_bulkdeleteoperationid_value");
            return this;
        }

        public Builder orderedqueryindex(Integer orderedqueryindex) {
            this.orderedqueryindex = orderedqueryindex;
            this.changedFields = changedFields.add("orderedqueryindex");
            return this;
        }

        public Builder owninguser(UUID owninguser) {
            this.owninguser = owninguser;
            this.changedFields = changedFields.add("owninguser");
            return this;
        }

        public Builder owningbusinessunit(UUID owningbusinessunit) {
            this.owningbusinessunit = owningbusinessunit;
            this.changedFields = changedFields.add("owningbusinessunit");
            return this;
        }

        public Bulkdeletefailure build() {
            Bulkdeletefailure _x = new Bulkdeletefailure();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.bulkdeletefailure";
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.errornumber = errornumber;
            _x.bulkdeletefailureid = bulkdeletefailureid;
            _x._asyncoperationid_value = _asyncoperationid_value;
            _x._ownerid_value = _ownerid_value;
            _x.errordescription = errordescription;
            _x._bulkdeleteoperationid_value = _bulkdeleteoperationid_value;
            _x.orderedqueryindex = orderedqueryindex;
            _x.owninguser = owninguser;
            _x.owningbusinessunit = owningbusinessunit;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && bulkdeletefailureid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(bulkdeletefailureid, UUID.class));
        }
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Bulkdeletefailure with_regardingobjectid_value(UUID _regardingobjectid_value) {
        Bulkdeletefailure _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeletefailure");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="errornumber")
    @JsonIgnore
    public Optional<Integer> getErrornumber() {
        return Optional.ofNullable(errornumber);
    }

    public Bulkdeletefailure withErrornumber(Integer errornumber) {
        Bulkdeletefailure _x = _copy();
        _x.changedFields = changedFields.add("errornumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeletefailure");
        _x.errornumber = errornumber;
        return _x;
    }

    @Property(name="bulkdeletefailureid")
    @JsonIgnore
    public Optional<UUID> getBulkdeletefailureid() {
        return Optional.ofNullable(bulkdeletefailureid);
    }

    public Bulkdeletefailure withBulkdeletefailureid(UUID bulkdeletefailureid) {
        Bulkdeletefailure _x = _copy();
        _x.changedFields = changedFields.add("bulkdeletefailureid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeletefailure");
        _x.bulkdeletefailureid = bulkdeletefailureid;
        return _x;
    }

    @Property(name="_asyncoperationid_value")
    @JsonIgnore
    public Optional<UUID> get_asyncoperationid_value() {
        return Optional.ofNullable(_asyncoperationid_value);
    }

    public Bulkdeletefailure with_asyncoperationid_value(UUID _asyncoperationid_value) {
        Bulkdeletefailure _x = _copy();
        _x.changedFields = changedFields.add("_asyncoperationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeletefailure");
        _x._asyncoperationid_value = _asyncoperationid_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Bulkdeletefailure with_ownerid_value(UUID _ownerid_value) {
        Bulkdeletefailure _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeletefailure");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="errordescription")
    @JsonIgnore
    public Optional<String> getErrordescription() {
        return Optional.ofNullable(errordescription);
    }

    public Bulkdeletefailure withErrordescription(String errordescription) {
        Checks.checkIsAscii(errordescription);
        Bulkdeletefailure _x = _copy();
        _x.changedFields = changedFields.add("errordescription");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeletefailure");
        _x.errordescription = errordescription;
        return _x;
    }

    @Property(name="_bulkdeleteoperationid_value")
    @JsonIgnore
    public Optional<UUID> get_bulkdeleteoperationid_value() {
        return Optional.ofNullable(_bulkdeleteoperationid_value);
    }

    public Bulkdeletefailure with_bulkdeleteoperationid_value(UUID _bulkdeleteoperationid_value) {
        Bulkdeletefailure _x = _copy();
        _x.changedFields = changedFields.add("_bulkdeleteoperationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeletefailure");
        _x._bulkdeleteoperationid_value = _bulkdeleteoperationid_value;
        return _x;
    }

    @Property(name="orderedqueryindex")
    @JsonIgnore
    public Optional<Integer> getOrderedqueryindex() {
        return Optional.ofNullable(orderedqueryindex);
    }

    public Bulkdeletefailure withOrderedqueryindex(Integer orderedqueryindex) {
        Bulkdeletefailure _x = _copy();
        _x.changedFields = changedFields.add("orderedqueryindex");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeletefailure");
        _x.orderedqueryindex = orderedqueryindex;
        return _x;
    }

    @Property(name="owninguser")
    @JsonIgnore
    public Optional<UUID> getOwninguser() {
        return Optional.ofNullable(owninguser);
    }

    public Bulkdeletefailure withOwninguser(UUID owninguser) {
        Bulkdeletefailure _x = _copy();
        _x.changedFields = changedFields.add("owninguser");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeletefailure");
        _x.owninguser = owninguser;
        return _x;
    }

    @Property(name="owningbusinessunit")
    @JsonIgnore
    public Optional<UUID> getOwningbusinessunit() {
        return Optional.ofNullable(owningbusinessunit);
    }

    public Bulkdeletefailure withOwningbusinessunit(UUID owningbusinessunit) {
        Bulkdeletefailure _x = _copy();
        _x.changedFields = changedFields.add("owningbusinessunit");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeletefailure");
        _x.owningbusinessunit = owningbusinessunit;
        return _x;
    }

    public Bulkdeletefailure withUnmappedField(String name, String value) {
        Bulkdeletefailure _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="regardingobjectid_theme")
    @JsonIgnore
    public ThemeRequest getRegardingobjectid_theme() {
        return new ThemeRequest(contextPath.addSegment("regardingobjectid_theme"), RequestHelper.getValue(unmappedFields, "regardingobjectid_theme"));
    }

    @NavigationProperty(name="regardingobjectid_usermapping")
    @JsonIgnore
    public UsermappingRequest getRegardingobjectid_usermapping() {
        return new UsermappingRequest(contextPath.addSegment("regardingobjectid_usermapping"), RequestHelper.getValue(unmappedFields, "regardingobjectid_usermapping"));
    }

    @NavigationProperty(name="regardingobjectid_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getRegardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgearticle"));
    }

    @NavigationProperty(name="regardingobjectid_post")
    @JsonIgnore
    public PostRequest getRegardingobjectid_post() {
        return new PostRequest(contextPath.addSegment("regardingobjectid_post"), RequestHelper.getValue(unmappedFields, "regardingobjectid_post"));
    }

    @NavigationProperty(name="regardingobjectid_knowledgebaserecord")
    @JsonIgnore
    public KnowledgebaserecordRequest getRegardingobjectid_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgebaserecord"));
    }

    @NavigationProperty(name="regardingobjectid_customeraddress")
    @JsonIgnore
    public CustomeraddressRequest getRegardingobjectid_customeraddress() {
        return new CustomeraddressRequest(contextPath.addSegment("regardingobjectid_customeraddress"), RequestHelper.getValue(unmappedFields, "regardingobjectid_customeraddress"));
    }

    @NavigationProperty(name="regardingobjectid_annualfiscalcalendar")
    @JsonIgnore
    public AnnualfiscalcalendarRequest getRegardingobjectid_annualfiscalcalendar() {
        return new AnnualfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_annualfiscalcalendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_annualfiscalcalendar"));
    }

    @NavigationProperty(name="regardingobjectid_fax")
    @JsonIgnore
    public FaxRequest getRegardingobjectid_fax() {
        return new FaxRequest(contextPath.addSegment("regardingobjectid_fax"), RequestHelper.getValue(unmappedFields, "regardingobjectid_fax"));
    }

    @NavigationProperty(name="regardingobjectid_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getRegardingobjectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("regardingobjectid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "regardingobjectid_recurringappointmentmaster"));
    }

    @NavigationProperty(name="regardingobjectid_queue")
    @JsonIgnore
    public QueueRequest getRegardingobjectid_queue() {
        return new QueueRequest(contextPath.addSegment("regardingobjectid_queue"), RequestHelper.getValue(unmappedFields, "regardingobjectid_queue"));
    }

    @NavigationProperty(name="regardingobjectid_calendar")
    @JsonIgnore
    public CalendarRequest getRegardingobjectid_calendar() {
        return new CalendarRequest(contextPath.addSegment("regardingobjectid_calendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_calendar"));
    }

    @NavigationProperty(name="regardingobjectid_kbarticlecomment")
    @JsonIgnore
    public KbarticlecommentRequest getRegardingobjectid_kbarticlecomment() {
        return new KbarticlecommentRequest(contextPath.addSegment("regardingobjectid_kbarticlecomment"), RequestHelper.getValue(unmappedFields, "regardingobjectid_kbarticlecomment"));
    }

    @NavigationProperty(name="regardingobjectid_annotation")
    @JsonIgnore
    public AnnotationRequest getRegardingobjectid_annotation() {
        return new AnnotationRequest(contextPath.addSegment("regardingobjectid_annotation"), RequestHelper.getValue(unmappedFields, "regardingobjectid_annotation"));
    }

    @NavigationProperty(name="regardingobjectid_letter")
    @JsonIgnore
    public LetterRequest getRegardingobjectid_letter() {
        return new LetterRequest(contextPath.addSegment("regardingobjectid_letter"), RequestHelper.getValue(unmappedFields, "regardingobjectid_letter"));
    }

    @NavigationProperty(name="regardingobjectid_privilege")
    @JsonIgnore
    public PrivilegeRequest getRegardingobjectid_privilege() {
        return new PrivilegeRequest(contextPath.addSegment("regardingobjectid_privilege"), RequestHelper.getValue(unmappedFields, "regardingobjectid_privilege"));
    }

    @NavigationProperty(name="regardingobjectid_phonecall")
    @JsonIgnore
    public PhonecallRequest getRegardingobjectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("regardingobjectid_phonecall"), RequestHelper.getValue(unmappedFields, "regardingobjectid_phonecall"));
    }

    @NavigationProperty(name="regardingobjectid_fixedmonthlyfiscalcalendar")
    @JsonIgnore
    public FixedmonthlyfiscalcalendarRequest getRegardingobjectid_fixedmonthlyfiscalcalendar() {
        return new FixedmonthlyfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_fixedmonthlyfiscalcalendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_fixedmonthlyfiscalcalendar"));
    }

    @NavigationProperty(name="regardingobjectid_businessunitnewsarticle")
    @JsonIgnore
    public BusinessunitnewsarticleRequest getRegardingobjectid_businessunitnewsarticle() {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("regardingobjectid_businessunitnewsarticle"), RequestHelper.getValue(unmappedFields, "regardingobjectid_businessunitnewsarticle"));
    }

    @NavigationProperty(name="regardingobjectid_systemuser")
    @JsonIgnore
    public SystemuserRequest getRegardingobjectid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("regardingobjectid_systemuser"), RequestHelper.getValue(unmappedFields, "regardingobjectid_systemuser"));
    }

    @NavigationProperty(name="regardingobjectid_kbarticle")
    @JsonIgnore
    public KbarticleRequest getRegardingobjectid_kbarticle() {
        return new KbarticleRequest(contextPath.addSegment("regardingobjectid_kbarticle"), RequestHelper.getValue(unmappedFields, "regardingobjectid_kbarticle"));
    }

    @NavigationProperty(name="regardingobjectid_template")
    @JsonIgnore
    public TemplateRequest getRegardingobjectid_template() {
        return new TemplateRequest(contextPath.addSegment("regardingobjectid_template"), RequestHelper.getValue(unmappedFields, "regardingobjectid_template"));
    }

    @NavigationProperty(name="regardingobjectid_quarterlyfiscalcalendar")
    @JsonIgnore
    public QuarterlyfiscalcalendarRequest getRegardingobjectid_quarterlyfiscalcalendar() {
        return new QuarterlyfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_quarterlyfiscalcalendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_quarterlyfiscalcalendar"));
    }

    @NavigationProperty(name="regardingobjectid_semiannualfiscalcalendar")
    @JsonIgnore
    public SemiannualfiscalcalendarRequest getRegardingobjectid_semiannualfiscalcalendar() {
        return new SemiannualfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_semiannualfiscalcalendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_semiannualfiscalcalendar"));
    }

    @NavigationProperty(name="regardingobjectid_importfile")
    @JsonIgnore
    public ImportfileRequest getRegardingobjectid_importfile() {
        return new ImportfileRequest(contextPath.addSegment("regardingobjectid_importfile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_importfile"));
    }

    @NavigationProperty(name="regardingobjectid_systemform")
    @JsonIgnore
    public SystemformRequest getRegardingobjectid_systemform() {
        return new SystemformRequest(contextPath.addSegment("regardingobjectid_systemform"), RequestHelper.getValue(unmappedFields, "regardingobjectid_systemform"));
    }

    @NavigationProperty(name="regardingobjectid_importlog")
    @JsonIgnore
    public ImportlogRequest getRegardingobjectid_importlog() {
        return new ImportlogRequest(contextPath.addSegment("regardingobjectid_importlog"), RequestHelper.getValue(unmappedFields, "regardingobjectid_importlog"));
    }

    @NavigationProperty(name="regardingobjectid_role")
    @JsonIgnore
    public RoleRequest getRegardingobjectid_role() {
        return new RoleRequest(contextPath.addSegment("regardingobjectid_role"), RequestHelper.getValue(unmappedFields, "regardingobjectid_role"));
    }

    @NavigationProperty(name="regardingobjectid_userform")
    @JsonIgnore
    public UserformRequest getRegardingobjectid_userform() {
        return new UserformRequest(contextPath.addSegment("regardingobjectid_userform"), RequestHelper.getValue(unmappedFields, "regardingobjectid_userform"));
    }

    @NavigationProperty(name="regardingobjectid_account")
    @JsonIgnore
    public AccountRequest getRegardingobjectid_account() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account"), RequestHelper.getValue(unmappedFields, "regardingobjectid_account"));
    }

    @NavigationProperty(name="regardingobjectid_socialactivity")
    @JsonIgnore
    public SocialactivityRequest getRegardingobjectid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("regardingobjectid_socialactivity"), RequestHelper.getValue(unmappedFields, "regardingobjectid_socialactivity"));
    }

    @NavigationProperty(name="regardingobjectid_email")
    @JsonIgnore
    public EmailRequest getRegardingobjectid_email() {
        return new EmailRequest(contextPath.addSegment("regardingobjectid_email"), RequestHelper.getValue(unmappedFields, "regardingobjectid_email"));
    }

    @NavigationProperty(name="regardingobjectid_displaystring")
    @JsonIgnore
    public DisplaystringRequest getRegardingobjectid_displaystring() {
        return new DisplaystringRequest(contextPath.addSegment("regardingobjectid_displaystring"), RequestHelper.getValue(unmappedFields, "regardingobjectid_displaystring"));
    }

    @NavigationProperty(name="regardingobjectid_savedquery")
    @JsonIgnore
    public SavedqueryRequest getRegardingobjectid_savedquery() {
        return new SavedqueryRequest(contextPath.addSegment("regardingobjectid_savedquery"), RequestHelper.getValue(unmappedFields, "regardingobjectid_savedquery"));
    }

    @NavigationProperty(name="regardingobjectid_userquery")
    @JsonIgnore
    public UserqueryRequest getRegardingobjectid_userquery() {
        return new UserqueryRequest(contextPath.addSegment("regardingobjectid_userquery"), RequestHelper.getValue(unmappedFields, "regardingobjectid_userquery"));
    }

    @NavigationProperty(name="regardingobjectid_appointment")
    @JsonIgnore
    public AppointmentRequest getRegardingobjectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("regardingobjectid_appointment"), RequestHelper.getValue(unmappedFields, "regardingobjectid_appointment"));
    }

    @NavigationProperty(name="regardingobjectid_organization")
    @JsonIgnore
    public OrganizationRequest getRegardingobjectid_organization() {
        return new OrganizationRequest(contextPath.addSegment("regardingobjectid_organization"), RequestHelper.getValue(unmappedFields, "regardingobjectid_organization"));
    }

    @NavigationProperty(name="regardingobjectid_businessunit")
    @JsonIgnore
    public BusinessunitRequest getRegardingobjectid_businessunit() {
        return new BusinessunitRequest(contextPath.addSegment("regardingobjectid_businessunit"), RequestHelper.getValue(unmappedFields, "regardingobjectid_businessunit"));
    }

    @NavigationProperty(name="regardingobjectid_monthlyfiscalcalendar")
    @JsonIgnore
    public MonthlyfiscalcalendarRequest getRegardingobjectid_monthlyfiscalcalendar() {
        return new MonthlyfiscalcalendarRequest(contextPath.addSegment("regardingobjectid_monthlyfiscalcalendar"), RequestHelper.getValue(unmappedFields, "regardingobjectid_monthlyfiscalcalendar"));
    }

    @NavigationProperty(name="regardingobjectid_activitymimeattachment")
    @JsonIgnore
    public ActivitymimeattachmentRequest getRegardingobjectid_activitymimeattachment() {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("regardingobjectid_activitymimeattachment"), RequestHelper.getValue(unmappedFields, "regardingobjectid_activitymimeattachment"));
    }

    @NavigationProperty(name="regardingobjectid_kbarticletemplate")
    @JsonIgnore
    public KbarticletemplateRequest getRegardingobjectid_kbarticletemplate() {
        return new KbarticletemplateRequest(contextPath.addSegment("regardingobjectid_kbarticletemplate"), RequestHelper.getValue(unmappedFields, "regardingobjectid_kbarticletemplate"));
    }

    @NavigationProperty(name="regardingobjectid_emailserverprofile")
    @JsonIgnore
    public EmailserverprofileRequest getRegardingobjectid_emailserverprofile() {
        return new EmailserverprofileRequest(contextPath.addSegment("regardingobjectid_emailserverprofile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_emailserverprofile"));
    }

    @NavigationProperty(name="regardingobjectid_sla")
    @JsonIgnore
    public SlaRequest getRegardingobjectid_sla() {
        return new SlaRequest(contextPath.addSegment("regardingobjectid_sla"), RequestHelper.getValue(unmappedFields, "regardingobjectid_sla"));
    }

    @NavigationProperty(name="bulkdeleteoperationid")
    @JsonIgnore
    public BulkdeleteoperationRequest getBulkdeleteoperationid() {
        return new BulkdeleteoperationRequest(contextPath.addSegment("bulkdeleteoperationid"), RequestHelper.getValue(unmappedFields, "bulkdeleteoperationid"));
    }

    @NavigationProperty(name="regardingobjectid_import")
    @JsonIgnore
    public ImportRequest getRegardingobjectid_import() {
        return new ImportRequest(contextPath.addSegment("regardingobjectid_import"), RequestHelper.getValue(unmappedFields, "regardingobjectid_import"));
    }

    @NavigationProperty(name="regardingobjectid_importmap")
    @JsonIgnore
    public ImportmapRequest getRegardingobjectid_importmap() {
        return new ImportmapRequest(contextPath.addSegment("regardingobjectid_importmap"), RequestHelper.getValue(unmappedFields, "regardingobjectid_importmap"));
    }

    @NavigationProperty(name="regardingobjectid_importdata")
    @JsonIgnore
    public ImportdataRequest getRegardingobjectid_importdata() {
        return new ImportdataRequest(contextPath.addSegment("regardingobjectid_importdata"), RequestHelper.getValue(unmappedFields, "regardingobjectid_importdata"));
    }

    @NavigationProperty(name="regardingobjectid_contact")
    @JsonIgnore
    public ContactRequest getRegardingobjectid_contact() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact"), RequestHelper.getValue(unmappedFields, "regardingobjectid_contact"));
    }

    @NavigationProperty(name="regardingobjectid_activitypointer")
    @JsonIgnore
    public ActivitypointerRequest getRegardingobjectid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("regardingobjectid_activitypointer"), RequestHelper.getValue(unmappedFields, "regardingobjectid_activitypointer"));
    }

    @NavigationProperty(name="regardingobjectid_task")
    @JsonIgnore
    public TaskRequest getRegardingobjectid_task() {
        return new TaskRequest(contextPath.addSegment("regardingobjectid_task"), RequestHelper.getValue(unmappedFields, "regardingobjectid_task"));
    }

    @NavigationProperty(name="regardingobjectid_team")
    @JsonIgnore
    public TeamRequest getRegardingobjectid_team() {
        return new TeamRequest(contextPath.addSegment("regardingobjectid_team"), RequestHelper.getValue(unmappedFields, "regardingobjectid_team"));
    }

    @NavigationProperty(name="regardingobjectid_queueitem")
    @JsonIgnore
    public QueueitemRequest getRegardingobjectid_queueitem() {
        return new QueueitemRequest(contextPath.addSegment("regardingobjectid_queueitem"), RequestHelper.getValue(unmappedFields, "regardingobjectid_queueitem"));
    }

    @NavigationProperty(name="regardingobjectid_subject")
    @JsonIgnore
    public SubjectRequest getRegardingobjectid_subject() {
        return new SubjectRequest(contextPath.addSegment("regardingobjectid_subject"), RequestHelper.getValue(unmappedFields, "regardingobjectid_subject"));
    }

    @NavigationProperty(name="regardingobjectid_solutioncomponentattributeconfiguration")
    @JsonIgnore
    public SolutioncomponentattributeconfigurationRequest getRegardingobjectid_solutioncomponentattributeconfiguration() {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentattributeconfiguration"), RequestHelper.getValue(unmappedFields, "regardingobjectid_solutioncomponentattributeconfiguration"));
    }

    @NavigationProperty(name="regardingobjectid_solutioncomponentconfiguration")
    @JsonIgnore
    public SolutioncomponentconfigurationRequest getRegardingobjectid_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentconfiguration"), RequestHelper.getValue(unmappedFields, "regardingobjectid_solutioncomponentconfiguration"));
    }

    @NavigationProperty(name="regardingobjectid_solutioncomponentrelationshipconfiguration")
    @JsonIgnore
    public SolutioncomponentrelationshipconfigurationRequest getRegardingobjectid_solutioncomponentrelationshipconfiguration() {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("regardingobjectid_solutioncomponentrelationshipconfiguration"), RequestHelper.getValue(unmappedFields, "regardingobjectid_solutioncomponentrelationshipconfiguration"));
    }

    @NavigationProperty(name="regardingobjectid_stagesolutionupload")
    @JsonIgnore
    public StagesolutionuploadRequest getRegardingobjectid_stagesolutionupload() {
        return new StagesolutionuploadRequest(contextPath.addSegment("regardingobjectid_stagesolutionupload"), RequestHelper.getValue(unmappedFields, "regardingobjectid_stagesolutionupload"));
    }

    @NavigationProperty(name="regardingobjectid_exportsolutionupload")
    @JsonIgnore
    public ExportsolutionuploadRequest getRegardingobjectid_exportsolutionupload() {
        return new ExportsolutionuploadRequest(contextPath.addSegment("regardingobjectid_exportsolutionupload"), RequestHelper.getValue(unmappedFields, "regardingobjectid_exportsolutionupload"));
    }

    @NavigationProperty(name="regardingobjectid_attributeimageconfig")
    @JsonIgnore
    public AttributeimageconfigRequest getRegardingobjectid_attributeimageconfig() {
        return new AttributeimageconfigRequest(contextPath.addSegment("regardingobjectid_attributeimageconfig"), RequestHelper.getValue(unmappedFields, "regardingobjectid_attributeimageconfig"));
    }

    @NavigationProperty(name="regardingobjectid_entityimageconfig")
    @JsonIgnore
    public EntityimageconfigRequest getRegardingobjectid_entityimageconfig() {
        return new EntityimageconfigRequest(contextPath.addSegment("regardingobjectid_entityimageconfig"), RequestHelper.getValue(unmappedFields, "regardingobjectid_entityimageconfig"));
    }

    @NavigationProperty(name="regardingobjectid_entityanalyticsconfig")
    @JsonIgnore
    public EntityanalyticsconfigRequest getRegardingobjectid_entityanalyticsconfig() {
        return new EntityanalyticsconfigRequest(contextPath.addSegment("regardingobjectid_entityanalyticsconfig"), RequestHelper.getValue(unmappedFields, "regardingobjectid_entityanalyticsconfig"));
    }

    @NavigationProperty(name="regardingobjectid_relationshipattribute")
    @JsonIgnore
    public RelationshipattributeRequest getRegardingobjectid_relationshipattribute() {
        return new RelationshipattributeRequest(contextPath.addSegment("regardingobjectid_relationshipattribute"), RequestHelper.getValue(unmappedFields, "regardingobjectid_relationshipattribute"));
    }

    @NavigationProperty(name="regardingobjectid_datalakeworkspace")
    @JsonIgnore
    public DatalakeworkspaceRequest getRegardingobjectid_datalakeworkspace() {
        return new DatalakeworkspaceRequest(contextPath.addSegment("regardingobjectid_datalakeworkspace"), RequestHelper.getValue(unmappedFields, "regardingobjectid_datalakeworkspace"));
    }

    @NavigationProperty(name="regardingobjectid_datalakeworkspacepermission")
    @JsonIgnore
    public DatalakeworkspacepermissionRequest getRegardingobjectid_datalakeworkspacepermission() {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("regardingobjectid_datalakeworkspacepermission"), RequestHelper.getValue(unmappedFields, "regardingobjectid_datalakeworkspacepermission"));
    }

    @NavigationProperty(name="regardingobjectid_applicationuser")
    @JsonIgnore
    public ApplicationuserRequest getRegardingobjectid_applicationuser() {
        return new ApplicationuserRequest(contextPath.addSegment("regardingobjectid_applicationuser"), RequestHelper.getValue(unmappedFields, "regardingobjectid_applicationuser"));
    }

    @NavigationProperty(name="regardingobjectid_serviceplan")
    @JsonIgnore
    public ServiceplanRequest getRegardingobjectid_serviceplan() {
        return new ServiceplanRequest(contextPath.addSegment("regardingobjectid_serviceplan"), RequestHelper.getValue(unmappedFields, "regardingobjectid_serviceplan"));
    }

    @NavigationProperty(name="regardingobjectid_connector")
    @JsonIgnore
    public ConnectorRequest getRegardingobjectid_connector() {
        return new ConnectorRequest(contextPath.addSegment("regardingobjectid_connector"), RequestHelper.getValue(unmappedFields, "regardingobjectid_connector"));
    }

    @NavigationProperty(name="regardingobjectid_environmentvariabledefinition")
    @JsonIgnore
    public EnvironmentvariabledefinitionRequest getRegardingobjectid_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("regardingobjectid_environmentvariabledefinition"), RequestHelper.getValue(unmappedFields, "regardingobjectid_environmentvariabledefinition"));
    }

    @NavigationProperty(name="regardingobjectid_environmentvariablevalue")
    @JsonIgnore
    public EnvironmentvariablevalueRequest getRegardingobjectid_environmentvariablevalue() {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("regardingobjectid_environmentvariablevalue"), RequestHelper.getValue(unmappedFields, "regardingobjectid_environmentvariablevalue"));
    }

    @NavigationProperty(name="regardingobjectid_processstageparameter")
    @JsonIgnore
    public ProcessstageparameterRequest getRegardingobjectid_processstageparameter() {
        return new ProcessstageparameterRequest(contextPath.addSegment("regardingobjectid_processstageparameter"), RequestHelper.getValue(unmappedFields, "regardingobjectid_processstageparameter"));
    }

    @NavigationProperty(name="regardingobjectid_flowsession")
    @JsonIgnore
    public FlowsessionRequest getRegardingobjectid_flowsession() {
        return new FlowsessionRequest(contextPath.addSegment("regardingobjectid_flowsession"), RequestHelper.getValue(unmappedFields, "regardingobjectid_flowsession"));
    }

    @NavigationProperty(name="regardingobjectid_workflowbinary")
    @JsonIgnore
    public WorkflowbinaryRequest getRegardingobjectid_workflowbinary() {
        return new WorkflowbinaryRequest(contextPath.addSegment("regardingobjectid_workflowbinary"), RequestHelper.getValue(unmappedFields, "regardingobjectid_workflowbinary"));
    }

    @NavigationProperty(name="regardingobjectid_connectionreference")
    @JsonIgnore
    public ConnectionreferenceRequest getRegardingobjectid_connectionreference() {
        return new ConnectionreferenceRequest(contextPath.addSegment("regardingobjectid_connectionreference"), RequestHelper.getValue(unmappedFields, "regardingobjectid_connectionreference"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_helppage")
    @JsonIgnore
    public Msdyn_helppageRequest getRegardingobjectid_msdyn_helppage() {
        return new Msdyn_helppageRequest(contextPath.addSegment("regardingobjectid_msdyn_helppage"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_helppage"));
    }

    @NavigationProperty(name="regardingobjectid_territory")
    @JsonIgnore
    public TerritoryRequest getRegardingobjectid_territory() {
        return new TerritoryRequest(contextPath.addSegment("regardingobjectid_territory"), RequestHelper.getValue(unmappedFields, "regardingobjectid_territory"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_serviceconfiguration")
    @JsonIgnore
    public Msdyn_serviceconfigurationRequest getRegardingobjectid_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("regardingobjectid_msdyn_serviceconfiguration"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_serviceconfiguration"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_slakpi")
    @JsonIgnore
    public Msdyn_slakpiRequest getRegardingobjectid_msdyn_slakpi() {
        return new Msdyn_slakpiRequest(contextPath.addSegment("regardingobjectid_msdyn_slakpi"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_slakpi"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_knowledgearticleimage")
    @JsonIgnore
    public Msdyn_knowledgearticleimageRequest getRegardingobjectid_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("regardingobjectid_msdyn_knowledgearticleimage"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_knowledgearticleimage"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_knowledgearticletemplate")
    @JsonIgnore
    public Msdyn_knowledgearticletemplateRequest getRegardingobjectid_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("regardingobjectid_msdyn_knowledgearticletemplate"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_knowledgearticletemplate"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_dataflow")
    @JsonIgnore
    public Msdyn_dataflowRequest getRegardingobjectid_msdyn_dataflow() {
        return new Msdyn_dataflowRequest(contextPath.addSegment("regardingobjectid_msdyn_dataflow"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_dataflow"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_richtextfile")
    @JsonIgnore
    public Msdyn_richtextfileRequest getRegardingobjectid_msdyn_richtextfile() {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("regardingobjectid_msdyn_richtextfile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_richtextfile"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aiconfiguration")
    @JsonIgnore
    public Msdyn_aiconfigurationRequest getRegardingobjectid_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("regardingobjectid_msdyn_aiconfiguration"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aiconfiguration"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aimodel")
    @JsonIgnore
    public Msdyn_aimodelRequest getRegardingobjectid_msdyn_aimodel() {
        return new Msdyn_aimodelRequest(contextPath.addSegment("regardingobjectid_msdyn_aimodel"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aimodel"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aitemplate")
    @JsonIgnore
    public Msdyn_aitemplateRequest getRegardingobjectid_msdyn_aitemplate() {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("regardingobjectid_msdyn_aitemplate"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aitemplate"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibdataset")
    @JsonIgnore
    public Msdyn_aibdatasetRequest getRegardingobjectid_msdyn_aibdataset() {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdataset"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibdataset"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibdatasetfile")
    @JsonIgnore
    public Msdyn_aibdatasetfileRequest getRegardingobjectid_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetfile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibdatasetfile"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibdatasetrecord")
    @JsonIgnore
    public Msdyn_aibdatasetrecordRequest getRegardingobjectid_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetrecord"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibdatasetrecord"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibdatasetscontainer")
    @JsonIgnore
    public Msdyn_aibdatasetscontainerRequest getRegardingobjectid_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("regardingobjectid_msdyn_aibdatasetscontainer"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibdatasetscontainer"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibfile")
    @JsonIgnore
    public Msdyn_aibfileRequest getRegardingobjectid_msdyn_aibfile() {
        return new Msdyn_aibfileRequest(contextPath.addSegment("regardingobjectid_msdyn_aibfile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibfile"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aibfileattacheddata")
    @JsonIgnore
    public Msdyn_aibfileattacheddataRequest getRegardingobjectid_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("regardingobjectid_msdyn_aibfileattacheddata"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aibfileattacheddata"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aifptrainingdocument")
    @JsonIgnore
    public Msdyn_aifptrainingdocumentRequest getRegardingobjectid_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("regardingobjectid_msdyn_aifptrainingdocument"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aifptrainingdocument"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aiodimage")
    @JsonIgnore
    public Msdyn_aiodimageRequest getRegardingobjectid_msdyn_aiodimage() {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodimage"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aiodimage"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aiodlabel")
    @JsonIgnore
    public Msdyn_aiodlabelRequest getRegardingobjectid_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodlabel"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aiodlabel"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aiodtrainingboundingbox")
    @JsonIgnore
    public Msdyn_aiodtrainingboundingboxRequest getRegardingobjectid_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodtrainingboundingbox"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aiodtrainingboundingbox"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_aiodtrainingimage")
    @JsonIgnore
    public Msdyn_aiodtrainingimageRequest getRegardingobjectid_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("regardingobjectid_msdyn_aiodtrainingimage"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_aiodtrainingimage"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_analysiscomponent")
    @JsonIgnore
    public Msdyn_analysiscomponentRequest getRegardingobjectid_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("regardingobjectid_msdyn_analysiscomponent"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_analysiscomponent"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_analysisjob")
    @JsonIgnore
    public Msdyn_analysisjobRequest getRegardingobjectid_msdyn_analysisjob() {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisjob"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_analysisjob"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_analysisresult")
    @JsonIgnore
    public Msdyn_analysisresultRequest getRegardingobjectid_msdyn_analysisresult() {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisresult"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_analysisresult"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_analysisresultdetail")
    @JsonIgnore
    public Msdyn_analysisresultdetailRequest getRegardingobjectid_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("regardingobjectid_msdyn_analysisresultdetail"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_analysisresultdetail"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_solutionhealthrule")
    @JsonIgnore
    public Msdyn_solutionhealthruleRequest getRegardingobjectid_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthrule"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_solutionhealthrule"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_solutionhealthruleargument")
    @JsonIgnore
    public Msdyn_solutionhealthruleargumentRequest getRegardingobjectid_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthruleargument"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_solutionhealthruleargument"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_solutionhealthruleset")
    @JsonIgnore
    public Msdyn_solutionhealthrulesetRequest getRegardingobjectid_msdyn_solutionhealthruleset() {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("regardingobjectid_msdyn_solutionhealthruleset"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_solutionhealthruleset"));
    }

    @NavigationProperty(name="regardingobjectid_ggw_event")
    @JsonIgnore
    public Ggw_eventRequest getRegardingobjectid_ggw_event() {
        return new Ggw_eventRequest(contextPath.addSegment("regardingobjectid_ggw_event"), RequestHelper.getValue(unmappedFields, "regardingobjectid_ggw_event"));
    }

    @NavigationProperty(name="regardingobjectid_ggw_team")
    @JsonIgnore
    public Ggw_teamRequest getRegardingobjectid_ggw_team() {
        return new Ggw_teamRequest(contextPath.addSegment("regardingobjectid_ggw_team"), RequestHelper.getValue(unmappedFields, "regardingobjectid_ggw_team"));
    }

    @NavigationProperty(name="regardingobjectid_ggw_crew")
    @JsonIgnore
    public Ggw_crewRequest getRegardingobjectid_ggw_crew() {
        return new Ggw_crewRequest(contextPath.addSegment("regardingobjectid_ggw_crew"), RequestHelper.getValue(unmappedFields, "regardingobjectid_ggw_crew"));
    }

    @NavigationProperty(name="regardingobjectid_ggw_team_application")
    @JsonIgnore
    public Ggw_team_applicationRequest getRegardingobjectid_ggw_team_application() {
        return new Ggw_team_applicationRequest(contextPath.addSegment("regardingobjectid_ggw_team_application"), RequestHelper.getValue(unmappedFields, "regardingobjectid_ggw_team_application"));
    }

    @NavigationProperty(name="regardingobjectid_cascadegrantrevokeaccessrecordstracker")
    @JsonIgnore
    public CascadegrantrevokeaccessrecordstrackerRequest getRegardingobjectid_cascadegrantrevokeaccessrecordstracker() {
        return new CascadegrantrevokeaccessrecordstrackerRequest(contextPath.addSegment("regardingobjectid_cascadegrantrevokeaccessrecordstracker"), RequestHelper.getValue(unmappedFields, "regardingobjectid_cascadegrantrevokeaccessrecordstracker"));
    }

    @NavigationProperty(name="regardingobjectid_cascadegrantrevokeaccessversiontracker")
    @JsonIgnore
    public CascadegrantrevokeaccessversiontrackerRequest getRegardingobjectid_cascadegrantrevokeaccessversiontracker() {
        return new CascadegrantrevokeaccessversiontrackerRequest(contextPath.addSegment("regardingobjectid_cascadegrantrevokeaccessversiontracker"), RequestHelper.getValue(unmappedFields, "regardingobjectid_cascadegrantrevokeaccessversiontracker"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Bulkdeletefailure patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Bulkdeletefailure _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Bulkdeletefailure put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Bulkdeletefailure _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Bulkdeletefailure _copy() {
        Bulkdeletefailure _x = new Bulkdeletefailure();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.errornumber = errornumber;
        _x.bulkdeletefailureid = bulkdeletefailureid;
        _x._asyncoperationid_value = _asyncoperationid_value;
        _x._ownerid_value = _ownerid_value;
        _x.errordescription = errordescription;
        _x._bulkdeleteoperationid_value = _bulkdeleteoperationid_value;
        _x.orderedqueryindex = orderedqueryindex;
        _x.owninguser = owninguser;
        _x.owningbusinessunit = owningbusinessunit;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Bulkdeletefailure[");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("errornumber=");
        b.append(this.errornumber);
        b.append(", ");
        b.append("bulkdeletefailureid=");
        b.append(this.bulkdeletefailureid);
        b.append(", ");
        b.append("_asyncoperationid_value=");
        b.append(this._asyncoperationid_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("errordescription=");
        b.append(this.errordescription);
        b.append(", ");
        b.append("_bulkdeleteoperationid_value=");
        b.append(this._bulkdeleteoperationid_value);
        b.append(", ");
        b.append("orderedqueryindex=");
        b.append(this.orderedqueryindex);
        b.append(", ");
        b.append("owninguser=");
        b.append(this.owninguser);
        b.append(", ");
        b.append("owningbusinessunit=");
        b.append(this.owningbusinessunit);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
