package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.RetrieveAuditDetailsResponse;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "objecttypecode", 
    "operation", 
    "_regardingobjectid_value", 
    "auditid", 
    "action", 
    "useradditionalinfo", 
    "attributemask", 
    "_userid_value", 
    "_callinguserid_value", 
    "createdon", 
    "_objectid_value", 
    "transactionid"})
@JsonInclude(Include.NON_NULL)
public class Audit extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.audit";
    }

    @JsonProperty("objecttypecode")
    protected String objecttypecode;

    @JsonProperty("operation")
    protected Integer operation;

    @JsonProperty("_regardingobjectid_value")
    protected UUID _regardingobjectid_value;

    @JsonProperty("auditid")
    protected UUID auditid;

    @JsonProperty("action")
    protected Integer action;

    @JsonProperty("useradditionalinfo")
    protected String useradditionalinfo;

    @JsonProperty("attributemask")
    protected String attributemask;

    @JsonProperty("_userid_value")
    protected UUID _userid_value;

    @JsonProperty("_callinguserid_value")
    protected UUID _callinguserid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_objectid_value")
    protected UUID _objectid_value;

    @JsonProperty("transactionid")
    protected UUID transactionid;

    protected Audit() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAudit() {
        return new Builder();
    }

    public static final class Builder {
        private String objecttypecode;
        private Integer operation;
        private UUID _regardingobjectid_value;
        private UUID auditid;
        private Integer action;
        private String useradditionalinfo;
        private String attributemask;
        private UUID _userid_value;
        private UUID _callinguserid_value;
        private OffsetDateTime createdon;
        private UUID _objectid_value;
        private UUID transactionid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder objecttypecode(String objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Builder operation(Integer operation) {
            this.operation = operation;
            this.changedFields = changedFields.add("operation");
            return this;
        }

        public Builder _regardingobjectid_value(UUID _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder auditid(UUID auditid) {
            this.auditid = auditid;
            this.changedFields = changedFields.add("auditid");
            return this;
        }

        public Builder action(Integer action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public Builder useradditionalinfo(String useradditionalinfo) {
            this.useradditionalinfo = useradditionalinfo;
            this.changedFields = changedFields.add("useradditionalinfo");
            return this;
        }

        public Builder attributemask(String attributemask) {
            this.attributemask = attributemask;
            this.changedFields = changedFields.add("attributemask");
            return this;
        }

        public Builder _userid_value(UUID _userid_value) {
            this._userid_value = _userid_value;
            this.changedFields = changedFields.add("_userid_value");
            return this;
        }

        public Builder _callinguserid_value(UUID _callinguserid_value) {
            this._callinguserid_value = _callinguserid_value;
            this.changedFields = changedFields.add("_callinguserid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _objectid_value(UUID _objectid_value) {
            this._objectid_value = _objectid_value;
            this.changedFields = changedFields.add("_objectid_value");
            return this;
        }

        public Builder transactionid(UUID transactionid) {
            this.transactionid = transactionid;
            this.changedFields = changedFields.add("transactionid");
            return this;
        }

        public Audit build() {
            Audit _x = new Audit();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.audit";
            _x.objecttypecode = objecttypecode;
            _x.operation = operation;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.auditid = auditid;
            _x.action = action;
            _x.useradditionalinfo = useradditionalinfo;
            _x.attributemask = attributemask;
            _x._userid_value = _userid_value;
            _x._callinguserid_value = _callinguserid_value;
            _x.createdon = createdon;
            _x._objectid_value = _objectid_value;
            _x.transactionid = transactionid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && auditid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(auditid, UUID.class));
        }
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<String> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Audit withObjecttypecode(String objecttypecode) {
        Checks.checkIsAscii(objecttypecode);
        Audit _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Property(name="operation")
    @JsonIgnore
    public Optional<Integer> getOperation() {
        return Optional.ofNullable(operation);
    }

    public Audit withOperation(Integer operation) {
        Audit _x = _copy();
        _x.changedFields = changedFields.add("operation");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x.operation = operation;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Audit with_regardingobjectid_value(UUID _regardingobjectid_value) {
        Audit _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="auditid")
    @JsonIgnore
    public Optional<UUID> getAuditid() {
        return Optional.ofNullable(auditid);
    }

    public Audit withAuditid(UUID auditid) {
        Audit _x = _copy();
        _x.changedFields = changedFields.add("auditid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x.auditid = auditid;
        return _x;
    }

    @Property(name="action")
    @JsonIgnore
    public Optional<Integer> getAction() {
        return Optional.ofNullable(action);
    }

    public Audit withAction(Integer action) {
        Audit _x = _copy();
        _x.changedFields = changedFields.add("action");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x.action = action;
        return _x;
    }

    @Property(name="useradditionalinfo")
    @JsonIgnore
    public Optional<String> getUseradditionalinfo() {
        return Optional.ofNullable(useradditionalinfo);
    }

    public Audit withUseradditionalinfo(String useradditionalinfo) {
        Checks.checkIsAscii(useradditionalinfo);
        Audit _x = _copy();
        _x.changedFields = changedFields.add("useradditionalinfo");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x.useradditionalinfo = useradditionalinfo;
        return _x;
    }

    @Property(name="attributemask")
    @JsonIgnore
    public Optional<String> getAttributemask() {
        return Optional.ofNullable(attributemask);
    }

    public Audit withAttributemask(String attributemask) {
        Checks.checkIsAscii(attributemask);
        Audit _x = _copy();
        _x.changedFields = changedFields.add("attributemask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x.attributemask = attributemask;
        return _x;
    }

    @Property(name="_userid_value")
    @JsonIgnore
    public Optional<UUID> get_userid_value() {
        return Optional.ofNullable(_userid_value);
    }

    public Audit with_userid_value(UUID _userid_value) {
        Audit _x = _copy();
        _x.changedFields = changedFields.add("_userid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x._userid_value = _userid_value;
        return _x;
    }

    @Property(name="_callinguserid_value")
    @JsonIgnore
    public Optional<UUID> get_callinguserid_value() {
        return Optional.ofNullable(_callinguserid_value);
    }

    public Audit with_callinguserid_value(UUID _callinguserid_value) {
        Audit _x = _copy();
        _x.changedFields = changedFields.add("_callinguserid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x._callinguserid_value = _callinguserid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Audit withCreatedon(OffsetDateTime createdon) {
        Audit _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_objectid_value")
    @JsonIgnore
    public Optional<UUID> get_objectid_value() {
        return Optional.ofNullable(_objectid_value);
    }

    public Audit with_objectid_value(UUID _objectid_value) {
        Audit _x = _copy();
        _x.changedFields = changedFields.add("_objectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x._objectid_value = _objectid_value;
        return _x;
    }

    @Property(name="transactionid")
    @JsonIgnore
    public Optional<UUID> getTransactionid() {
        return Optional.ofNullable(transactionid);
    }

    public Audit withTransactionid(UUID transactionid) {
        Audit _x = _copy();
        _x.changedFields = changedFields.add("transactionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.audit");
        _x.transactionid = transactionid;
        return _x;
    }

    public Audit withUnmappedField(String name, String value) {
        Audit _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="callinguserid")
    @JsonIgnore
    public SystemuserRequest getCallinguserid() {
        return new SystemuserRequest(contextPath.addSegment("callinguserid"), RequestHelper.getValue(unmappedFields, "callinguserid"));
    }

    @NavigationProperty(name="userid")
    @JsonIgnore
    public SystemuserRequest getUserid() {
        return new SystemuserRequest(contextPath.addSegment("userid"), RequestHelper.getValue(unmappedFields, "userid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Audit patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Audit _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Audit put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Audit _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Audit _copy() {
        Audit _x = new Audit();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.objecttypecode = objecttypecode;
        _x.operation = operation;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.auditid = auditid;
        _x.action = action;
        _x.useradditionalinfo = useradditionalinfo;
        _x.attributemask = attributemask;
        _x._userid_value = _userid_value;
        _x._callinguserid_value = _callinguserid_value;
        _x.createdon = createdon;
        _x._objectid_value = _objectid_value;
        _x.transactionid = transactionid;
        return _x;
    }

    @Function(name = "RetrieveAuditDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAuditDetailsResponse> retrieveAuditDetails() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAuditDetailsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAuditDetails"), RetrieveAuditDetailsResponse.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Audit[");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append(", ");
        b.append("operation=");
        b.append(this.operation);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("auditid=");
        b.append(this.auditid);
        b.append(", ");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("useradditionalinfo=");
        b.append(this.useradditionalinfo);
        b.append(", ");
        b.append("attributemask=");
        b.append(this.attributemask);
        b.append(", ");
        b.append("_userid_value=");
        b.append(this._userid_value);
        b.append(", ");
        b.append("_callinguserid_value=");
        b.append(this._callinguserid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_objectid_value=");
        b.append(this._objectid_value);
        b.append(", ");
        b.append("transactionid=");
        b.append(this.transactionid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
