package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.AttributeRequiredLevelManagedProperty;
import microsoft.dynamics.crm.complex.AttributeTypeDisplayName;
import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.enums.AttributeTypeCode;

@JsonPropertyOrder({
    "@odata.type", 
    "AttributeOf", 
    "AttributeType", 
    "AttributeTypeName", 
    "ColumnNumber", 
    "Description", 
    "DisplayName", 
    "DeprecatedVersion", 
    "IntroducedVersion", 
    "EntityLogicalName", 
    "IsAuditEnabled", 
    "IsCustomAttribute", 
    "IsPrimaryId", 
    "IsValidODataAttribute", 
    "IsPrimaryName", 
    "IsValidForCreate", 
    "IsValidForRead", 
    "IsValidForUpdate", 
    "CanBeSecuredForRead", 
    "CanBeSecuredForCreate", 
    "CanBeSecuredForUpdate", 
    "IsSecured", 
    "IsRetrievable", 
    "IsFilterable", 
    "IsSearchable", 
    "IsManaged", 
    "IsGlobalFilterEnabled", 
    "IsSortableEnabled", 
    "LinkedAttributeId", 
    "LogicalName", 
    "IsCustomizable", 
    "IsRenameable", 
    "IsValidForAdvancedFind", 
    "IsValidForForm", 
    "IsRequiredForForm", 
    "IsValidForGrid", 
    "RequiredLevel", 
    "CanModifyAdditionalSettings", 
    "SchemaName", 
    "ExternalName", 
    "IsLogical", 
    "IsDataSourceSecret", 
    "InheritsFrom", 
    "CreatedOn", 
    "ModifiedOn", 
    "SourceType", 
    "AutoNumberFormat"})
@JsonInclude(Include.NON_NULL)
public class AttributeMetadata extends MetadataBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AttributeMetadata";
    }

    @JsonProperty("AttributeOf")
    protected String attributeOf;

    @JsonProperty("AttributeType")
    protected AttributeTypeCode attributeType;

    @JsonProperty("AttributeTypeName")
    protected AttributeTypeDisplayName attributeTypeName;

    @JsonProperty("ColumnNumber")
    protected Integer columnNumber;

    @JsonProperty("Description")
    protected Label description;

    @JsonProperty("DisplayName")
    protected Label displayName;

    @JsonProperty("DeprecatedVersion")
    protected String deprecatedVersion;

    @JsonProperty("IntroducedVersion")
    protected String introducedVersion;

    @JsonProperty("EntityLogicalName")
    protected String entityLogicalName;

    @JsonProperty("IsAuditEnabled")
    protected BooleanManagedProperty isAuditEnabled;

    @JsonProperty("IsCustomAttribute")
    protected Boolean isCustomAttribute;

    @JsonProperty("IsPrimaryId")
    protected Boolean isPrimaryId;

    @JsonProperty("IsValidODataAttribute")
    protected Boolean isValidODataAttribute;

    @JsonProperty("IsPrimaryName")
    protected Boolean isPrimaryName;

    @JsonProperty("IsValidForCreate")
    protected Boolean isValidForCreate;

    @JsonProperty("IsValidForRead")
    protected Boolean isValidForRead;

    @JsonProperty("IsValidForUpdate")
    protected Boolean isValidForUpdate;

    @JsonProperty("CanBeSecuredForRead")
    protected Boolean canBeSecuredForRead;

    @JsonProperty("CanBeSecuredForCreate")
    protected Boolean canBeSecuredForCreate;

    @JsonProperty("CanBeSecuredForUpdate")
    protected Boolean canBeSecuredForUpdate;

    @JsonProperty("IsSecured")
    protected Boolean isSecured;

    @JsonProperty("IsRetrievable")
    protected Boolean isRetrievable;

    @JsonProperty("IsFilterable")
    protected Boolean isFilterable;

    @JsonProperty("IsSearchable")
    protected Boolean isSearchable;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("IsGlobalFilterEnabled")
    protected BooleanManagedProperty isGlobalFilterEnabled;

    @JsonProperty("IsSortableEnabled")
    protected BooleanManagedProperty isSortableEnabled;

    @JsonProperty("LinkedAttributeId")
    protected UUID linkedAttributeId;

    @JsonProperty("LogicalName")
    protected String logicalName;

    @JsonProperty("IsCustomizable")
    protected BooleanManagedProperty isCustomizable;

    @JsonProperty("IsRenameable")
    protected BooleanManagedProperty isRenameable;

    @JsonProperty("IsValidForAdvancedFind")
    protected BooleanManagedProperty isValidForAdvancedFind;

    @JsonProperty("IsValidForForm")
    protected Boolean isValidForForm;

    @JsonProperty("IsRequiredForForm")
    protected Boolean isRequiredForForm;

    @JsonProperty("IsValidForGrid")
    protected Boolean isValidForGrid;

    @JsonProperty("RequiredLevel")
    protected AttributeRequiredLevelManagedProperty requiredLevel;

    @JsonProperty("CanModifyAdditionalSettings")
    protected BooleanManagedProperty canModifyAdditionalSettings;

    @JsonProperty("SchemaName")
    protected String schemaName;

    @JsonProperty("ExternalName")
    protected String externalName;

    @JsonProperty("IsLogical")
    protected Boolean isLogical;

    @JsonProperty("IsDataSourceSecret")
    protected Boolean isDataSourceSecret;

    @JsonProperty("InheritsFrom")
    protected String inheritsFrom;

    @JsonProperty("CreatedOn")
    protected OffsetDateTime createdOn;

    @JsonProperty("ModifiedOn")
    protected OffsetDateTime modifiedOn;

    @JsonProperty("SourceType")
    protected Integer sourceType;

    @JsonProperty("AutoNumberFormat")
    protected String autoNumberFormat;

    protected AttributeMetadata() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAttributeMetadata() {
        return new Builder();
    }

    public static final class Builder {
        private UUID metadataId;
        private Boolean hasChanged;
        private String attributeOf;
        private AttributeTypeCode attributeType;
        private AttributeTypeDisplayName attributeTypeName;
        private Integer columnNumber;
        private Label description;
        private Label displayName;
        private String deprecatedVersion;
        private String introducedVersion;
        private String entityLogicalName;
        private BooleanManagedProperty isAuditEnabled;
        private Boolean isCustomAttribute;
        private Boolean isPrimaryId;
        private Boolean isValidODataAttribute;
        private Boolean isPrimaryName;
        private Boolean isValidForCreate;
        private Boolean isValidForRead;
        private Boolean isValidForUpdate;
        private Boolean canBeSecuredForRead;
        private Boolean canBeSecuredForCreate;
        private Boolean canBeSecuredForUpdate;
        private Boolean isSecured;
        private Boolean isRetrievable;
        private Boolean isFilterable;
        private Boolean isSearchable;
        private Boolean isManaged;
        private BooleanManagedProperty isGlobalFilterEnabled;
        private BooleanManagedProperty isSortableEnabled;
        private UUID linkedAttributeId;
        private String logicalName;
        private BooleanManagedProperty isCustomizable;
        private BooleanManagedProperty isRenameable;
        private BooleanManagedProperty isValidForAdvancedFind;
        private Boolean isValidForForm;
        private Boolean isRequiredForForm;
        private Boolean isValidForGrid;
        private AttributeRequiredLevelManagedProperty requiredLevel;
        private BooleanManagedProperty canModifyAdditionalSettings;
        private String schemaName;
        private String externalName;
        private Boolean isLogical;
        private Boolean isDataSourceSecret;
        private String inheritsFrom;
        private OffsetDateTime createdOn;
        private OffsetDateTime modifiedOn;
        private Integer sourceType;
        private String autoNumberFormat;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public Builder attributeOf(String attributeOf) {
            this.attributeOf = attributeOf;
            this.changedFields = changedFields.add("AttributeOf");
            return this;
        }

        public Builder attributeType(AttributeTypeCode attributeType) {
            this.attributeType = attributeType;
            this.changedFields = changedFields.add("AttributeType");
            return this;
        }

        public Builder attributeTypeName(AttributeTypeDisplayName attributeTypeName) {
            this.attributeTypeName = attributeTypeName;
            this.changedFields = changedFields.add("AttributeTypeName");
            return this;
        }

        public Builder columnNumber(Integer columnNumber) {
            this.columnNumber = columnNumber;
            this.changedFields = changedFields.add("ColumnNumber");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder deprecatedVersion(String deprecatedVersion) {
            this.deprecatedVersion = deprecatedVersion;
            this.changedFields = changedFields.add("DeprecatedVersion");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder isAuditEnabled(BooleanManagedProperty isAuditEnabled) {
            this.isAuditEnabled = isAuditEnabled;
            this.changedFields = changedFields.add("IsAuditEnabled");
            return this;
        }

        public Builder isCustomAttribute(Boolean isCustomAttribute) {
            this.isCustomAttribute = isCustomAttribute;
            this.changedFields = changedFields.add("IsCustomAttribute");
            return this;
        }

        public Builder isPrimaryId(Boolean isPrimaryId) {
            this.isPrimaryId = isPrimaryId;
            this.changedFields = changedFields.add("IsPrimaryId");
            return this;
        }

        public Builder isValidODataAttribute(Boolean isValidODataAttribute) {
            this.isValidODataAttribute = isValidODataAttribute;
            this.changedFields = changedFields.add("IsValidODataAttribute");
            return this;
        }

        public Builder isPrimaryName(Boolean isPrimaryName) {
            this.isPrimaryName = isPrimaryName;
            this.changedFields = changedFields.add("IsPrimaryName");
            return this;
        }

        public Builder isValidForCreate(Boolean isValidForCreate) {
            this.isValidForCreate = isValidForCreate;
            this.changedFields = changedFields.add("IsValidForCreate");
            return this;
        }

        public Builder isValidForRead(Boolean isValidForRead) {
            this.isValidForRead = isValidForRead;
            this.changedFields = changedFields.add("IsValidForRead");
            return this;
        }

        public Builder isValidForUpdate(Boolean isValidForUpdate) {
            this.isValidForUpdate = isValidForUpdate;
            this.changedFields = changedFields.add("IsValidForUpdate");
            return this;
        }

        public Builder canBeSecuredForRead(Boolean canBeSecuredForRead) {
            this.canBeSecuredForRead = canBeSecuredForRead;
            this.changedFields = changedFields.add("CanBeSecuredForRead");
            return this;
        }

        public Builder canBeSecuredForCreate(Boolean canBeSecuredForCreate) {
            this.canBeSecuredForCreate = canBeSecuredForCreate;
            this.changedFields = changedFields.add("CanBeSecuredForCreate");
            return this;
        }

        public Builder canBeSecuredForUpdate(Boolean canBeSecuredForUpdate) {
            this.canBeSecuredForUpdate = canBeSecuredForUpdate;
            this.changedFields = changedFields.add("CanBeSecuredForUpdate");
            return this;
        }

        public Builder isSecured(Boolean isSecured) {
            this.isSecured = isSecured;
            this.changedFields = changedFields.add("IsSecured");
            return this;
        }

        public Builder isRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
            this.changedFields = changedFields.add("IsRetrievable");
            return this;
        }

        public Builder isFilterable(Boolean isFilterable) {
            this.isFilterable = isFilterable;
            this.changedFields = changedFields.add("IsFilterable");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("IsSearchable");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder isGlobalFilterEnabled(BooleanManagedProperty isGlobalFilterEnabled) {
            this.isGlobalFilterEnabled = isGlobalFilterEnabled;
            this.changedFields = changedFields.add("IsGlobalFilterEnabled");
            return this;
        }

        public Builder isSortableEnabled(BooleanManagedProperty isSortableEnabled) {
            this.isSortableEnabled = isSortableEnabled;
            this.changedFields = changedFields.add("IsSortableEnabled");
            return this;
        }

        public Builder linkedAttributeId(UUID linkedAttributeId) {
            this.linkedAttributeId = linkedAttributeId;
            this.changedFields = changedFields.add("LinkedAttributeId");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = changedFields.add("LogicalName");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder isRenameable(BooleanManagedProperty isRenameable) {
            this.isRenameable = isRenameable;
            this.changedFields = changedFields.add("IsRenameable");
            return this;
        }

        public Builder isValidForAdvancedFind(BooleanManagedProperty isValidForAdvancedFind) {
            this.isValidForAdvancedFind = isValidForAdvancedFind;
            this.changedFields = changedFields.add("IsValidForAdvancedFind");
            return this;
        }

        public Builder isValidForForm(Boolean isValidForForm) {
            this.isValidForForm = isValidForForm;
            this.changedFields = changedFields.add("IsValidForForm");
            return this;
        }

        public Builder isRequiredForForm(Boolean isRequiredForForm) {
            this.isRequiredForForm = isRequiredForForm;
            this.changedFields = changedFields.add("IsRequiredForForm");
            return this;
        }

        public Builder isValidForGrid(Boolean isValidForGrid) {
            this.isValidForGrid = isValidForGrid;
            this.changedFields = changedFields.add("IsValidForGrid");
            return this;
        }

        public Builder requiredLevel(AttributeRequiredLevelManagedProperty requiredLevel) {
            this.requiredLevel = requiredLevel;
            this.changedFields = changedFields.add("RequiredLevel");
            return this;
        }

        public Builder canModifyAdditionalSettings(BooleanManagedProperty canModifyAdditionalSettings) {
            this.canModifyAdditionalSettings = canModifyAdditionalSettings;
            this.changedFields = changedFields.add("CanModifyAdditionalSettings");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = changedFields.add("SchemaName");
            return this;
        }

        public Builder externalName(String externalName) {
            this.externalName = externalName;
            this.changedFields = changedFields.add("ExternalName");
            return this;
        }

        public Builder isLogical(Boolean isLogical) {
            this.isLogical = isLogical;
            this.changedFields = changedFields.add("IsLogical");
            return this;
        }

        public Builder isDataSourceSecret(Boolean isDataSourceSecret) {
            this.isDataSourceSecret = isDataSourceSecret;
            this.changedFields = changedFields.add("IsDataSourceSecret");
            return this;
        }

        public Builder inheritsFrom(String inheritsFrom) {
            this.inheritsFrom = inheritsFrom;
            this.changedFields = changedFields.add("InheritsFrom");
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            this.createdOn = createdOn;
            this.changedFields = changedFields.add("CreatedOn");
            return this;
        }

        public Builder modifiedOn(OffsetDateTime modifiedOn) {
            this.modifiedOn = modifiedOn;
            this.changedFields = changedFields.add("ModifiedOn");
            return this;
        }

        public Builder sourceType(Integer sourceType) {
            this.sourceType = sourceType;
            this.changedFields = changedFields.add("SourceType");
            return this;
        }

        public Builder autoNumberFormat(String autoNumberFormat) {
            this.autoNumberFormat = autoNumberFormat;
            this.changedFields = changedFields.add("AutoNumberFormat");
            return this;
        }

        public AttributeMetadata build() {
            AttributeMetadata _x = new AttributeMetadata();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AttributeMetadata";
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            _x.attributeOf = attributeOf;
            _x.attributeType = attributeType;
            _x.attributeTypeName = attributeTypeName;
            _x.columnNumber = columnNumber;
            _x.description = description;
            _x.displayName = displayName;
            _x.deprecatedVersion = deprecatedVersion;
            _x.introducedVersion = introducedVersion;
            _x.entityLogicalName = entityLogicalName;
            _x.isAuditEnabled = isAuditEnabled;
            _x.isCustomAttribute = isCustomAttribute;
            _x.isPrimaryId = isPrimaryId;
            _x.isValidODataAttribute = isValidODataAttribute;
            _x.isPrimaryName = isPrimaryName;
            _x.isValidForCreate = isValidForCreate;
            _x.isValidForRead = isValidForRead;
            _x.isValidForUpdate = isValidForUpdate;
            _x.canBeSecuredForRead = canBeSecuredForRead;
            _x.canBeSecuredForCreate = canBeSecuredForCreate;
            _x.canBeSecuredForUpdate = canBeSecuredForUpdate;
            _x.isSecured = isSecured;
            _x.isRetrievable = isRetrievable;
            _x.isFilterable = isFilterable;
            _x.isSearchable = isSearchable;
            _x.isManaged = isManaged;
            _x.isGlobalFilterEnabled = isGlobalFilterEnabled;
            _x.isSortableEnabled = isSortableEnabled;
            _x.linkedAttributeId = linkedAttributeId;
            _x.logicalName = logicalName;
            _x.isCustomizable = isCustomizable;
            _x.isRenameable = isRenameable;
            _x.isValidForAdvancedFind = isValidForAdvancedFind;
            _x.isValidForForm = isValidForForm;
            _x.isRequiredForForm = isRequiredForForm;
            _x.isValidForGrid = isValidForGrid;
            _x.requiredLevel = requiredLevel;
            _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
            _x.schemaName = schemaName;
            _x.externalName = externalName;
            _x.isLogical = isLogical;
            _x.isDataSourceSecret = isDataSourceSecret;
            _x.inheritsFrom = inheritsFrom;
            _x.createdOn = createdOn;
            _x.modifiedOn = modifiedOn;
            _x.sourceType = sourceType;
            _x.autoNumberFormat = autoNumberFormat;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && metadataId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(metadataId, UUID.class));
        }
    }

    @Property(name="AttributeOf")
    @JsonIgnore
    public Optional<String> getAttributeOf() {
        return Optional.ofNullable(attributeOf);
    }

    public AttributeMetadata withAttributeOf(String attributeOf) {
        Checks.checkIsAscii(attributeOf);
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("AttributeOf");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.attributeOf = attributeOf;
        return _x;
    }

    @Property(name="AttributeType")
    @JsonIgnore
    public Optional<AttributeTypeCode> getAttributeType() {
        return Optional.ofNullable(attributeType);
    }

    public AttributeMetadata withAttributeType(AttributeTypeCode attributeType) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("AttributeType");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.attributeType = attributeType;
        return _x;
    }

    @Property(name="AttributeTypeName")
    @JsonIgnore
    public Optional<AttributeTypeDisplayName> getAttributeTypeName() {
        return Optional.ofNullable(attributeTypeName);
    }

    public AttributeMetadata withAttributeTypeName(AttributeTypeDisplayName attributeTypeName) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("AttributeTypeName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.attributeTypeName = attributeTypeName;
        return _x;
    }

    @Property(name="ColumnNumber")
    @JsonIgnore
    public Optional<Integer> getColumnNumber() {
        return Optional.ofNullable(columnNumber);
    }

    public AttributeMetadata withColumnNumber(Integer columnNumber) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("ColumnNumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.columnNumber = columnNumber;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<Label> getDescription() {
        return Optional.ofNullable(description);
    }

    public AttributeMetadata withDescription(Label description) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("Description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.description = description;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AttributeMetadata withDisplayName(Label displayName) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("DisplayName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="DeprecatedVersion")
    @JsonIgnore
    public Optional<String> getDeprecatedVersion() {
        return Optional.ofNullable(deprecatedVersion);
    }

    public AttributeMetadata withDeprecatedVersion(String deprecatedVersion) {
        Checks.checkIsAscii(deprecatedVersion);
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("DeprecatedVersion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.deprecatedVersion = deprecatedVersion;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(introducedVersion);
    }

    public AttributeMetadata withIntroducedVersion(String introducedVersion) {
        Checks.checkIsAscii(introducedVersion);
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IntroducedVersion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(entityLogicalName);
    }

    public AttributeMetadata withEntityLogicalName(String entityLogicalName) {
        Checks.checkIsAscii(entityLogicalName);
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("EntityLogicalName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="IsAuditEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsAuditEnabled() {
        return Optional.ofNullable(isAuditEnabled);
    }

    public AttributeMetadata withIsAuditEnabled(BooleanManagedProperty isAuditEnabled) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsAuditEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isAuditEnabled = isAuditEnabled;
        return _x;
    }

    @Property(name="IsCustomAttribute")
    @JsonIgnore
    public Optional<Boolean> getIsCustomAttribute() {
        return Optional.ofNullable(isCustomAttribute);
    }

    public AttributeMetadata withIsCustomAttribute(Boolean isCustomAttribute) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsCustomAttribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isCustomAttribute = isCustomAttribute;
        return _x;
    }

    @Property(name="IsPrimaryId")
    @JsonIgnore
    public Optional<Boolean> getIsPrimaryId() {
        return Optional.ofNullable(isPrimaryId);
    }

    public AttributeMetadata withIsPrimaryId(Boolean isPrimaryId) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsPrimaryId");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isPrimaryId = isPrimaryId;
        return _x;
    }

    @Property(name="IsValidODataAttribute")
    @JsonIgnore
    public Optional<Boolean> getIsValidODataAttribute() {
        return Optional.ofNullable(isValidODataAttribute);
    }

    public AttributeMetadata withIsValidODataAttribute(Boolean isValidODataAttribute) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsValidODataAttribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isValidODataAttribute = isValidODataAttribute;
        return _x;
    }

    @Property(name="IsPrimaryName")
    @JsonIgnore
    public Optional<Boolean> getIsPrimaryName() {
        return Optional.ofNullable(isPrimaryName);
    }

    public AttributeMetadata withIsPrimaryName(Boolean isPrimaryName) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsPrimaryName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isPrimaryName = isPrimaryName;
        return _x;
    }

    @Property(name="IsValidForCreate")
    @JsonIgnore
    public Optional<Boolean> getIsValidForCreate() {
        return Optional.ofNullable(isValidForCreate);
    }

    public AttributeMetadata withIsValidForCreate(Boolean isValidForCreate) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsValidForCreate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isValidForCreate = isValidForCreate;
        return _x;
    }

    @Property(name="IsValidForRead")
    @JsonIgnore
    public Optional<Boolean> getIsValidForRead() {
        return Optional.ofNullable(isValidForRead);
    }

    public AttributeMetadata withIsValidForRead(Boolean isValidForRead) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsValidForRead");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isValidForRead = isValidForRead;
        return _x;
    }

    @Property(name="IsValidForUpdate")
    @JsonIgnore
    public Optional<Boolean> getIsValidForUpdate() {
        return Optional.ofNullable(isValidForUpdate);
    }

    public AttributeMetadata withIsValidForUpdate(Boolean isValidForUpdate) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsValidForUpdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isValidForUpdate = isValidForUpdate;
        return _x;
    }

    @Property(name="CanBeSecuredForRead")
    @JsonIgnore
    public Optional<Boolean> getCanBeSecuredForRead() {
        return Optional.ofNullable(canBeSecuredForRead);
    }

    public AttributeMetadata withCanBeSecuredForRead(Boolean canBeSecuredForRead) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanBeSecuredForRead");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.canBeSecuredForRead = canBeSecuredForRead;
        return _x;
    }

    @Property(name="CanBeSecuredForCreate")
    @JsonIgnore
    public Optional<Boolean> getCanBeSecuredForCreate() {
        return Optional.ofNullable(canBeSecuredForCreate);
    }

    public AttributeMetadata withCanBeSecuredForCreate(Boolean canBeSecuredForCreate) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanBeSecuredForCreate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.canBeSecuredForCreate = canBeSecuredForCreate;
        return _x;
    }

    @Property(name="CanBeSecuredForUpdate")
    @JsonIgnore
    public Optional<Boolean> getCanBeSecuredForUpdate() {
        return Optional.ofNullable(canBeSecuredForUpdate);
    }

    public AttributeMetadata withCanBeSecuredForUpdate(Boolean canBeSecuredForUpdate) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanBeSecuredForUpdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.canBeSecuredForUpdate = canBeSecuredForUpdate;
        return _x;
    }

    @Property(name="IsSecured")
    @JsonIgnore
    public Optional<Boolean> getIsSecured() {
        return Optional.ofNullable(isSecured);
    }

    public AttributeMetadata withIsSecured(Boolean isSecured) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsSecured");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isSecured = isSecured;
        return _x;
    }

    @Property(name="IsRetrievable")
    @JsonIgnore
    public Optional<Boolean> getIsRetrievable() {
        return Optional.ofNullable(isRetrievable);
    }

    public AttributeMetadata withIsRetrievable(Boolean isRetrievable) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsRetrievable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isRetrievable = isRetrievable;
        return _x;
    }

    @Property(name="IsFilterable")
    @JsonIgnore
    public Optional<Boolean> getIsFilterable() {
        return Optional.ofNullable(isFilterable);
    }

    public AttributeMetadata withIsFilterable(Boolean isFilterable) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsFilterable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isFilterable = isFilterable;
        return _x;
    }

    @Property(name="IsSearchable")
    @JsonIgnore
    public Optional<Boolean> getIsSearchable() {
        return Optional.ofNullable(isSearchable);
    }

    public AttributeMetadata withIsSearchable(Boolean isSearchable) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsSearchable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isSearchable = isSearchable;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public AttributeMetadata withIsManaged(Boolean isManaged) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsManaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="IsGlobalFilterEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsGlobalFilterEnabled() {
        return Optional.ofNullable(isGlobalFilterEnabled);
    }

    public AttributeMetadata withIsGlobalFilterEnabled(BooleanManagedProperty isGlobalFilterEnabled) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsGlobalFilterEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isGlobalFilterEnabled = isGlobalFilterEnabled;
        return _x;
    }

    @Property(name="IsSortableEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsSortableEnabled() {
        return Optional.ofNullable(isSortableEnabled);
    }

    public AttributeMetadata withIsSortableEnabled(BooleanManagedProperty isSortableEnabled) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsSortableEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isSortableEnabled = isSortableEnabled;
        return _x;
    }

    @Property(name="LinkedAttributeId")
    @JsonIgnore
    public Optional<UUID> getLinkedAttributeId() {
        return Optional.ofNullable(linkedAttributeId);
    }

    public AttributeMetadata withLinkedAttributeId(UUID linkedAttributeId) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("LinkedAttributeId");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.linkedAttributeId = linkedAttributeId;
        return _x;
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(logicalName);
    }

    public AttributeMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii(logicalName);
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("LogicalName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public AttributeMetadata withIsCustomizable(BooleanManagedProperty isCustomizable) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsCustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="IsRenameable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsRenameable() {
        return Optional.ofNullable(isRenameable);
    }

    public AttributeMetadata withIsRenameable(BooleanManagedProperty isRenameable) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsRenameable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isRenameable = isRenameable;
        return _x;
    }

    @Property(name="IsValidForAdvancedFind")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsValidForAdvancedFind() {
        return Optional.ofNullable(isValidForAdvancedFind);
    }

    public AttributeMetadata withIsValidForAdvancedFind(BooleanManagedProperty isValidForAdvancedFind) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsValidForAdvancedFind");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        return _x;
    }

    @Property(name="IsValidForForm")
    @JsonIgnore
    public Optional<Boolean> getIsValidForForm() {
        return Optional.ofNullable(isValidForForm);
    }

    public AttributeMetadata withIsValidForForm(Boolean isValidForForm) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsValidForForm");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isValidForForm = isValidForForm;
        return _x;
    }

    @Property(name="IsRequiredForForm")
    @JsonIgnore
    public Optional<Boolean> getIsRequiredForForm() {
        return Optional.ofNullable(isRequiredForForm);
    }

    public AttributeMetadata withIsRequiredForForm(Boolean isRequiredForForm) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsRequiredForForm");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isRequiredForForm = isRequiredForForm;
        return _x;
    }

    @Property(name="IsValidForGrid")
    @JsonIgnore
    public Optional<Boolean> getIsValidForGrid() {
        return Optional.ofNullable(isValidForGrid);
    }

    public AttributeMetadata withIsValidForGrid(Boolean isValidForGrid) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsValidForGrid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isValidForGrid = isValidForGrid;
        return _x;
    }

    @Property(name="RequiredLevel")
    @JsonIgnore
    public Optional<AttributeRequiredLevelManagedProperty> getRequiredLevel() {
        return Optional.ofNullable(requiredLevel);
    }

    public AttributeMetadata withRequiredLevel(AttributeRequiredLevelManagedProperty requiredLevel) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("RequiredLevel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.requiredLevel = requiredLevel;
        return _x;
    }

    @Property(name="CanModifyAdditionalSettings")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanModifyAdditionalSettings() {
        return Optional.ofNullable(canModifyAdditionalSettings);
    }

    public AttributeMetadata withCanModifyAdditionalSettings(BooleanManagedProperty canModifyAdditionalSettings) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanModifyAdditionalSettings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
        return _x;
    }

    @Property(name="SchemaName")
    @JsonIgnore
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(schemaName);
    }

    public AttributeMetadata withSchemaName(String schemaName) {
        Checks.checkIsAscii(schemaName);
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("SchemaName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.schemaName = schemaName;
        return _x;
    }

    @Property(name="ExternalName")
    @JsonIgnore
    public Optional<String> getExternalName() {
        return Optional.ofNullable(externalName);
    }

    public AttributeMetadata withExternalName(String externalName) {
        Checks.checkIsAscii(externalName);
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("ExternalName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.externalName = externalName;
        return _x;
    }

    @Property(name="IsLogical")
    @JsonIgnore
    public Optional<Boolean> getIsLogical() {
        return Optional.ofNullable(isLogical);
    }

    public AttributeMetadata withIsLogical(Boolean isLogical) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsLogical");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isLogical = isLogical;
        return _x;
    }

    @Property(name="IsDataSourceSecret")
    @JsonIgnore
    public Optional<Boolean> getIsDataSourceSecret() {
        return Optional.ofNullable(isDataSourceSecret);
    }

    public AttributeMetadata withIsDataSourceSecret(Boolean isDataSourceSecret) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsDataSourceSecret");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.isDataSourceSecret = isDataSourceSecret;
        return _x;
    }

    @Property(name="InheritsFrom")
    @JsonIgnore
    public Optional<String> getInheritsFrom() {
        return Optional.ofNullable(inheritsFrom);
    }

    public AttributeMetadata withInheritsFrom(String inheritsFrom) {
        Checks.checkIsAscii(inheritsFrom);
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("InheritsFrom");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.inheritsFrom = inheritsFrom;
        return _x;
    }

    @Property(name="CreatedOn")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedOn() {
        return Optional.ofNullable(createdOn);
    }

    public AttributeMetadata withCreatedOn(OffsetDateTime createdOn) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("CreatedOn");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.createdOn = createdOn;
        return _x;
    }

    @Property(name="ModifiedOn")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedOn() {
        return Optional.ofNullable(modifiedOn);
    }

    public AttributeMetadata withModifiedOn(OffsetDateTime modifiedOn) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("ModifiedOn");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.modifiedOn = modifiedOn;
        return _x;
    }

    @Property(name="SourceType")
    @JsonIgnore
    public Optional<Integer> getSourceType() {
        return Optional.ofNullable(sourceType);
    }

    public AttributeMetadata withSourceType(Integer sourceType) {
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("SourceType");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.sourceType = sourceType;
        return _x;
    }

    @Property(name="AutoNumberFormat")
    @JsonIgnore
    public Optional<String> getAutoNumberFormat() {
        return Optional.ofNullable(autoNumberFormat);
    }

    public AttributeMetadata withAutoNumberFormat(String autoNumberFormat) {
        Checks.checkIsAscii(autoNumberFormat);
        AttributeMetadata _x = _copy();
        _x.changedFields = changedFields.add("AutoNumberFormat");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeMetadata");
        _x.autoNumberFormat = autoNumberFormat;
        return _x;
    }

    public AttributeMetadata withUnmappedField(String name, String value) {
        AttributeMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AttributeMetadata patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AttributeMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AttributeMetadata put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AttributeMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AttributeMetadata _copy() {
        AttributeMetadata _x = new AttributeMetadata();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        _x.attributeOf = attributeOf;
        _x.attributeType = attributeType;
        _x.attributeTypeName = attributeTypeName;
        _x.columnNumber = columnNumber;
        _x.description = description;
        _x.displayName = displayName;
        _x.deprecatedVersion = deprecatedVersion;
        _x.introducedVersion = introducedVersion;
        _x.entityLogicalName = entityLogicalName;
        _x.isAuditEnabled = isAuditEnabled;
        _x.isCustomAttribute = isCustomAttribute;
        _x.isPrimaryId = isPrimaryId;
        _x.isValidODataAttribute = isValidODataAttribute;
        _x.isPrimaryName = isPrimaryName;
        _x.isValidForCreate = isValidForCreate;
        _x.isValidForRead = isValidForRead;
        _x.isValidForUpdate = isValidForUpdate;
        _x.canBeSecuredForRead = canBeSecuredForRead;
        _x.canBeSecuredForCreate = canBeSecuredForCreate;
        _x.canBeSecuredForUpdate = canBeSecuredForUpdate;
        _x.isSecured = isSecured;
        _x.isRetrievable = isRetrievable;
        _x.isFilterable = isFilterable;
        _x.isSearchable = isSearchable;
        _x.isManaged = isManaged;
        _x.isGlobalFilterEnabled = isGlobalFilterEnabled;
        _x.isSortableEnabled = isSortableEnabled;
        _x.linkedAttributeId = linkedAttributeId;
        _x.logicalName = logicalName;
        _x.isCustomizable = isCustomizable;
        _x.isRenameable = isRenameable;
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        _x.isValidForForm = isValidForForm;
        _x.isRequiredForForm = isRequiredForForm;
        _x.isValidForGrid = isValidForGrid;
        _x.requiredLevel = requiredLevel;
        _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
        _x.schemaName = schemaName;
        _x.externalName = externalName;
        _x.isLogical = isLogical;
        _x.isDataSourceSecret = isDataSourceSecret;
        _x.inheritsFrom = inheritsFrom;
        _x.createdOn = createdOn;
        _x.modifiedOn = modifiedOn;
        _x.sourceType = sourceType;
        _x.autoNumberFormat = autoNumberFormat;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributeMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("AttributeOf=");
        b.append(this.attributeOf);
        b.append(", ");
        b.append("AttributeType=");
        b.append(this.attributeType);
        b.append(", ");
        b.append("AttributeTypeName=");
        b.append(this.attributeTypeName);
        b.append(", ");
        b.append("ColumnNumber=");
        b.append(this.columnNumber);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("DeprecatedVersion=");
        b.append(this.deprecatedVersion);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("IsAuditEnabled=");
        b.append(this.isAuditEnabled);
        b.append(", ");
        b.append("IsCustomAttribute=");
        b.append(this.isCustomAttribute);
        b.append(", ");
        b.append("IsPrimaryId=");
        b.append(this.isPrimaryId);
        b.append(", ");
        b.append("IsValidODataAttribute=");
        b.append(this.isValidODataAttribute);
        b.append(", ");
        b.append("IsPrimaryName=");
        b.append(this.isPrimaryName);
        b.append(", ");
        b.append("IsValidForCreate=");
        b.append(this.isValidForCreate);
        b.append(", ");
        b.append("IsValidForRead=");
        b.append(this.isValidForRead);
        b.append(", ");
        b.append("IsValidForUpdate=");
        b.append(this.isValidForUpdate);
        b.append(", ");
        b.append("CanBeSecuredForRead=");
        b.append(this.canBeSecuredForRead);
        b.append(", ");
        b.append("CanBeSecuredForCreate=");
        b.append(this.canBeSecuredForCreate);
        b.append(", ");
        b.append("CanBeSecuredForUpdate=");
        b.append(this.canBeSecuredForUpdate);
        b.append(", ");
        b.append("IsSecured=");
        b.append(this.isSecured);
        b.append(", ");
        b.append("IsRetrievable=");
        b.append(this.isRetrievable);
        b.append(", ");
        b.append("IsFilterable=");
        b.append(this.isFilterable);
        b.append(", ");
        b.append("IsSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsGlobalFilterEnabled=");
        b.append(this.isGlobalFilterEnabled);
        b.append(", ");
        b.append("IsSortableEnabled=");
        b.append(this.isSortableEnabled);
        b.append(", ");
        b.append("LinkedAttributeId=");
        b.append(this.linkedAttributeId);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("IsRenameable=");
        b.append(this.isRenameable);
        b.append(", ");
        b.append("IsValidForAdvancedFind=");
        b.append(this.isValidForAdvancedFind);
        b.append(", ");
        b.append("IsValidForForm=");
        b.append(this.isValidForForm);
        b.append(", ");
        b.append("IsRequiredForForm=");
        b.append(this.isRequiredForForm);
        b.append(", ");
        b.append("IsValidForGrid=");
        b.append(this.isValidForGrid);
        b.append(", ");
        b.append("RequiredLevel=");
        b.append(this.requiredLevel);
        b.append(", ");
        b.append("CanModifyAdditionalSettings=");
        b.append(this.canModifyAdditionalSettings);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("ExternalName=");
        b.append(this.externalName);
        b.append(", ");
        b.append("IsLogical=");
        b.append(this.isLogical);
        b.append(", ");
        b.append("IsDataSourceSecret=");
        b.append(this.isDataSourceSecret);
        b.append(", ");
        b.append("InheritsFrom=");
        b.append(this.inheritsFrom);
        b.append(", ");
        b.append("CreatedOn=");
        b.append(this.createdOn);
        b.append(", ");
        b.append("ModifiedOn=");
        b.append(this.modifiedOn);
        b.append(", ");
        b.append("SourceType=");
        b.append(this.sourceType);
        b.append(", ");
        b.append("AutoNumberFormat=");
        b.append(this.autoNumberFormat);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
