package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.AppmoduleRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "overwritetime", 
    "ismetadata", 
    "appmodulecomponentidunique", 
    "rootcomponentbehavior", 
    "introducedversion", 
    "rootappmodulecomponentid", 
    "_modifiedonbehalfby_value", 
    "timezoneruleversionnumber", 
    "createdon", 
    "versionnumber", 
    "exchangerate", 
    "modifiedon", 
    "utcconversiontimezonecode", 
    "isdefault", 
    "_createdonbehalfby_value", 
    "_modifiedby_value", 
    "objectid", 
    "componenttype", 
    "_createdby_value", 
    "appmodulecomponentid", 
    "_appmoduleidunique_value"})
@JsonInclude(Include.NON_NULL)
public class Appmodulecomponent extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.appmodulecomponent";
    }

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("ismetadata")
    protected Boolean ismetadata;

    @JsonProperty("appmodulecomponentidunique")
    protected UUID appmodulecomponentidunique;

    @JsonProperty("rootcomponentbehavior")
    protected Integer rootcomponentbehavior;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("rootappmodulecomponentid")
    protected UUID rootappmodulecomponentid;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("isdefault")
    protected Boolean isdefault;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("objectid")
    protected UUID objectid;

    @JsonProperty("componenttype")
    protected Integer componenttype;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("appmodulecomponentid")
    protected UUID appmodulecomponentid;

    @JsonProperty("_appmoduleidunique_value")
    protected UUID _appmoduleidunique_value;

    protected Appmodulecomponent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppmodulecomponent() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime overwritetime;
        private Boolean ismetadata;
        private UUID appmodulecomponentidunique;
        private Integer rootcomponentbehavior;
        private String introducedversion;
        private UUID rootappmodulecomponentid;
        private UUID _modifiedonbehalfby_value;
        private Integer timezoneruleversionnumber;
        private OffsetDateTime createdon;
        private Long versionnumber;
        private BigDecimal exchangerate;
        private OffsetDateTime modifiedon;
        private Integer utcconversiontimezonecode;
        private Boolean isdefault;
        private UUID _createdonbehalfby_value;
        private UUID _modifiedby_value;
        private UUID objectid;
        private Integer componenttype;
        private UUID _createdby_value;
        private UUID appmodulecomponentid;
        private UUID _appmoduleidunique_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder ismetadata(Boolean ismetadata) {
            this.ismetadata = ismetadata;
            this.changedFields = changedFields.add("ismetadata");
            return this;
        }

        public Builder appmodulecomponentidunique(UUID appmodulecomponentidunique) {
            this.appmodulecomponentidunique = appmodulecomponentidunique;
            this.changedFields = changedFields.add("appmodulecomponentidunique");
            return this;
        }

        public Builder rootcomponentbehavior(Integer rootcomponentbehavior) {
            this.rootcomponentbehavior = rootcomponentbehavior;
            this.changedFields = changedFields.add("rootcomponentbehavior");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder rootappmodulecomponentid(UUID rootappmodulecomponentid) {
            this.rootappmodulecomponentid = rootappmodulecomponentid;
            this.changedFields = changedFields.add("rootappmodulecomponentid");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder isdefault(Boolean isdefault) {
            this.isdefault = isdefault;
            this.changedFields = changedFields.add("isdefault");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder objectid(UUID objectid) {
            this.objectid = objectid;
            this.changedFields = changedFields.add("objectid");
            return this;
        }

        public Builder componenttype(Integer componenttype) {
            this.componenttype = componenttype;
            this.changedFields = changedFields.add("componenttype");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder appmodulecomponentid(UUID appmodulecomponentid) {
            this.appmodulecomponentid = appmodulecomponentid;
            this.changedFields = changedFields.add("appmodulecomponentid");
            return this;
        }

        public Builder _appmoduleidunique_value(UUID _appmoduleidunique_value) {
            this._appmoduleidunique_value = _appmoduleidunique_value;
            this.changedFields = changedFields.add("_appmoduleidunique_value");
            return this;
        }

        public Appmodulecomponent build() {
            Appmodulecomponent _x = new Appmodulecomponent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.appmodulecomponent";
            _x.overwritetime = overwritetime;
            _x.ismetadata = ismetadata;
            _x.appmodulecomponentidunique = appmodulecomponentidunique;
            _x.rootcomponentbehavior = rootcomponentbehavior;
            _x.introducedversion = introducedversion;
            _x.rootappmodulecomponentid = rootappmodulecomponentid;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.createdon = createdon;
            _x.versionnumber = versionnumber;
            _x.exchangerate = exchangerate;
            _x.modifiedon = modifiedon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.isdefault = isdefault;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.objectid = objectid;
            _x.componenttype = componenttype;
            _x._createdby_value = _createdby_value;
            _x.appmodulecomponentid = appmodulecomponentid;
            _x._appmoduleidunique_value = _appmoduleidunique_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && appmodulecomponentid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(appmodulecomponentid, UUID.class));
        }
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Appmodulecomponent withOverwritetime(OffsetDateTime overwritetime) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="ismetadata")
    @JsonIgnore
    public Optional<Boolean> getIsmetadata() {
        return Optional.ofNullable(ismetadata);
    }

    public Appmodulecomponent withIsmetadata(Boolean ismetadata) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("ismetadata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.ismetadata = ismetadata;
        return _x;
    }

    @Property(name="appmodulecomponentidunique")
    @JsonIgnore
    public Optional<UUID> getAppmodulecomponentidunique() {
        return Optional.ofNullable(appmodulecomponentidunique);
    }

    public Appmodulecomponent withAppmodulecomponentidunique(UUID appmodulecomponentidunique) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("appmodulecomponentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.appmodulecomponentidunique = appmodulecomponentidunique;
        return _x;
    }

    @Property(name="rootcomponentbehavior")
    @JsonIgnore
    public Optional<Integer> getRootcomponentbehavior() {
        return Optional.ofNullable(rootcomponentbehavior);
    }

    public Appmodulecomponent withRootcomponentbehavior(Integer rootcomponentbehavior) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("rootcomponentbehavior");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.rootcomponentbehavior = rootcomponentbehavior;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Appmodulecomponent withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="rootappmodulecomponentid")
    @JsonIgnore
    public Optional<UUID> getRootappmodulecomponentid() {
        return Optional.ofNullable(rootappmodulecomponentid);
    }

    public Appmodulecomponent withRootappmodulecomponentid(UUID rootappmodulecomponentid) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("rootappmodulecomponentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.rootappmodulecomponentid = rootappmodulecomponentid;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Appmodulecomponent with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Appmodulecomponent withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Appmodulecomponent withCreatedon(OffsetDateTime createdon) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Appmodulecomponent withVersionnumber(Long versionnumber) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Appmodulecomponent withExchangerate(BigDecimal exchangerate) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Appmodulecomponent withModifiedon(OffsetDateTime modifiedon) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Appmodulecomponent withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="isdefault")
    @JsonIgnore
    public Optional<Boolean> getIsdefault() {
        return Optional.ofNullable(isdefault);
    }

    public Appmodulecomponent withIsdefault(Boolean isdefault) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("isdefault");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.isdefault = isdefault;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Appmodulecomponent with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Appmodulecomponent with_modifiedby_value(UUID _modifiedby_value) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="objectid")
    @JsonIgnore
    public Optional<UUID> getObjectid() {
        return Optional.ofNullable(objectid);
    }

    public Appmodulecomponent withObjectid(UUID objectid) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("objectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.objectid = objectid;
        return _x;
    }

    @Property(name="componenttype")
    @JsonIgnore
    public Optional<Integer> getComponenttype() {
        return Optional.ofNullable(componenttype);
    }

    public Appmodulecomponent withComponenttype(Integer componenttype) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("componenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.componenttype = componenttype;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Appmodulecomponent with_createdby_value(UUID _createdby_value) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="appmodulecomponentid")
    @JsonIgnore
    public Optional<UUID> getAppmodulecomponentid() {
        return Optional.ofNullable(appmodulecomponentid);
    }

    public Appmodulecomponent withAppmodulecomponentid(UUID appmodulecomponentid) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("appmodulecomponentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x.appmodulecomponentid = appmodulecomponentid;
        return _x;
    }

    @Property(name="_appmoduleidunique_value")
    @JsonIgnore
    public Optional<UUID> get_appmoduleidunique_value() {
        return Optional.ofNullable(_appmoduleidunique_value);
    }

    public Appmodulecomponent with_appmoduleidunique_value(UUID _appmoduleidunique_value) {
        Appmodulecomponent _x = _copy();
        _x.changedFields = changedFields.add("_appmoduleidunique_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodulecomponent");
        _x._appmoduleidunique_value = _appmoduleidunique_value;
        return _x;
    }

    public Appmodulecomponent withUnmappedField(String name, String value) {
        Appmodulecomponent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="appmodulecomponent_modifiedby")
    @JsonIgnore
    public SystemuserRequest getAppmodulecomponent_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("appmodulecomponent_modifiedby"), RequestHelper.getValue(unmappedFields, "appmodulecomponent_modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="appmodulecomponent_createdby")
    @JsonIgnore
    public SystemuserRequest getAppmodulecomponent_createdby() {
        return new SystemuserRequest(contextPath.addSegment("appmodulecomponent_createdby"), RequestHelper.getValue(unmappedFields, "appmodulecomponent_createdby"));
    }

    @NavigationProperty(name="appmoduleid")
    @JsonIgnore
    public AppmoduleRequest getAppmoduleid() {
        return new AppmoduleRequest(contextPath.addSegment("appmoduleid"), RequestHelper.getValue(unmappedFields, "appmoduleid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appmodulecomponent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Appmodulecomponent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appmodulecomponent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Appmodulecomponent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Appmodulecomponent _copy() {
        Appmodulecomponent _x = new Appmodulecomponent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.overwritetime = overwritetime;
        _x.ismetadata = ismetadata;
        _x.appmodulecomponentidunique = appmodulecomponentidunique;
        _x.rootcomponentbehavior = rootcomponentbehavior;
        _x.introducedversion = introducedversion;
        _x.rootappmodulecomponentid = rootappmodulecomponentid;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.createdon = createdon;
        _x.versionnumber = versionnumber;
        _x.exchangerate = exchangerate;
        _x.modifiedon = modifiedon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.isdefault = isdefault;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.objectid = objectid;
        _x.componenttype = componenttype;
        _x._createdby_value = _createdby_value;
        _x.appmodulecomponentid = appmodulecomponentid;
        _x._appmoduleidunique_value = _appmoduleidunique_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Appmodulecomponent[");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("ismetadata=");
        b.append(this.ismetadata);
        b.append(", ");
        b.append("appmodulecomponentidunique=");
        b.append(this.appmodulecomponentidunique);
        b.append(", ");
        b.append("rootcomponentbehavior=");
        b.append(this.rootcomponentbehavior);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("rootappmodulecomponentid=");
        b.append(this.rootappmodulecomponentid);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("isdefault=");
        b.append(this.isdefault);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("objectid=");
        b.append(this.objectid);
        b.append(", ");
        b.append("componenttype=");
        b.append(this.componenttype);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("appmodulecomponentid=");
        b.append(this.appmodulecomponentid);
        b.append(", ");
        b.append("_appmoduleidunique_value=");
        b.append(this._appmoduleidunique_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
