package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "ResourceSpecId", 
    "ObjectiveExpression"})
@JsonInclude(Include.NON_NULL)
public class ObjectiveRelation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ResourceSpecId")
    protected UUID resourceSpecId;

    @JsonProperty("ObjectiveExpression")
    protected String objectiveExpression;

    protected ObjectiveRelation() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ObjectiveRelation";
    }

    @Property(name="ResourceSpecId")
    @JsonIgnore
    public Optional<UUID> getResourceSpecId() {
        return Optional.ofNullable(resourceSpecId);
    }

    public ObjectiveRelation withResourceSpecId(UUID resourceSpecId) {
        ObjectiveRelation _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ObjectiveRelation");
        _x.resourceSpecId = resourceSpecId;
        return _x;
    }

    @Property(name="ObjectiveExpression")
    @JsonIgnore
    public Optional<String> getObjectiveExpression() {
        return Optional.ofNullable(objectiveExpression);
    }

    public ObjectiveRelation withObjectiveExpression(String objectiveExpression) {
        Checks.checkIsAscii(objectiveExpression);
        ObjectiveRelation _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ObjectiveRelation");
        _x.objectiveExpression = objectiveExpression;
        return _x;
    }

    public ObjectiveRelation withUnmappedField(String name, String value) {
        ObjectiveRelation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID resourceSpecId;
        private String objectiveExpression;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder resourceSpecId(UUID resourceSpecId) {
            this.resourceSpecId = resourceSpecId;
            this.changedFields = changedFields.add("ResourceSpecId");
            return this;
        }

        public Builder objectiveExpression(String objectiveExpression) {
            this.objectiveExpression = objectiveExpression;
            this.changedFields = changedFields.add("ObjectiveExpression");
            return this;
        }

        public ObjectiveRelation build() {
            ObjectiveRelation _x = new ObjectiveRelation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ObjectiveRelation";
            _x.resourceSpecId = resourceSpecId;
            _x.objectiveExpression = objectiveExpression;
            return _x;
        }
    }

    private ObjectiveRelation _copy() {
        ObjectiveRelation _x = new ObjectiveRelation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.resourceSpecId = resourceSpecId;
        _x.objectiveExpression = objectiveExpression;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ObjectiveRelation[");
        b.append("ResourceSpecId=");
        b.append(this.resourceSpecId);
        b.append(", ");
        b.append("ObjectiveExpression=");
        b.append(this.objectiveExpression);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
