package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AppElementInfoCollection"})
@JsonInclude(Include.NON_NULL)
public class AppElementsCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AppElementInfoCollection")
    protected List<AppElementInfo> appElementInfoCollection;

    @JsonProperty("AppElementInfoCollection@nextLink")
    protected String appElementInfoCollectionNextLink;

    protected AppElementsCollection() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppElementsCollection";
    }

    @Property(name="AppElementInfoCollection")
    @JsonIgnore
    public CollectionPage<AppElementInfo> getAppElementInfoCollection() {
        return new CollectionPage<AppElementInfo>(contextPath, AppElementInfo.class, this.appElementInfoCollection, Optional.ofNullable(appElementInfoCollectionNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AppElementInfoCollection")
    @JsonIgnore
    public CollectionPage<AppElementInfo> getAppElementInfoCollection(HttpRequestOptions options) {
        return new CollectionPage<AppElementInfo>(contextPath, AppElementInfo.class, this.appElementInfoCollection, Optional.ofNullable(appElementInfoCollectionNextLink), Collections.emptyList(), options);
    }

    public AppElementsCollection withUnmappedField(String name, String value) {
        AppElementsCollection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AppElementInfo> appElementInfoCollection;
        private String appElementInfoCollectionNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appElementInfoCollection(List<AppElementInfo> appElementInfoCollection) {
            this.appElementInfoCollection = appElementInfoCollection;
            this.changedFields = changedFields.add("AppElementInfoCollection");
            return this;
        }

        public Builder appElementInfoCollection(AppElementInfo... appElementInfoCollection) {
            return appElementInfoCollection(Arrays.asList(appElementInfoCollection));
        }

        public Builder appElementInfoCollectionNextLink(String appElementInfoCollectionNextLink) {
            this.appElementInfoCollectionNextLink = appElementInfoCollectionNextLink;
            this.changedFields = changedFields.add("AppElementInfoCollection");
            return this;
        }

        public AppElementsCollection build() {
            AppElementsCollection _x = new AppElementsCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppElementsCollection";
            _x.appElementInfoCollection = appElementInfoCollection;
            _x.appElementInfoCollectionNextLink = appElementInfoCollectionNextLink;
            return _x;
        }
    }

    private AppElementsCollection _copy() {
        AppElementsCollection _x = new AppElementsCollection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appElementInfoCollection = appElementInfoCollection;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppElementsCollection[");
        b.append("AppElementInfoCollection=");
        b.append(this.appElementInfoCollection);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
