package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RollupType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Related")
    RELATED("Related", "1"),

    @JsonProperty("Extended")
    EXTENDED("Extended", "2");

    private final String name;
    private final String value;

    private RollupType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
