package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DependencyDepth implements Enum {

    @JsonProperty("Unknown")
    UNKNOWN("Unknown", "0"),

    @JsonProperty("OnDemandWithContext")
    ON_DEMAND_WITH_CONTEXT("OnDemandWithContext", "1"),

    @JsonProperty("OnDemandWithoutContext")
    ON_DEMAND_WITHOUT_CONTEXT("OnDemandWithoutContext", "2"),

    @JsonProperty("OnDemandContextOnly")
    ON_DEMAND_CONTEXT_ONLY("OnDemandContextOnly", "3"),

    @JsonProperty("Offline")
    OFFLINE("Offline", "4"),

    @JsonProperty("Mobile")
    MOBILE("Mobile", "5"),

    @JsonProperty("UserContext")
    USER_CONTEXT("UserContext", "6");

    private final String name;
    private final String value;

    private DependencyDepth(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
