package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AssociatedMenuBehavior implements Enum {

    @JsonProperty("UseCollectionName")
    USE_COLLECTION_NAME("UseCollectionName", "0"),

    @JsonProperty("UseLabel")
    USE_LABEL("UseLabel", "1"),

    @JsonProperty("DoNotDisplay")
    DO_NOT_DISPLAY("DoNotDisplay", "2");

    private final String name;
    private final String value;

    private AssociatedMenuBehavior(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
