package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Workflowbinary;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class WorkflowbinaryRequest extends EntityRequest<Workflowbinary> {

    public WorkflowbinaryRequest(ContextPath contextPath, Optional<Object> value) {
        super(Workflowbinary.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorRequest workflowbinary_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("workflowbinary_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest workflowbinary_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("workflowbinary_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest workflowbinary_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("workflowbinary_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest workflowbinary_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("workflowbinary_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest workflowbinary_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("workflowbinary_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest workflowbinary_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("workflowbinary_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest workflowbinary_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("workflowbinary_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest workflowbinary_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("workflowbinary_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest workflowbinary_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("workflowbinary_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest workflowbinary_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("workflowbinary_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest workflowbinary_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("workflowbinary_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest workflowbinary_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("workflowbinary_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public FileattachmentRequest workflowbinary_FileAttachments(UUID fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("workflowbinary_FileAttachments").addKeys(new NameValue(fileattachmentid, UUID.class)), Optional.empty());
    }

    public FileattachmentCollectionRequest workflowbinary_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("workflowbinary_FileAttachments"), Optional.empty());
    }

    public FlowsessionRequest flowSessionId() {
        return new FlowsessionRequest(contextPath.addSegment("FlowSessionId"), Optional.empty());
    }

    public WorkflowRequest process() {
        return new WorkflowRequest(contextPath.addSegment("Process"), Optional.empty());
    }

}
