package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Transformationmapping;
import microsoft.dynamics.crm.entity.collection.request.TransformationparametermappingCollectionRequest;

@JsonIgnoreType
public class TransformationmappingRequest extends EntityRequest<Transformationmapping> {

    public TransformationmappingRequest(ContextPath contextPath, Optional<Object> value) {
        super(Transformationmapping.class, contextPath, value, false);
    }

    public TransformationparametermappingRequest transformationParameterMapping_TransformationMapping(UUID transformationparametermappingid) {
        return new TransformationparametermappingRequest(contextPath.addSegment("TransformationParameterMapping_TransformationMapping").addKeys(new NameValue(transformationparametermappingid, UUID.class)), Optional.empty());
    }

    public TransformationparametermappingCollectionRequest transformationParameterMapping_TransformationMapping() {
        return new TransformationparametermappingCollectionRequest(
                        contextPath.addSegment("TransformationParameterMapping_TransformationMapping"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public ImportmapRequest importmapid() {
        return new ImportmapRequest(contextPath.addSegment("importmapid"), Optional.empty());
    }

}
