package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Timezonedefinition;
import microsoft.dynamics.crm.entity.collection.request.TimezonelocalizednameCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TimezoneruleCollectionRequest;

@JsonIgnoreType
public class TimezonedefinitionRequest extends EntityRequest<Timezonedefinition> {

    public TimezonedefinitionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Timezonedefinition.class, contextPath, value, false);
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public TimezonelocalizednameRequest lk_timezonelocalizedname_timezonedefinitionid(UUID timezonelocalizednameid) {
        return new TimezonelocalizednameRequest(contextPath.addSegment("lk_timezonelocalizedname_timezonedefinitionid").addKeys(new NameValue(timezonelocalizednameid, UUID.class)), Optional.empty());
    }

    public TimezonelocalizednameCollectionRequest lk_timezonelocalizedname_timezonedefinitionid() {
        return new TimezonelocalizednameCollectionRequest(
                        contextPath.addSegment("lk_timezonelocalizedname_timezonedefinitionid"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public TimezoneruleRequest lk_timezonerule_timezonedefinitionid(UUID timezoneruleid) {
        return new TimezoneruleRequest(contextPath.addSegment("lk_timezonerule_timezonedefinitionid").addKeys(new NameValue(timezoneruleid, UUID.class)), Optional.empty());
    }

    public TimezoneruleCollectionRequest lk_timezonerule_timezonedefinitionid() {
        return new TimezoneruleCollectionRequest(
                        contextPath.addSegment("lk_timezonerule_timezonedefinitionid"), Optional.empty());
    }

}
