package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.RetrieveAbsoluteAndSiteCollectionUrlResponse;
import microsoft.dynamics.crm.entity.Sharepointsite;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointsiteCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class SharepointsiteRequest extends EntityRequest<Sharepointsite> {

    public SharepointsiteRequest(ContextPath contextPath, Optional<Object> value) {
        super(Sharepointsite.class, contextPath, value, false);
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public ProcesssessionRequest sharePointSite_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("SharePointSite_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest sharePointSite_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("SharePointSite_ProcessSessions"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public DuplicaterecordRequest sharePointSite_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SharePointSite_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest sharePointSite_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SharePointSite_DuplicateMatchingRecord"), Optional.empty());
    }

    public SharepointsiteRequest parentsite() {
        return new SharepointsiteRequest(contextPath.addSegment("parentsite"), Optional.empty());
    }

    public SharepointsiteRequest sharepointsite_parentsite_sharepointsite(UUID sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("sharepointsite_parentsite_sharepointsite").addKeys(new NameValue(sharepointsiteid, UUID.class)), Optional.empty());
    }

    public SharepointsiteCollectionRequest sharepointsite_parentsite_sharepointsite() {
        return new SharepointsiteCollectionRequest(
                        contextPath.addSegment("sharepointsite_parentsite_sharepointsite"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest sharepointsite_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("sharepointsite_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest sharepointsite_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("sharepointsite_principalobjectattributeaccess"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public DuplicaterecordRequest sharePointSite_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SharePointSite_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest sharePointSite_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SharePointSite_DuplicateBaseRecord"), Optional.empty());
    }

    public SharepointdocumentlocationRequest sharepointdocumentlocation_parent_sharepointsite(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("sharepointdocumentlocation_parent_sharepointsite").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest sharepointdocumentlocation_parent_sharepointsite() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("sharepointdocumentlocation_parent_sharepointsite"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public AsyncoperationRequest sharePointSite_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SharePointSite_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest sharePointSite_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SharePointSite_AsyncOperations"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SyncerrorRequest sharePointSite_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SharePointSite_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest sharePointSite_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SharePointSite_SyncErrors"), Optional.empty());
    }

    @Function(name = "RetrieveAbsoluteAndSiteCollectionUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAbsoluteAndSiteCollectionUrlResponse> retrieveAbsoluteAndSiteCollectionUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAbsoluteAndSiteCollectionUrlResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAbsoluteAndSiteCollectionUrl"), RetrieveAbsoluteAndSiteCollectionUrlResponse.class, _parameters);
    }

}
