package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Sdkmessageprocessingstep;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepimageCollectionRequest;

@JsonIgnoreType
public class SdkmessageprocessingstepRequest extends EntityRequest<Sdkmessageprocessingstep> {

    public SdkmessageprocessingstepRequest(ContextPath contextPath, Optional<Object> value) {
        super(Sdkmessageprocessingstep.class, contextPath, value, false);
    }

    public SdkmessageprocessingstepsecureconfigRequest sdkmessageprocessingstepsecureconfigid() {
        return new SdkmessageprocessingstepsecureconfigRequest(contextPath.addSegment("sdkmessageprocessingstepsecureconfigid"), Optional.empty());
    }

    public SdkmessageRequest sdkmessageid() {
        return new SdkmessageRequest(contextPath.addSegment("sdkmessageid"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SdkmessagefilterRequest sdkmessagefilterid() {
        return new SdkmessagefilterRequest(contextPath.addSegment("sdkmessagefilterid"), Optional.empty());
    }

    public SystemuserRequest impersonatinguserid() {
        return new SystemuserRequest(contextPath.addSegment("impersonatinguserid"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public PlugintypeRequest plugintypeid() {
        return new PlugintypeRequest(contextPath.addSegment("plugintypeid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public PlugintypeRequest eventhandler_plugintype() {
        return new PlugintypeRequest(contextPath.addSegment("eventhandler_plugintype"), Optional.empty());
    }

    public AsyncoperationRequest sdkMessageProcessingStep_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SdkMessageProcessingStep_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest sdkMessageProcessingStep_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SdkMessageProcessingStep_AsyncOperations"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SdkmessageprocessingstepimageRequest sdkmessageprocessingstepid_sdkmessageprocessingstepimage(UUID sdkmessageprocessingstepimageid) {
        return new SdkmessageprocessingstepimageRequest(contextPath.addSegment("sdkmessageprocessingstepid_sdkmessageprocessingstepimage").addKeys(new NameValue(sdkmessageprocessingstepimageid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepimageCollectionRequest sdkmessageprocessingstepid_sdkmessageprocessingstepimage() {
        return new SdkmessageprocessingstepimageCollectionRequest(
                        contextPath.addSegment("sdkmessageprocessingstepid_sdkmessageprocessingstepimage"), Optional.empty());
    }

    public ServiceendpointRequest eventhandler_serviceendpoint() {
        return new ServiceendpointRequest(contextPath.addSegment("eventhandler_serviceendpoint"), Optional.empty());
    }

}
