package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Sdkmessage;
import microsoft.dynamics.crm.entity.collection.request.SdkmessagefilterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepCollectionRequest;

@JsonIgnoreType
public class SdkmessageRequest extends EntityRequest<Sdkmessage> {

    public SdkmessageRequest(ContextPath contextPath, Optional<Object> value) {
        super(Sdkmessage.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest sdkmessageid_sdkmessageprocessingstep(UUID sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("sdkmessageid_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest sdkmessageid_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("sdkmessageid_sdkmessageprocessingstep"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SdkmessagefilterRequest sdkmessageid_sdkmessagefilter(UUID sdkmessagefilterid) {
        return new SdkmessagefilterRequest(contextPath.addSegment("sdkmessageid_sdkmessagefilter").addKeys(new NameValue(sdkmessagefilterid, UUID.class)), Optional.empty());
    }

    public SdkmessagefilterCollectionRequest sdkmessageid_sdkmessagefilter() {
        return new SdkmessagefilterCollectionRequest(
                        contextPath.addSegment("sdkmessageid_sdkmessagefilter"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

}
