package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Relationship;
import microsoft.dynamics.crm.entity.collection.request.RelationshipattributeCollectionRequest;

@JsonIgnoreType
public class RelationshipRequest extends EntityRequest<Relationship> {

    public RelationshipRequest(ContextPath contextPath, Optional<Object> value) {
        super(Relationship.class, contextPath, value, false);
    }

    public RelationshipattributeRequest relationship_relationshipattribute(UUID relationshipattributeid) {
        return new RelationshipattributeRequest(contextPath.addSegment("relationship_relationshipattribute").addKeys(new NameValue(relationshipattributeid, UUID.class)), Optional.empty());
    }

    public RelationshipattributeCollectionRequest relationship_relationshipattribute() {
        return new RelationshipattributeCollectionRequest(
                        contextPath.addSegment("relationship_relationshipattribute"), Optional.empty());
    }

}
