package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Postfollow;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class PostfollowRequest extends EntityRequest<Postfollow> {

    public PostfollowRequest(ContextPath contextPath, Optional<Object> value) {
        super(Postfollow.class, contextPath, value, false);
    }

    public TaskRequest regardingobjectid_task() {
        return new TaskRequest(contextPath.addSegment("regardingobjectid_task"), Optional.empty());
    }

    public AppointmentRequest regardingobjectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("regardingobjectid_appointment"), Optional.empty());
    }

    public PhonecallRequest regardingobjectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("regardingobjectid_phonecall"), Optional.empty());
    }

    public RecurringappointmentmasterRequest regardingobjectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("regardingobjectid_recurringappointmentmaster"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public AccountRequest regardingobjectid_account() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account"), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact"), Optional.empty());
    }

    public SystemuserRequest regardingobjectid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("regardingobjectid_systemuser"), Optional.empty());
    }

    public AsyncoperationRequest postFollow_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("PostFollow_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest postFollow_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("PostFollow_AsyncOperations"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public QueueRequest regardingobjectid_queue() {
        return new QueueRequest(contextPath.addSegment("regardingobjectid_queue"), Optional.empty());
    }

    public SyncerrorRequest postFollow_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("PostFollow_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest postFollow_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("PostFollow_SyncErrors"), Optional.empty());
    }

    public ProcesssessionRequest regardingobjectid_processsession() {
        return new ProcesssessionRequest(contextPath.addSegment("regardingobjectid_processsession"), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), Optional.empty());
    }

}
