package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Organization;
import microsoft.dynamics.crm.entity.collection.request.AciviewmapperCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppconfiginstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppconfigmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppmoduleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BusinessunitCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BusinessunitnewsarticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ComplexcontrolCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionroleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomcontrolCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomcontroldefaultconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomcontrolresourceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DatalakeworkspaceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DatalakeworkspacepermissionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DataperformanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DisplaystringCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DocumenttemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailserverprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EntityanalyticsconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExpiredprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FieldsecurityprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportjobCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticletemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgebaserecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LanguagelocaleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MetricCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemassociationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_helppageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthrulesetCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.NavigationsettingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.NewprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OfficegraphdocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PluginassemblyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PlugintypeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PlugintypestatisticCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PositionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostcommentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostlikeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PublisherCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecommendeddocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SavedqueryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SavedqueryvisualizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessagefilterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepsecureconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ServiceendpointCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SimilarityruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SitemapCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentattributeconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentrelationshipconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SubjectCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemformCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TerritoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ThemeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TracelogCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TransactioncurrencyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TranslationprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UsermappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WebresourceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WebwizardCollectionRequest;

@JsonIgnoreType
public class OrganizationRequest extends EntityRequest<Organization> {

    public OrganizationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Organization.class, contextPath, value, false);
    }

    public PrincipalobjectattributeaccessRequest lk_principalobjectattributeaccess_organizationid(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("lk_principalobjectattributeaccess_organizationid").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest lk_principalobjectattributeaccess_organizationid() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("lk_principalobjectattributeaccess_organizationid"), Optional.empty());
    }

    public ThemeRequest organization_theme(UUID themeid) {
        return new ThemeRequest(contextPath.addSegment("organization_theme").addKeys(new NameValue(themeid, UUID.class)), Optional.empty());
    }

    public ThemeCollectionRequest organization_theme() {
        return new ThemeCollectionRequest(
                        contextPath.addSegment("organization_theme"), Optional.empty());
    }

    public UsermappingRequest organization_UserMapping(UUID usermappingid) {
        return new UsermappingRequest(contextPath.addSegment("organization_UserMapping").addKeys(new NameValue(usermappingid, UUID.class)), Optional.empty());
    }

    public UsermappingCollectionRequest organization_UserMapping() {
        return new UsermappingCollectionRequest(
                        contextPath.addSegment("organization_UserMapping"), Optional.empty());
    }

    public MetricRequest organization_metric(UUID metricid) {
        return new MetricRequest(contextPath.addSegment("organization_metric").addKeys(new NameValue(metricid, UUID.class)), Optional.empty());
    }

    public MetricCollectionRequest organization_metric() {
        return new MetricCollectionRequest(
                        contextPath.addSegment("organization_metric"), Optional.empty());
    }

    public PositionRequest organization_position(UUID positionid) {
        return new PositionRequest(contextPath.addSegment("organization_position").addKeys(new NameValue(positionid, UUID.class)), Optional.empty());
    }

    public PositionCollectionRequest organization_position() {
        return new PositionCollectionRequest(
                        contextPath.addSegment("organization_position"), Optional.empty());
    }

    public OfficegraphdocumentRequest organization_officegraphdocument(UUID officegraphdocumentid) {
        return new OfficegraphdocumentRequest(contextPath.addSegment("organization_officegraphdocument").addKeys(new NameValue(officegraphdocumentid, UUID.class)), Optional.empty());
    }

    public OfficegraphdocumentCollectionRequest organization_officegraphdocument() {
        return new OfficegraphdocumentCollectionRequest(
                        contextPath.addSegment("organization_officegraphdocument"), Optional.empty());
    }

    public RecommendeddocumentRequest organization_recommendeddocument(UUID recommendeddocumentid) {
        return new RecommendeddocumentRequest(contextPath.addSegment("organization_recommendeddocument").addKeys(new NameValue(recommendeddocumentid, UUID.class)), Optional.empty());
    }

    public RecommendeddocumentCollectionRequest organization_recommendeddocument() {
        return new RecommendeddocumentCollectionRequest(
                        contextPath.addSegment("organization_recommendeddocument"), Optional.empty());
    }

    public KnowledgebaserecordRequest organization_KnowledgeBaseRecord(UUID knowledgebaserecordid) {
        return new KnowledgebaserecordRequest(contextPath.addSegment("organization_KnowledgeBaseRecord").addKeys(new NameValue(knowledgebaserecordid, UUID.class)), Optional.empty());
    }

    public KnowledgebaserecordCollectionRequest organization_KnowledgeBaseRecord() {
        return new KnowledgebaserecordCollectionRequest(
                        contextPath.addSegment("organization_KnowledgeBaseRecord"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SdkmessagefilterRequest organization_sdkmessagefilter(UUID sdkmessagefilterid) {
        return new SdkmessagefilterRequest(contextPath.addSegment("organization_sdkmessagefilter").addKeys(new NameValue(sdkmessagefilterid, UUID.class)), Optional.empty());
    }

    public SdkmessagefilterCollectionRequest organization_sdkmessagefilter() {
        return new SdkmessagefilterCollectionRequest(
                        contextPath.addSegment("organization_sdkmessagefilter"), Optional.empty());
    }

    public WebresourceRequest webresource_organization(UUID webresourceid) {
        return new WebresourceRequest(contextPath.addSegment("webresource_organization").addKeys(new NameValue(webresourceid, UUID.class)), Optional.empty());
    }

    public WebresourceCollectionRequest webresource_organization() {
        return new WebresourceCollectionRequest(
                        contextPath.addSegment("webresource_organization"), Optional.empty());
    }

    public PostRequest organization_post(UUID postid) {
        return new PostRequest(contextPath.addSegment("organization_post").addKeys(new NameValue(postid, UUID.class)), Optional.empty());
    }

    public PostCollectionRequest organization_post() {
        return new PostCollectionRequest(
                        contextPath.addSegment("organization_post"), Optional.empty());
    }

    public PostcommentRequest organization_PostComment(UUID postcommentid) {
        return new PostcommentRequest(contextPath.addSegment("organization_PostComment").addKeys(new NameValue(postcommentid, UUID.class)), Optional.empty());
    }

    public PostcommentCollectionRequest organization_PostComment() {
        return new PostcommentCollectionRequest(
                        contextPath.addSegment("organization_PostComment"), Optional.empty());
    }

    public PostlikeRequest organization_postlike(UUID postlikeid) {
        return new PostlikeRequest(contextPath.addSegment("organization_postlike").addKeys(new NameValue(postlikeid, UUID.class)), Optional.empty());
    }

    public PostlikeCollectionRequest organization_postlike() {
        return new PostlikeCollectionRequest(
                        contextPath.addSegment("organization_postlike"), Optional.empty());
    }

    public ImportjobRequest organization_importjob(UUID importjobid) {
        return new ImportjobRequest(contextPath.addSegment("organization_importjob").addKeys(new NameValue(importjobid, UUID.class)), Optional.empty());
    }

    public ImportjobCollectionRequest organization_importjob() {
        return new ImportjobCollectionRequest(
                        contextPath.addSegment("organization_importjob"), Optional.empty());
    }

    public QueueRequest organization_queues(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("organization_queues").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public QueueCollectionRequest organization_queues() {
        return new QueueCollectionRequest(
                        contextPath.addSegment("organization_queues"), Optional.empty());
    }

    public CalendarRequest businessclosurecalendarid_calendar() {
        return new CalendarRequest(contextPath.addSegment("businessclosurecalendarid_calendar"), Optional.empty());
    }

    public PluginassemblyRequest organization_pluginassembly(UUID pluginassemblyid) {
        return new PluginassemblyRequest(contextPath.addSegment("organization_pluginassembly").addKeys(new NameValue(pluginassemblyid, UUID.class)), Optional.empty());
    }

    public PluginassemblyCollectionRequest organization_pluginassembly() {
        return new PluginassemblyCollectionRequest(
                        contextPath.addSegment("organization_pluginassembly"), Optional.empty());
    }

    public FieldsecurityprofileRequest lk_fieldsecurityprofile_organizationid(UUID fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("lk_fieldsecurityprofile_organizationid").addKeys(new NameValue(fieldsecurityprofileid, UUID.class)), Optional.empty());
    }

    public FieldsecurityprofileCollectionRequest lk_fieldsecurityprofile_organizationid() {
        return new FieldsecurityprofileCollectionRequest(
                        contextPath.addSegment("lk_fieldsecurityprofile_organizationid"), Optional.empty());
    }

    public SimilarityruleRequest organization_similarityrule(UUID similarityruleid) {
        return new SimilarityruleRequest(contextPath.addSegment("organization_similarityrule").addKeys(new NameValue(similarityruleid, UUID.class)), Optional.empty());
    }

    public SimilarityruleCollectionRequest organization_similarityrule() {
        return new SimilarityruleCollectionRequest(
                        contextPath.addSegment("organization_similarityrule"), Optional.empty());
    }

    public ExpiredprocessRequest organization_expiredprocess(UUID businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("organization_expiredprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public ExpiredprocessCollectionRequest organization_expiredprocess() {
        return new ExpiredprocessCollectionRequest(
                        contextPath.addSegment("organization_expiredprocess"), Optional.empty());
    }

    public AppconfiginstanceRequest organization_appconfiginstance(UUID appconfiginstanceid) {
        return new AppconfiginstanceRequest(contextPath.addSegment("organization_appconfiginstance").addKeys(new NameValue(appconfiginstanceid, UUID.class)), Optional.empty());
    }

    public AppconfiginstanceCollectionRequest organization_appconfiginstance() {
        return new AppconfiginstanceCollectionRequest(
                        contextPath.addSegment("organization_appconfiginstance"), Optional.empty());
    }

    public SavedqueryvisualizationRequest organization_saved_query_visualizations(UUID savedqueryvisualizationid) {
        return new SavedqueryvisualizationRequest(contextPath.addSegment("organization_saved_query_visualizations").addKeys(new NameValue(savedqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public SavedqueryvisualizationCollectionRequest organization_saved_query_visualizations() {
        return new SavedqueryvisualizationCollectionRequest(
                        contextPath.addSegment("organization_saved_query_visualizations"), Optional.empty());
    }

    public SystemuserRequest organization_system_users(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("organization_system_users").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest organization_system_users() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("organization_system_users"), Optional.empty());
    }

    public PublisherRequest organization_publisher(UUID publisherid) {
        return new PublisherRequest(contextPath.addSegment("organization_publisher").addKeys(new NameValue(publisherid, UUID.class)), Optional.empty());
    }

    public PublisherCollectionRequest organization_publisher() {
        return new PublisherCollectionRequest(
                        contextPath.addSegment("organization_publisher"), Optional.empty());
    }

    public PlugintypeRequest organization_plugintype(UUID plugintypeid) {
        return new PlugintypeRequest(contextPath.addSegment("organization_plugintype").addKeys(new NameValue(plugintypeid, UUID.class)), Optional.empty());
    }

    public PlugintypeCollectionRequest organization_plugintype() {
        return new PlugintypeCollectionRequest(
                        contextPath.addSegment("organization_plugintype"), Optional.empty());
    }

    public SyncerrorRequest organization_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Organization_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest organization_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Organization_SyncErrors"), Optional.empty());
    }

    public DataperformanceRequest lk_dataperformance_organizationid(UUID dataperformanceid) {
        return new DataperformanceRequest(contextPath.addSegment("lk_dataperformance_organizationid").addKeys(new NameValue(dataperformanceid, UUID.class)), Optional.empty());
    }

    public DataperformanceCollectionRequest lk_dataperformance_organizationid() {
        return new DataperformanceCollectionRequest(
                        contextPath.addSegment("lk_dataperformance_organizationid"), Optional.empty());
    }

    public ServiceendpointRequest organization_serviceendpoint(UUID serviceendpointid) {
        return new ServiceendpointRequest(contextPath.addSegment("organization_serviceendpoint").addKeys(new NameValue(serviceendpointid, UUID.class)), Optional.empty());
    }

    public ServiceendpointCollectionRequest organization_serviceendpoint() {
        return new ServiceendpointCollectionRequest(
                        contextPath.addSegment("organization_serviceendpoint"), Optional.empty());
    }

    public DisplaystringRequest organization_custom_displaystrings(UUID displaystringid) {
        return new DisplaystringRequest(contextPath.addSegment("organization_custom_displaystrings").addKeys(new NameValue(displaystringid, UUID.class)), Optional.empty());
    }

    public DisplaystringCollectionRequest organization_custom_displaystrings() {
        return new DisplaystringCollectionRequest(
                        contextPath.addSegment("organization_custom_displaystrings"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest organization_sdkmessageprocessingstep(UUID sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("organization_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest organization_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("organization_sdkmessageprocessingstep"), Optional.empty());
    }

    public PlugintypestatisticRequest organization_plugintypestatistic(UUID plugintypestatisticid) {
        return new PlugintypestatisticRequest(contextPath.addSegment("organization_plugintypestatistic").addKeys(new NameValue(plugintypestatisticid, UUID.class)), Optional.empty());
    }

    public PlugintypestatisticCollectionRequest organization_plugintypestatistic() {
        return new PlugintypestatisticCollectionRequest(
                        contextPath.addSegment("organization_plugintypestatistic"), Optional.empty());
    }

    public TransactioncurrencyRequest basecurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("basecurrencyid"), Optional.empty());
    }

    public AsyncoperationRequest organization_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Organization_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest organization_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Organization_AsyncOperations"), Optional.empty());
    }

    public EmailserverprofileRequest organization_emailserverprofile(UUID emailserverprofileid) {
        return new EmailserverprofileRequest(contextPath.addSegment("organization_emailserverprofile").addKeys(new NameValue(emailserverprofileid, UUID.class)), Optional.empty());
    }

    public EmailserverprofileCollectionRequest organization_emailserverprofile() {
        return new EmailserverprofileCollectionRequest(
                        contextPath.addSegment("organization_emailserverprofile"), Optional.empty());
    }

    public SavedqueryRequest organization_saved_queries(UUID savedqueryid) {
        return new SavedqueryRequest(contextPath.addSegment("organization_saved_queries").addKeys(new NameValue(savedqueryid, UUID.class)), Optional.empty());
    }

    public SavedqueryCollectionRequest organization_saved_queries() {
        return new SavedqueryCollectionRequest(
                        contextPath.addSegment("organization_saved_queries"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SitemapRequest organization_sitemap(UUID sitemapid) {
        return new SitemapRequest(contextPath.addSegment("organization_sitemap").addKeys(new NameValue(sitemapid, UUID.class)), Optional.empty());
    }

    public SitemapCollectionRequest organization_sitemap() {
        return new SitemapCollectionRequest(
                        contextPath.addSegment("organization_sitemap"), Optional.empty());
    }

    public TeamRequest organization_teams(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("organization_teams").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest organization_teams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("organization_teams"), Optional.empty());
    }

    public MobileofflineprofileRequest defaultmobileofflineprofileid() {
        return new MobileofflineprofileRequest(contextPath.addSegment("defaultmobileofflineprofileid"), Optional.empty());
    }

    public DocumenttemplateRequest lk_documenttemplatebase_organization(UUID documenttemplateid) {
        return new DocumenttemplateRequest(contextPath.addSegment("lk_documenttemplatebase_organization").addKeys(new NameValue(documenttemplateid, UUID.class)), Optional.empty());
    }

    public DocumenttemplateCollectionRequest lk_documenttemplatebase_organization() {
        return new DocumenttemplateCollectionRequest(
                        contextPath.addSegment("lk_documenttemplatebase_organization"), Optional.empty());
    }

    public QueueitemRequest organization_queueitems(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("organization_queueitems").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest organization_queueitems() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("organization_queueitems"), Optional.empty());
    }

    public ComplexcontrolRequest organization_complexcontrols(UUID complexcontrolid) {
        return new ComplexcontrolRequest(contextPath.addSegment("organization_complexcontrols").addKeys(new NameValue(complexcontrolid, UUID.class)), Optional.empty());
    }

    public ComplexcontrolCollectionRequest organization_complexcontrols() {
        return new ComplexcontrolCollectionRequest(
                        contextPath.addSegment("organization_complexcontrols"), Optional.empty());
    }

    public SolutionRequest organization_solution(UUID solutionid) {
        return new SolutionRequest(contextPath.addSegment("organization_solution").addKeys(new NameValue(solutionid, UUID.class)), Optional.empty());
    }

    public SolutionCollectionRequest organization_solution() {
        return new SolutionCollectionRequest(
                        contextPath.addSegment("organization_solution"), Optional.empty());
    }

    public BusinessunitRequest organization_business_units(UUID businessunitid) {
        return new BusinessunitRequest(contextPath.addSegment("organization_business_units").addKeys(new NameValue(businessunitid, UUID.class)), Optional.empty());
    }

    public BusinessunitCollectionRequest organization_business_units() {
        return new BusinessunitCollectionRequest(
                        contextPath.addSegment("organization_business_units"), Optional.empty());
    }

    public MobileofflineprofileRequest mobileOfflineProfile_organization(UUID mobileofflineprofileid) {
        return new MobileofflineprofileRequest(contextPath.addSegment("MobileOfflineProfile_organization").addKeys(new NameValue(mobileofflineprofileid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileCollectionRequest mobileOfflineProfile_organization() {
        return new MobileofflineprofileCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfile_organization"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SdkmessageprocessingstepimageRequest organization_sdkmessageprocessingstepimage(UUID sdkmessageprocessingstepimageid) {
        return new SdkmessageprocessingstepimageRequest(contextPath.addSegment("organization_sdkmessageprocessingstepimage").addKeys(new NameValue(sdkmessageprocessingstepimageid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepimageCollectionRequest organization_sdkmessageprocessingstepimage() {
        return new SdkmessageprocessingstepimageCollectionRequest(
                        contextPath.addSegment("organization_sdkmessageprocessingstepimage"), Optional.empty());
    }

    public CustomcontrolRequest customcontrol_organization(UUID customcontrolid) {
        return new CustomcontrolRequest(contextPath.addSegment("customcontrol_organization").addKeys(new NameValue(customcontrolid, UUID.class)), Optional.empty());
    }

    public CustomcontrolCollectionRequest customcontrol_organization() {
        return new CustomcontrolCollectionRequest(
                        contextPath.addSegment("customcontrol_organization"), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigRequest organization_sdkmessageprocessingstepsecureconfig(UUID sdkmessageprocessingstepsecureconfigid) {
        return new SdkmessageprocessingstepsecureconfigRequest(contextPath.addSegment("organization_sdkmessageprocessingstepsecureconfig").addKeys(new NameValue(sdkmessageprocessingstepsecureconfigid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigCollectionRequest organization_sdkmessageprocessingstepsecureconfig() {
        return new SdkmessageprocessingstepsecureconfigCollectionRequest(
                        contextPath.addSegment("organization_sdkmessageprocessingstepsecureconfig"), Optional.empty());
    }

    public RoleRequest organization_roles(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("organization_roles").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest organization_roles() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("organization_roles"), Optional.empty());
    }

    public AppconfigmasterRequest organization_appconfigmaster(UUID appconfigmasterid) {
        return new AppconfigmasterRequest(contextPath.addSegment("organization_appconfigmaster").addKeys(new NameValue(appconfigmasterid, UUID.class)), Optional.empty());
    }

    public AppconfigmasterCollectionRequest organization_appconfigmaster() {
        return new AppconfigmasterCollectionRequest(
                        contextPath.addSegment("organization_appconfigmaster"), Optional.empty());
    }

    public MobileofflineprofileitemassociationRequest mobileOfflineProfileItemAssociation_organization(UUID mobileofflineprofileitemassociationid) {
        return new MobileofflineprofileitemassociationRequest(contextPath.addSegment("MobileOfflineProfileItemAssociation_organization").addKeys(new NameValue(mobileofflineprofileitemassociationid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileitemassociationCollectionRequest mobileOfflineProfileItemAssociation_organization() {
        return new MobileofflineprofileitemassociationCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfileItemAssociation_organization"), Optional.empty());
    }

    public MailboxtrackingfolderRequest organization_MailboxTrackingFolder(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("Organization_MailboxTrackingFolder").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest organization_MailboxTrackingFolder() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("Organization_MailboxTrackingFolder"), Optional.empty());
    }

    public BulkdeletefailureRequest organization_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Organization_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest organization_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Organization_BulkDeleteFailures"), Optional.empty());
    }

    public TranslationprocessRequest organization_translationprocess(UUID businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("organization_translationprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public TranslationprocessCollectionRequest organization_translationprocess() {
        return new TranslationprocessCollectionRequest(
                        contextPath.addSegment("organization_translationprocess"), Optional.empty());
    }

    public TracelogRequest organization_tracelog(UUID tracelogid) {
        return new TracelogRequest(contextPath.addSegment("organization_tracelog").addKeys(new NameValue(tracelogid, UUID.class)), Optional.empty());
    }

    public TracelogCollectionRequest organization_tracelog() {
        return new TracelogCollectionRequest(
                        contextPath.addSegment("organization_tracelog"), Optional.empty());
    }

    public SystemformRequest organization_systemforms(UUID formid) {
        return new SystemformRequest(contextPath.addSegment("organization_systemforms").addKeys(new NameValue(formid, UUID.class)), Optional.empty());
    }

    public SystemformCollectionRequest organization_systemforms() {
        return new SystemformCollectionRequest(
                        contextPath.addSegment("organization_systemforms"), Optional.empty());
    }

    public BusinessunitnewsarticleRequest organization_business_unit_news_articles(UUID businessunitnewsarticleid) {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("organization_business_unit_news_articles").addKeys(new NameValue(businessunitnewsarticleid, UUID.class)), Optional.empty());
    }

    public BusinessunitnewsarticleCollectionRequest organization_business_unit_news_articles() {
        return new BusinessunitnewsarticleCollectionRequest(
                        contextPath.addSegment("organization_business_unit_news_articles"), Optional.empty());
    }

    public KbarticleRequest organization_kb_articles(UUID kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("organization_kb_articles").addKeys(new NameValue(kbarticleid, UUID.class)), Optional.empty());
    }

    public KbarticleCollectionRequest organization_kb_articles() {
        return new KbarticleCollectionRequest(
                        contextPath.addSegment("organization_kb_articles"), Optional.empty());
    }

    public SdkmessageRequest organization_sdkmessage(UUID sdkmessageid) {
        return new SdkmessageRequest(contextPath.addSegment("organization_sdkmessage").addKeys(new NameValue(sdkmessageid, UUID.class)), Optional.empty());
    }

    public SdkmessageCollectionRequest organization_sdkmessage() {
        return new SdkmessageCollectionRequest(
                        contextPath.addSegment("organization_sdkmessage"), Optional.empty());
    }

    public MobileofflineprofileitemRequest mobileOfflineProfileItem_organization(UUID mobileofflineprofileitemid) {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("MobileOfflineProfileItem_organization").addKeys(new NameValue(mobileofflineprofileitemid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileitemCollectionRequest mobileOfflineProfileItem_organization() {
        return new MobileofflineprofileitemCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfileItem_organization"), Optional.empty());
    }

    public EmailserverprofileRequest defaultemailserverprofileid() {
        return new EmailserverprofileRequest(contextPath.addSegment("defaultemailserverprofileid"), Optional.empty());
    }

    public KbarticletemplateRequest organization_kb_article_templates(UUID kbarticletemplateid) {
        return new KbarticletemplateRequest(contextPath.addSegment("organization_kb_article_templates").addKeys(new NameValue(kbarticletemplateid, UUID.class)), Optional.empty());
    }

    public KbarticletemplateCollectionRequest organization_kb_article_templates() {
        return new KbarticletemplateCollectionRequest(
                        contextPath.addSegment("organization_kb_article_templates"), Optional.empty());
    }

    public CustomcontrolresourceRequest customcontrolresource_organization(UUID customcontrolresourceid) {
        return new CustomcontrolresourceRequest(contextPath.addSegment("customcontrolresource_organization").addKeys(new NameValue(customcontrolresourceid, UUID.class)), Optional.empty());
    }

    public CustomcontrolresourceCollectionRequest customcontrolresource_organization() {
        return new CustomcontrolresourceCollectionRequest(
                        contextPath.addSegment("customcontrolresource_organization"), Optional.empty());
    }

    public MailboxRequest organization_mailbox(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("organization_mailbox").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest organization_mailbox() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("organization_mailbox"), Optional.empty());
    }

    public CalendarRequest organization_calendars(UUID calendarid) {
        return new CalendarRequest(contextPath.addSegment("organization_calendars").addKeys(new NameValue(calendarid, UUID.class)), Optional.empty());
    }

    public CalendarCollectionRequest organization_calendars() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("organization_calendars"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public WebwizardRequest organization_webwizard(UUID webwizardid) {
        return new WebwizardRequest(contextPath.addSegment("organization_webwizard").addKeys(new NameValue(webwizardid, UUID.class)), Optional.empty());
    }

    public WebwizardCollectionRequest organization_webwizard() {
        return new WebwizardCollectionRequest(
                        contextPath.addSegment("organization_webwizard"), Optional.empty());
    }

    public ConnectionroleRequest organization_connection_roles(UUID connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("organization_connection_roles").addKeys(new NameValue(connectionroleid, UUID.class)), Optional.empty());
    }

    public ConnectionroleCollectionRequest organization_connection_roles() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("organization_connection_roles"), Optional.empty());
    }

    public CustomcontroldefaultconfigRequest customcontroldefaultconfig_organization(UUID customcontroldefaultconfigid) {
        return new CustomcontroldefaultconfigRequest(contextPath.addSegment("customcontroldefaultconfig_organization").addKeys(new NameValue(customcontroldefaultconfigid, UUID.class)), Optional.empty());
    }

    public CustomcontroldefaultconfigCollectionRequest customcontroldefaultconfig_organization() {
        return new CustomcontroldefaultconfigCollectionRequest(
                        contextPath.addSegment("customcontroldefaultconfig_organization"), Optional.empty());
    }

    public TransactioncurrencyRequest organization_transactioncurrencies(UUID transactioncurrencyid) {
        return new TransactioncurrencyRequest(contextPath.addSegment("organization_transactioncurrencies").addKeys(new NameValue(transactioncurrencyid, UUID.class)), Optional.empty());
    }

    public TransactioncurrencyCollectionRequest organization_transactioncurrencies() {
        return new TransactioncurrencyCollectionRequest(
                        contextPath.addSegment("organization_transactioncurrencies"), Optional.empty());
    }

    public TemplateRequest acknowledgementtemplateid() {
        return new TemplateRequest(contextPath.addSegment("acknowledgementtemplateid"), Optional.empty());
    }

    public NewprocessRequest organization_newprocess(UUID businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("organization_newprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public NewprocessCollectionRequest organization_newprocess() {
        return new NewprocessCollectionRequest(
                        contextPath.addSegment("organization_newprocess"), Optional.empty());
    }

    public AciviewmapperRequest organization_aciviewmapper(UUID aciviewmapperid) {
        return new AciviewmapperRequest(contextPath.addSegment("organization_aciviewmapper").addKeys(new NameValue(aciviewmapperid, UUID.class)), Optional.empty());
    }

    public AciviewmapperCollectionRequest organization_aciviewmapper() {
        return new AciviewmapperCollectionRequest(
                        contextPath.addSegment("organization_aciviewmapper"), Optional.empty());
    }

    public LanguagelocaleRequest languagelocale_organization(UUID languagelocaleid) {
        return new LanguagelocaleRequest(contextPath.addSegment("languagelocale_organization").addKeys(new NameValue(languagelocaleid, UUID.class)), Optional.empty());
    }

    public LanguagelocaleCollectionRequest languagelocale_organization() {
        return new LanguagelocaleCollectionRequest(
                        contextPath.addSegment("languagelocale_organization"), Optional.empty());
    }

    public AppconfigRequest organization_appconfig(UUID appconfigid) {
        return new AppconfigRequest(contextPath.addSegment("organization_appconfig").addKeys(new NameValue(appconfigid, UUID.class)), Optional.empty());
    }

    public AppconfigCollectionRequest organization_appconfig() {
        return new AppconfigCollectionRequest(
                        contextPath.addSegment("organization_appconfig"), Optional.empty());
    }

    public AppmoduleRequest organization_appmodule(UUID appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("organization_appmodule").addKeys(new NameValue(appmoduleid, UUID.class)), Optional.empty());
    }

    public AppmoduleCollectionRequest organization_appmodule() {
        return new AppmoduleCollectionRequest(
                        contextPath.addSegment("organization_appmodule"), Optional.empty());
    }

    public NavigationsettingRequest organization_navigationsetting(UUID navigationsettingid) {
        return new NavigationsettingRequest(contextPath.addSegment("organization_navigationsetting").addKeys(new NameValue(navigationsettingid, UUID.class)), Optional.empty());
    }

    public NavigationsettingCollectionRequest organization_navigationsetting() {
        return new NavigationsettingCollectionRequest(
                        contextPath.addSegment("organization_navigationsetting"), Optional.empty());
    }

    public SubjectRequest organization_subjects(UUID subjectid) {
        return new SubjectRequest(contextPath.addSegment("organization_subjects").addKeys(new NameValue(subjectid, UUID.class)), Optional.empty());
    }

    public SubjectCollectionRequest organization_subjects() {
        return new SubjectCollectionRequest(
                        contextPath.addSegment("organization_subjects"), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationRequest organization_solutioncomponentattributeconfiguration(UUID solutioncomponentattributeconfigurationid) {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("organization_solutioncomponentattributeconfiguration").addKeys(new NameValue(solutioncomponentattributeconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationCollectionRequest organization_solutioncomponentattributeconfiguration() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(
                        contextPath.addSegment("organization_solutioncomponentattributeconfiguration"), Optional.empty());
    }

    public SolutioncomponentconfigurationRequest organization_solutioncomponentconfiguration(UUID solutioncomponentconfigurationid) {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("organization_solutioncomponentconfiguration").addKeys(new NameValue(solutioncomponentconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentconfigurationCollectionRequest organization_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationCollectionRequest(
                        contextPath.addSegment("organization_solutioncomponentconfiguration"), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationRequest organization_solutioncomponentrelationshipconfiguration(UUID solutioncomponentrelationshipconfigurationid) {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("organization_solutioncomponentrelationshipconfiguration").addKeys(new NameValue(solutioncomponentrelationshipconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationCollectionRequest organization_solutioncomponentrelationshipconfiguration() {
        return new SolutioncomponentrelationshipconfigurationCollectionRequest(
                        contextPath.addSegment("organization_solutioncomponentrelationshipconfiguration"), Optional.empty());
    }

    public EntityanalyticsconfigRequest organization_entityanalyticsconfig(UUID entityanalyticsconfigid) {
        return new EntityanalyticsconfigRequest(contextPath.addSegment("organization_entityanalyticsconfig").addKeys(new NameValue(entityanalyticsconfigid, UUID.class)), Optional.empty());
    }

    public EntityanalyticsconfigCollectionRequest organization_entityanalyticsconfig() {
        return new EntityanalyticsconfigCollectionRequest(
                        contextPath.addSegment("organization_entityanalyticsconfig"), Optional.empty());
    }

    public DatalakeworkspaceRequest organization_datalakeworkspace(UUID datalakeworkspaceid) {
        return new DatalakeworkspaceRequest(contextPath.addSegment("organization_datalakeworkspace").addKeys(new NameValue(datalakeworkspaceid, UUID.class)), Optional.empty());
    }

    public DatalakeworkspaceCollectionRequest organization_datalakeworkspace() {
        return new DatalakeworkspaceCollectionRequest(
                        contextPath.addSegment("organization_datalakeworkspace"), Optional.empty());
    }

    public DatalakeworkspacepermissionRequest organization_datalakeworkspacepermission(UUID datalakeworkspacepermissionid) {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("organization_datalakeworkspacepermission").addKeys(new NameValue(datalakeworkspacepermissionid, UUID.class)), Optional.empty());
    }

    public DatalakeworkspacepermissionCollectionRequest organization_datalakeworkspacepermission() {
        return new DatalakeworkspacepermissionCollectionRequest(
                        contextPath.addSegment("organization_datalakeworkspacepermission"), Optional.empty());
    }

    public Msdyn_helppageRequest organization_msdyn_helppage(UUID msdyn_helppageid) {
        return new Msdyn_helppageRequest(contextPath.addSegment("organization_msdyn_helppage").addKeys(new NameValue(msdyn_helppageid, UUID.class)), Optional.empty());
    }

    public Msdyn_helppageCollectionRequest organization_msdyn_helppage() {
        return new Msdyn_helppageCollectionRequest(
                        contextPath.addSegment("organization_msdyn_helppage"), Optional.empty());
    }

    public TerritoryRequest organization_territories(UUID territoryid) {
        return new TerritoryRequest(contextPath.addSegment("organization_territories").addKeys(new NameValue(territoryid, UUID.class)), Optional.empty());
    }

    public TerritoryCollectionRequest organization_territories() {
        return new TerritoryCollectionRequest(
                        contextPath.addSegment("organization_territories"), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetRequest organization_msdyn_solutionhealthruleset(UUID msdyn_solutionhealthrulesetid) {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("organization_msdyn_solutionhealthruleset").addKeys(new NameValue(msdyn_solutionhealthrulesetid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetCollectionRequest organization_msdyn_solutionhealthruleset() {
        return new Msdyn_solutionhealthrulesetCollectionRequest(
                        contextPath.addSegment("organization_msdyn_solutionhealthruleset"), Optional.empty());
    }

}
