package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Navigationsetting;

@JsonIgnoreType
public class NavigationsettingRequest extends EntityRequest<Navigationsetting> {

    public NavigationsettingRequest(ContextPath contextPath, Optional<Object> value) {
        super(Navigationsetting.class, contextPath, value, false);
    }

    public SystemuserRequest navigationsetting_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("navigationsetting_modifiedby"), Optional.empty());
    }

    public SystemuserRequest navigationsetting_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("navigationsetting_createdonbehalfby"), Optional.empty());
    }

    public AppconfigRequest navigationsetting_appconfig() {
        return new AppconfigRequest(contextPath.addSegment("navigationsetting_appconfig"), Optional.empty());
    }

    public SystemuserRequest navigationsetting_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("navigationsetting_modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest navigationsetting_createdby() {
        return new SystemuserRequest(contextPath.addSegment("navigationsetting_createdby"), Optional.empty());
    }

    public OrganizationRequest organization_navigationsetting_navigationsetting() {
        return new OrganizationRequest(contextPath.addSegment("organization_navigationsetting_navigationsetting"), Optional.empty());
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Navigationsetting> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Navigationsetting>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Navigationsetting.class, _parameters);
    }

}
