package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_analysiscomponent;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class Msdyn_analysiscomponentRequest extends EntityRequest<Msdyn_analysiscomponent> {

    public Msdyn_analysiscomponentRequest(ContextPath contextPath, Optional<Object> value) {
        super(Msdyn_analysiscomponent.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorRequest msdyn_analysiscomponent_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_analysiscomponent_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_analysiscomponent_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_analysiscomponent_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_analysiscomponent_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_analysiscomponent_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_analysiscomponent_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_analysiscomponent_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_analysiscomponent_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_analysiscomponent_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_analysiscomponent_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_analysiscomponent_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_analysiscomponent_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_analysiscomponent_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_analysiscomponent_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_analysiscomponent_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_analysiscomponent_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_analysiscomponent_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_analysiscomponent_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_analysiscomponent_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_analysiscomponent_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_analysiscomponent_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_analysiscomponent_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_analysiscomponent_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public Msdyn_analysisresultRequest msdyn_analysiscomponent_msdyn_analysisresult(UUID msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("msdyn_analysiscomponent_msdyn_analysisresult").addKeys(new NameValue(msdyn_analysisresultid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultCollectionRequest msdyn_analysiscomponent_msdyn_analysisresult() {
        return new Msdyn_analysisresultCollectionRequest(
                        contextPath.addSegment("msdyn_analysiscomponent_msdyn_analysisresult"), Optional.empty());
    }

    public Msdyn_analysisjobRequest msdyn_AnalysisJobId() {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("msdyn_AnalysisJobId"), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetRequest msdyn_SolutionHealthRuleSetId() {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("msdyn_SolutionHealthRuleSetId"), Optional.empty());
    }

}
