package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Kbarticletemplate;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class KbarticletemplateRequest extends EntityRequest<Kbarticletemplate> {

    public KbarticletemplateRequest(ContextPath contextPath, Optional<Object> value) {
        super(Kbarticletemplate.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public ProcesssessionRequest kbArticleTemplate_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("KbArticleTemplate_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest kbArticleTemplate_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("KbArticleTemplate_ProcessSessions"), Optional.empty());
    }

    public AsyncoperationRequest kbArticleTemplate_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("KbArticleTemplate_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest kbArticleTemplate_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("KbArticleTemplate_AsyncOperations"), Optional.empty());
    }

    public KbarticleRequest kb_article_template_kb_articles(UUID kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("kb_article_template_kb_articles").addKeys(new NameValue(kbarticleid, UUID.class)), Optional.empty());
    }

    public KbarticleCollectionRequest kb_article_template_kb_articles() {
        return new KbarticleCollectionRequest(
                        contextPath.addSegment("kb_article_template_kb_articles"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SyncerrorRequest kbArticleTemplate_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("KbArticleTemplate_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest kbArticleTemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("KbArticleTemplate_SyncErrors"), Optional.empty());
    }

    public BulkdeletefailureRequest kbArticleTemplate_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("KbArticleTemplate_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest kbArticleTemplate_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("KbArticleTemplate_BulkDeleteFailures"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

}
