package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Kbarticle;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticlecommentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class KbarticleRequest extends EntityRequest<Kbarticle> {

    public KbarticleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Kbarticle.class, contextPath, value, false);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public AnnotationRequest kbArticle_Annotation(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("KbArticle_Annotation").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest kbArticle_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("KbArticle_Annotation"), Optional.empty());
    }

    public BulkdeletefailureRequest kbArticle_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("KbArticle_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest kbArticle_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("KbArticle_BulkDeleteFailures"), Optional.empty());
    }

    public AsyncoperationRequest kbArticle_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("KbArticle_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest kbArticle_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("KbArticle_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest kbArticle_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("KbArticle_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest kbArticle_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("KbArticle_ProcessSessions"), Optional.empty());
    }

    public DuplicaterecordRequest kbArticle_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("KbArticle_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest kbArticle_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("KbArticle_DuplicateMatchingRecord"), Optional.empty());
    }

    public KbarticletemplateRequest kbarticletemplateid() {
        return new KbarticletemplateRequest(contextPath.addSegment("kbarticletemplateid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest kbarticle_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("kbarticle_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest kbarticle_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("kbarticle_principalobjectattributeaccess"), Optional.empty());
    }

    public DuplicaterecordRequest kbArticle_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("KbArticle_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest kbArticle_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("KbArticle_DuplicateBaseRecord"), Optional.empty());
    }

    public SharepointdocumentlocationRequest kbArticle_SharepointDocumentLocation(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("KbArticle_SharepointDocumentLocation").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest kbArticle_SharepointDocumentLocation() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("KbArticle_SharepointDocumentLocation"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public KbarticlecommentRequest kbarticle_comments(UUID kbarticlecommentid) {
        return new KbarticlecommentRequest(contextPath.addSegment("kbarticle_comments").addKeys(new NameValue(kbarticlecommentid, UUID.class)), Optional.empty());
    }

    public KbarticlecommentCollectionRequest kbarticle_comments() {
        return new KbarticlecommentCollectionRequest(
                        contextPath.addSegment("kbarticle_comments"), Optional.empty());
    }

    public SyncerrorRequest kbArticle_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("KbArticle_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest kbArticle_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("KbArticle_SyncErrors"), Optional.empty());
    }

    public SubjectRequest subjectid() {
        return new SubjectRequest(contextPath.addSegment("subjectid"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

}
