package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.ExportMappingsImportMapResponse;
import microsoft.dynamics.crm.entity.Importmap;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ColumnmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportentitymappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OwnermappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TransformationmappingCollectionRequest;

@JsonIgnoreType
public class ImportmapRequest extends EntityRequest<Importmap> {

    public ImportmapRequest(ContextPath contextPath, Optional<Object> value) {
        super(Importmap.class, contextPath, value, false);
    }

    public SyncerrorRequest importMap_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ImportMap_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest importMap_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ImportMap_SyncErrors"), Optional.empty());
    }

    public ColumnmappingRequest columnMapping_ImportMap(UUID columnmappingid) {
        return new ColumnmappingRequest(contextPath.addSegment("ColumnMapping_ImportMap").addKeys(new NameValue(columnmappingid, UUID.class)), Optional.empty());
    }

    public ColumnmappingCollectionRequest columnMapping_ImportMap() {
        return new ColumnmappingCollectionRequest(
                        contextPath.addSegment("ColumnMapping_ImportMap"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public AsyncoperationRequest importMap_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ImportMap_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest importMap_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("ImportMap_AsyncOperations"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public ImportentitymappingRequest importEntityMapping_ImportMap(UUID importentitymappingid) {
        return new ImportentitymappingRequest(contextPath.addSegment("ImportEntityMapping_ImportMap").addKeys(new NameValue(importentitymappingid, UUID.class)), Optional.empty());
    }

    public ImportentitymappingCollectionRequest importEntityMapping_ImportMap() {
        return new ImportentitymappingCollectionRequest(
                        contextPath.addSegment("ImportEntityMapping_ImportMap"), Optional.empty());
    }

    public BulkdeletefailureRequest importMap_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ImportMap_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest importMap_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("ImportMap_BulkDeleteFailures"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public OwnermappingRequest ownerMapping_ImportMap(UUID ownermappingid) {
        return new OwnermappingRequest(contextPath.addSegment("OwnerMapping_ImportMap").addKeys(new NameValue(ownermappingid, UUID.class)), Optional.empty());
    }

    public OwnermappingCollectionRequest ownerMapping_ImportMap() {
        return new OwnermappingCollectionRequest(
                        contextPath.addSegment("OwnerMapping_ImportMap"), Optional.empty());
    }

    public ImportfileRequest importMap_ImportFile(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("ImportMap_ImportFile").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest importMap_ImportFile() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("ImportMap_ImportFile"), Optional.empty());
    }

    public TransformationmappingRequest transformationMapping_ImportMap(UUID transformationmappingid) {
        return new TransformationmappingRequest(contextPath.addSegment("TransformationMapping_ImportMap").addKeys(new NameValue(transformationmappingid, UUID.class)), Optional.empty());
    }

    public TransformationmappingCollectionRequest transformationMapping_ImportMap() {
        return new TransformationmappingCollectionRequest(
                        contextPath.addSegment("TransformationMapping_ImportMap"), Optional.empty());
    }

    @Action(name = "ExportMappingsImportMap")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExportMappingsImportMapResponse> exportMappingsImportMap(Boolean exportIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExportIds", "Edm.Boolean", exportIds)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExportMappingsImportMapResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExportMappingsImportMap"), ExportMappingsImportMapResponse.class, _parameters);
    }

}
