package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Entity;
import microsoft.dynamics.crm.entity.collection.request.EntityanalyticsconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentconfigurationCollectionRequest;

@JsonIgnoreType
public class EntityRequest extends com.github.davidmoten.odata.client.EntityRequest<Entity> {

    public EntityRequest(ContextPath contextPath, Optional<Object> value) {
        super(Entity.class, contextPath, value, false);
    }

    public SolutioncomponentconfigurationRequest entity_solutioncomponentconfiguration(UUID solutioncomponentconfigurationid) {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("entity_solutioncomponentconfiguration").addKeys(new NameValue(solutioncomponentconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentconfigurationCollectionRequest entity_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationCollectionRequest(
                        contextPath.addSegment("entity_solutioncomponentconfiguration"), Optional.empty());
    }

    public EntityanalyticsconfigRequest entity_entityanalyticsconfig(UUID entityanalyticsconfigid) {
        return new EntityanalyticsconfigRequest(contextPath.addSegment("entity_entityanalyticsconfig").addKeys(new NameValue(entityanalyticsconfigid, UUID.class)), Optional.empty());
    }

    public EntityanalyticsconfigCollectionRequest entity_entityanalyticsconfig() {
        return new EntityanalyticsconfigCollectionRequest(
                        contextPath.addSegment("entity_entityanalyticsconfig"), Optional.empty());
    }

}
