package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Emailserverprofile;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OrganizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TracelogCollectionRequest;

@JsonIgnoreType
public class EmailserverprofileRequest extends EntityRequest<Emailserverprofile> {

    public EmailserverprofileRequest(ContextPath contextPath, Optional<Object> value) {
        super(Emailserverprofile.class, contextPath, value, false);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public MailboxRequest emailserverprofile_mailbox(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("emailserverprofile_mailbox").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest emailserverprofile_mailbox() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("emailserverprofile_mailbox"), Optional.empty());
    }

    public AsyncoperationRequest emailserverprofile_asyncoperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("emailserverprofile_asyncoperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest emailserverprofile_asyncoperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("emailserverprofile_asyncoperations"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BulkdeletefailureRequest emailserverprofile_bulkdeletefailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("emailserverprofile_bulkdeletefailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest emailserverprofile_bulkdeletefailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("emailserverprofile_bulkdeletefailures"), Optional.empty());
    }

    public OrganizationRequest emailServerProfile_Organization(UUID organizationid) {
        return new OrganizationRequest(contextPath.addSegment("EmailServerProfile_Organization").addKeys(new NameValue(organizationid, UUID.class)), Optional.empty());
    }

    public OrganizationCollectionRequest emailServerProfile_Organization() {
        return new OrganizationCollectionRequest(
                        contextPath.addSegment("EmailServerProfile_Organization"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public TracelogRequest tracelog_EmailServerProfile(UUID tracelogid) {
        return new TracelogRequest(contextPath.addSegment("tracelog_EmailServerProfile").addKeys(new NameValue(tracelogid, UUID.class)), Optional.empty());
    }

    public TracelogCollectionRequest tracelog_EmailServerProfile() {
        return new TracelogCollectionRequest(
                        contextPath.addSegment("tracelog_EmailServerProfile"), Optional.empty());
    }

    public AnnotationRequest emailServerProfile_Annotation(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("EmailServerProfile_Annotation").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest emailServerProfile_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("EmailServerProfile_Annotation"), Optional.empty());
    }

    public DuplicaterecordRequest emailserverprofile_duplicatematchingrecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("emailserverprofile_duplicatematchingrecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest emailserverprofile_duplicatematchingrecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("emailserverprofile_duplicatematchingrecord"), Optional.empty());
    }

    public SyncerrorRequest emailServerProfile_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("EmailServerProfile_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest emailServerProfile_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("EmailServerProfile_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest emailserverprofile_duplicatebaserecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("emailserverprofile_duplicatebaserecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest emailserverprofile_duplicatebaserecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("emailserverprofile_duplicatebaserecord"), Optional.empty());
    }

}
