package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Connectionrole;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionroleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class ConnectionroleRequest extends EntityRequest<Connectionrole> {

    public ConnectionroleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Connectionrole.class, contextPath, value, false);
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public ProcesssessionRequest connectionRole_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("ConnectionRole_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest connectionRole_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("ConnectionRole_ProcessSessions"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public AsyncoperationRequest connection_Role_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Connection_Role_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest connection_Role_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Connection_Role_AsyncOperations"), Optional.empty());
    }

    public ConnectionRequest connection_role_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("connection_role_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest connection_role_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("connection_role_connections2"), Optional.empty());
    }

    public SyncerrorRequest connectionRole_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ConnectionRole_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest connectionRole_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ConnectionRole_SyncErrors"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public ConnectionRequest connection_role_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("connection_role_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest connection_role_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("connection_role_connections1"), Optional.empty());
    }

    public ConnectionroleRequest connectionroleassociation_association(UUID connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("connectionroleassociation_association").addKeys(new NameValue(connectionroleid, UUID.class)), Optional.empty());
    }

    public ConnectionroleCollectionRequest connectionroleassociation_association() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("connectionroleassociation_association"), Optional.empty());
    }

    public ConnectionroleRequest connectionroleassociation_association_referenced(UUID connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("connectionroleassociation_association_referenced").addKeys(new NameValue(connectionroleid, UUID.class)), Optional.empty());
    }

    public ConnectionroleCollectionRequest connectionroleassociation_association_referenced() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("connectionroleassociation_association_referenced"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

}
