package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Connection;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class ConnectionRequest extends EntityRequest<Connection> {

    public ConnectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Connection.class, contextPath, value, false);
    }

    public KnowledgearticleRequest record1id_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("record1id_knowledgearticle"), Optional.empty());
    }

    public KnowledgearticleRequest record2id_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("record2id_knowledgearticle"), Optional.empty());
    }

    public KnowledgebaserecordRequest record1id_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("record1id_knowledgebaserecord"), Optional.empty());
    }

    public KnowledgebaserecordRequest record2id_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("record2id_knowledgebaserecord"), Optional.empty());
    }

    public ContactRequest record1id_contact() {
        return new ContactRequest(contextPath.addSegment("record1id_contact"), Optional.empty());
    }

    public SocialactivityRequest record2id_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("record2id_socialactivity"), Optional.empty());
    }

    public TaskRequest record2id_task() {
        return new TaskRequest(contextPath.addSegment("record2id_task"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest record1id_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("record1id_systemuser"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public AccountRequest record2id_account() {
        return new AccountRequest(contextPath.addSegment("record2id_account"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest record2id_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("record2id_systemuser"), Optional.empty());
    }

    public TeamRequest record2id_team() {
        return new TeamRequest(contextPath.addSegment("record2id_team"), Optional.empty());
    }

    public LetterRequest record2id_letter() {
        return new LetterRequest(contextPath.addSegment("record2id_letter"), Optional.empty());
    }

    public EmailRequest record1id_email() {
        return new EmailRequest(contextPath.addSegment("record1id_email"), Optional.empty());
    }

    public SocialprofileRequest record1id_socialprofile() {
        return new SocialprofileRequest(contextPath.addSegment("record1id_socialprofile"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest connection_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("connection_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest connection_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("connection_principalobjectattributeaccess"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public TaskRequest record1id_task() {
        return new TaskRequest(contextPath.addSegment("record1id_task"), Optional.empty());
    }

    public EmailRequest record2id_email() {
        return new EmailRequest(contextPath.addSegment("record2id_email"), Optional.empty());
    }

    public SocialprofileRequest record2id_socialprofile() {
        return new SocialprofileRequest(contextPath.addSegment("record2id_socialprofile"), Optional.empty());
    }

    public TeamRequest record1id_team() {
        return new TeamRequest(contextPath.addSegment("record1id_team"), Optional.empty());
    }

    public ConnectionroleRequest record2roleid() {
        return new ConnectionroleRequest(contextPath.addSegment("record2roleid"), Optional.empty());
    }

    public GoalRequest record2id_goal() {
        return new GoalRequest(contextPath.addSegment("record2id_goal"), Optional.empty());
    }

    public PositionRequest record1id_position() {
        return new PositionRequest(contextPath.addSegment("record1id_position"), Optional.empty());
    }

    public RecurringappointmentmasterRequest record1id_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("record1id_recurringappointmentmaster"), Optional.empty());
    }

    public ProcesssessionRequest record1id_processsession() {
        return new ProcesssessionRequest(contextPath.addSegment("record1id_processsession"), Optional.empty());
    }

    public AsyncoperationRequest connection_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Connection_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest connection_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Connection_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest connection_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Connection_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest connection_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Connection_ProcessSessions"), Optional.empty());
    }

    public AppointmentRequest record1id_appointment() {
        return new AppointmentRequest(contextPath.addSegment("record1id_appointment"), Optional.empty());
    }

    public FaxRequest record2id_fax() {
        return new FaxRequest(contextPath.addSegment("record2id_fax"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public ConnectionRequest relatedconnectionid() {
        return new ConnectionRequest(contextPath.addSegment("relatedconnectionid"), Optional.empty());
    }

    public ConnectionRequest connection_related_connection(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("connection_related_connection").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest connection_related_connection() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("connection_related_connection"), Optional.empty());
    }

    public RecurringappointmentmasterRequest record2id_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("record2id_recurringappointmentmaster"), Optional.empty());
    }

    public PhonecallRequest record1id_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("record1id_phonecall"), Optional.empty());
    }

    public AppointmentRequest record2id_appointment() {
        return new AppointmentRequest(contextPath.addSegment("record2id_appointment"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public GoalRequest record1id_goal() {
        return new GoalRequest(contextPath.addSegment("record1id_goal"), Optional.empty());
    }

    public SocialactivityRequest record1id_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("record1id_socialactivity"), Optional.empty());
    }

    public FaxRequest record1id_fax() {
        return new FaxRequest(contextPath.addSegment("record1id_fax"), Optional.empty());
    }

    public PositionRequest record2id_position() {
        return new PositionRequest(contextPath.addSegment("record2id_position"), Optional.empty());
    }

    public ConnectionroleRequest record1roleid() {
        return new ConnectionroleRequest(contextPath.addSegment("record1roleid"), Optional.empty());
    }

    public LetterRequest record1id_letter() {
        return new LetterRequest(contextPath.addSegment("record1id_letter"), Optional.empty());
    }

    public ProcesssessionRequest record2id_processsession() {
        return new ProcesssessionRequest(contextPath.addSegment("record2id_processsession"), Optional.empty());
    }

    public SyncerrorRequest connection_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Connection_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest connection_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Connection_SyncErrors"), Optional.empty());
    }

    public ActivitypointerRequest record2id_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("record2id_activitypointer"), Optional.empty());
    }

    public AccountRequest record1id_account() {
        return new AccountRequest(contextPath.addSegment("record1id_account"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public ContactRequest record2id_contact() {
        return new ContactRequest(contextPath.addSegment("record2id_contact"), Optional.empty());
    }

    public ActivitypointerRequest record1id_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("record1id_activitypointer"), Optional.empty());
    }

    public PhonecallRequest record2id_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("record2id_phonecall"), Optional.empty());
    }

    public TerritoryRequest record1id_territory() {
        return new TerritoryRequest(contextPath.addSegment("record1id_territory"), Optional.empty());
    }

    public TerritoryRequest record2id_territory() {
        return new TerritoryRequest(contextPath.addSegment("record2id_territory"), Optional.empty());
    }

}
